/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ConvertAlignmentCoordinatesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ConvertAlignmentCoordinatesPlugin.class);
    private String myMapFilename = null;
    private final HashMap<String, Chromosome> myLociMap = new HashMap();
    private final HashMap<String, Chromosome> myAlignmentLociMap = new HashMap();

    public ConvertAlignmentCoordinatesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() != 1) {
                String gpMessage = "Invalid selection.  Please select one genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum current = alignInList.get(0);
            Datum result = this.processDatum(current);
            DataSet output = new DataSet(result, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, ConvertAlignmentCoordinatesPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum processDatum(Datum input) {
        if (this.myMapFilename == null || this.myMapFilename.length() == 0) {
            throw new IllegalStateException("ConvertAlignmentCoordinatesPlugin: processDatum: map filename not set.");
        }
        GenotypeTable alignment = null;
        if (!(input.getData() instanceof GenotypeTable)) {
            throw new IllegalStateException("ConvertAlignmentCoordinatesPlugin: processDatum: datum must be instanceof Alignment.");
        }
        alignment = (GenotypeTable)input.getData();
        Chromosome[] loci = alignment.chromosomes();
        this.myLociMap.clear();
        for (int i = 0; i < loci.length; ++i) {
            this.myLociMap.put(loci[i].getName(), loci[i]);
            this.myAlignmentLociMap.put(loci[i].getName(), loci[i]);
        }
        int numSites = alignment.numberOfSites();
        String[] snpIDs = new String[numSites];
        for (int i = 0; i < numSites; ++i) {
            snpIDs[i] = alignment.siteName(i);
        }
        BufferedReader br = null;
        int count = 1;
        PositionListBuilder posBuilder = new PositionListBuilder().addAll(alignment.positions());
        try {
            br = Utils.getBufferedReader(this.myMapFilename);
            Pattern sep = Pattern.compile("\\s+");
            String inputline = br.readLine();
            inputline = br.readLine();
            int numChanges = 0;
            while (inputline != null) {
                int site;
                ++count;
                inputline = inputline.trim();
                String[] parsedline = sep.split(inputline);
                inputline = br.readLine();
                String locus1 = this.getLocusName(parsedline[1]);
                if (this.myAlignmentLociMap.get(locus1) == null) continue;
                String snpID = new String(parsedline[0]);
                int pos1 = Integer.valueOf(parsedline[2]);
                String locus2 = this.getLocusName(parsedline[3]);
                int pos2 = Integer.valueOf(parsedline[4]);
                if (locus1.equals(locus2) && pos1 == pos2 || (site = this.getSiteOfSNPID(snpID, snpIDs)) < 0) continue;
                if (pos1 != alignment.chromosomalPosition(site) || !locus1.equals(alignment.chromosome(site).getName())) {
                    myLogger.warn((Object)("map file line: " + count + "  SNP ID: " + snpID + "  position: " + pos1 + "  locus: " + locus1 + " position and locus do not match alignment."));
                    myLogger.warn((Object)("Alignment SNP ID: " + alignment.siteName(site) + "  position: " + alignment.chromosomalPosition(site) + "  locus: " + alignment.chromosomeName(site)));
                    continue;
                }
                ++numChanges;
                GeneralPosition.Builder newPos = new GeneralPosition.Builder((Position)alignment.positions().get(site));
                newPos.chromosome(this.getLocusObj(locus2)).position(pos2).snpName(snpID);
                posBuilder.set(site, newPos.build());
            }
            myLogger.info((Object)("Number Changes: " + numChanges));
            Datum datum = new Datum(input.getName() + "_NewCoordinates", GenotypeTableBuilder.getInstance(alignment.genotypeMatrix(), posBuilder.build(), alignment.taxa()), null);
            return datum;
        }
        catch (Exception e) {
            myLogger.error((Object)("processDatum: problem converting alignment: line: " + count + "  message: " + e.getMessage()));
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {}
        }
        return null;
    }

    private Chromosome getLocusObj(String locus) {
        Chromosome locusObj = this.myLociMap.get(locus);
        if (locusObj == null) {
            locusObj = new Chromosome(locus);
            this.myLociMap.put(locus, locusObj);
        }
        return locusObj;
    }

    private String getLocusName(String input) {
        if (input.startsWith("chr")) {
            return input.substring(3);
        }
        return new String(input);
    }

    private int getSiteOfSNPID(String id, String[] snpIDs) {
        int n = snpIDs.length;
        for (int i = 0; i < n; ++i) {
            if (!id.equals(snpIDs[i])) continue;
            return i;
        }
        return -1;
    }

    public void setMapFilename(String filename) {
        this.myMapFilename = filename;
    }

    public String getMapFilename() {
        return this.myMapFilename;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

