/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.association.RegRidgeEmmaDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.MarkerPhenotype;
import net.maizegenetics.trait.MarkerPhenotypeAdapter;
import net.maizegenetics.trait.MarkerPhenotypeAdapterUtils;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class RidgeRegressionEmmaPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RidgeRegressionEmmaPlugin.class);

    public RidgeRegressionEmmaPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> datasets = input.getDataOfType(Phenotype.class);
            if (datasets.size() < 1) {
                String msg = "No datasets of an appropriate type were selected for the GS analysis.";
                myLogger.error((Object)msg);
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg, "GS Error", 0);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            LinkedList<Datum> results = new LinkedList<Datum>();
            for (Datum dataset : datasets) {
                try {
                    LinkedList<Datum> aResult = null;
                    aResult = this.processData(dataset);
                    if (aResult == null) continue;
                    results.addAll(aResult);
                    this.fireDataSetReturned(new DataSet(aResult, (Plugin)this));
                }
                catch (Exception e) {
                    StringBuilder msg = new StringBuilder("Error in GS processing " + dataset.getName());
                    msg.append(". ").append(e.getMessage());
                    myLogger.error((Object)msg.toString());
                    e.printStackTrace();
                    if (!this.isInteractive()) continue;
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg.toString(), "GS Error", 0);
                }
            }
            DataSet dataSet = new DataSet(results, (Plugin)this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public LinkedList<Datum> processData(Datum dataset) {
        LinkedList<Datum> theResults = new LinkedList<Datum>();
        if (dataset.getDataType().equals(MarkerPhenotype.class)) {
            String msg = "Ridge Regression has only been implemented for numeric genotypes. No analysis will be run on this data.";
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), msg, "Ridge Regression Error", 0);
            } else {
                myLogger.error((Object)msg);
            }
            return null;
        }
        MarkerPhenotypeAdapter theAdapter = new MarkerPhenotypeAdapter((Phenotype)dataset.getData());
        int numberOfMarkers = theAdapter.getNumberOfMarkers();
        int numberOfPhenotypes = theAdapter.getNumberOfPhenotypes();
        for (int ph = 0; ph < numberOfPhenotypes; ++ph) {
            DoubleMatrix fixedEffects;
            ArrayList<double[]> covariateList;
            int numberOfCovariates;
            double[] phenotypeData = theAdapter.getPhenotypeValues(ph);
            int nObs = phenotypeData.length;
            DoubleMatrix phenotype = DoubleMatrixFactory.DEFAULT.make(nObs, 1, phenotypeData);
            Taxon[] taxaIDs = theAdapter.getTaxa(ph);
            boolean[] missing = theAdapter.getMissingPhenotypes(ph);
            ArrayList<String[]> factorList = MarkerPhenotypeAdapterUtils.getFactorList(theAdapter, ph, missing);
            int numberOfFactors = factorList == null ? 0 : factorList.size();
            int numberOfEffects = numberOfFactors + (numberOfCovariates = (covariateList = MarkerPhenotypeAdapterUtils.getCovariateList(theAdapter, ph, missing)) == null ? 0 : covariateList.size()) + 1;
            if (numberOfEffects > 1) {
                int i;
                DoubleMatrix[][] effects = new DoubleMatrix[1][numberOfEffects];
                effects[0][0] = DoubleMatrixFactory.DEFAULT.make(nObs, 1, 1.0);
                for (i = 0; i < numberOfFactors; ++i) {
                    FactorModelEffect fme = new FactorModelEffect(ModelEffectUtils.getIntegerLevels(factorList.get(i)), true);
                    effects[0][i + 1] = fme.getX();
                }
                for (i = 0; i < numberOfCovariates; ++i) {
                    effects[0][i + numberOfFactors + 1] = DoubleMatrixFactory.DEFAULT.make(nObs, 1, covariateList.get(i));
                }
                fixedEffects = DoubleMatrixFactory.DEFAULT.compose(effects);
            } else {
                fixedEffects = DoubleMatrixFactory.DEFAULT.make(nObs, 1, 1.0);
            }
            DoubleMatrix genotype = DoubleMatrixFactory.DEFAULT.make(nObs, numberOfMarkers);
            String[] markerNames = new String[numberOfMarkers];
            for (int m = 0; m < numberOfMarkers; ++m) {
                Object[] markerValue = theAdapter.getMarkerValue(ph, m);
                for (int i = 0; i < nObs; ++i) {
                    genotype.set(i, m, (Double)markerValue[i]);
                }
                markerNames[m] = theAdapter.getMarkerName(m);
            }
            RegRidgeEmmaDoubleMatrix ridgeRegression = new RegRidgeEmmaDoubleMatrix(phenotype, fixedEffects, genotype);
            ridgeRegression.solve();
            double[] gebv = ridgeRegression.getBlups();
            double[][] traitTable = new double[nObs][1];
            for (int i = 0; i < nObs; ++i) {
                traitTable[i][0] = gebv[i];
            }
            LinkedList<Trait> traitList = new LinkedList<Trait>();
            String phenoName = theAdapter.getPhenotypeName(ph);
            traitList.add(new Trait(phenoName + "_GEBV", false, "data"));
            SimplePhenotype outGebv = new SimplePhenotype(new TaxaListBuilder().addAll(taxaIDs).build(), traitList, traitTable);
            String datumName = dataset.getName() + "_GEBVs_" + phenoName;
            StringBuilder comment = new StringBuilder("Ridge Regression from ");
            comment.append(dataset.getName()).append(":\n");
            comment.append("Genomic Estimated Breeding Values (GEBVs)\n");
            comment.append("trait = ").append(phenoName).append("\n");
            comment.append(nObs).append(" lines");
            theResults.add(new Datum(datumName, outGebv, comment.toString()));
            double[] markerBlups = ridgeRegression.getMrkBlups();
            Object[][] blupTable = new Object[numberOfMarkers][2];
            for (int i = 0; i < numberOfMarkers; ++i) {
                blupTable[i][0] = markerNames[i];
                blupTable[i][1] = new Double(markerBlups[i]);
            }
            SimpleTableReport str = new SimpleTableReport("Marker BLUPs for " + dataset.getName(), new String[]{"Marker", phenoName + "_BLUP"}, blupTable);
            datumName = dataset.getName() + "_marker BLUPs_" + phenoName;
            comment = new StringBuilder("Ridge Regression from ");
            comment.append(dataset.getName()).append(":\n");
            comment.append("Marker BLUPs\n");
            comment.append("trait = ").append(phenoName).append("\n");
            comment.append(numberOfMarkers).append(" markers");
            theResults.add(new Datum(datumName, str, comment.toString()));
        }
        return theResults;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = RidgeRegressionEmmaPlugin.class.getResource("/net/maizegenetics/analysis/images/LinearAssociation.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Genomic Selection";
    }

    @Override
    public String getToolTipText() {
        return "Predict Phenotypes using Ridge Regression for Genomic Selection";
    }
}

