/*
 * Decompiled with CFR 0.152.
 */
package format.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Fasta {
    public FastaRecord[] records;

    public Fasta(String[] names, String[] seqs, int[] ids) {
        this.records = new FastaRecord[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.records[i] = new FastaRecord(names[i], seqs[i], ids[i]);
        }
    }

    public Fasta(String infileS) {
        this.readFasta(infileS);
    }

    public long getTotalSeqLength() {
        long sum = 0L;
        for (int i = 0; i < this.getSeqNumber(); ++i) {
            sum += (long)this.getSeqLength(i);
        }
        return sum;
    }

    public int getSeqNumber() {
        return this.records.length;
    }

    public int getIndex(String name) {
        return Arrays.binarySearch(this.records, new FastaRecord(name, null, -1));
    }

    public int getSeqLength(int index) {
        return this.records[index].seq.length();
    }

    public String getName(int index) {
        return this.records[index].name;
    }

    public String getSeq(int index) {
        return this.records[index].seq;
    }

    public void readFasta(String infileS) {
        ArrayList<FastaRecord> al = new ArrayList<FastaRecord>();
        try {
            FastaRecord fr;
            String temp;
            BufferedReader br = new BufferedReader(new FileReader(infileS), 65536);
            String name = new String();
            String seq = new String();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            int cnt = 1;
            while ((temp = br.readLine()) != null) {
                if (temp.startsWith(">")) {
                    if (!first) {
                        seq = sb.toString();
                        fr = new FastaRecord(name, seq, cnt);
                        ++cnt;
                        al.add(fr);
                        sb = new StringBuilder();
                    }
                    name = temp.substring(1, temp.length());
                    first = false;
                    continue;
                }
                sb.append(temp.substring(0, temp.length()));
            }
            if (!name.equals("")) {
                seq = sb.toString();
                fr = new FastaRecord(name, seq, cnt);
                al.add(fr);
            }
            this.records = al.toArray(new FastaRecord[al.size()]);
            this.sortRecordByName();
            System.out.println(this.records.length + " sequences in the file " + infileS);
        }
        catch (Exception e) {
            System.out.println("Error while reading " + infileS);
        }
    }

    public void writeFasta(String outfileS, boolean[] out) {
        int cnt = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (int i = 0; i < this.records.length; ++i) {
                if (!out[i]) continue;
                bw.write(">" + this.records[i].name);
                bw.newLine();
                bw.write(this.records[i].seq);
                bw.newLine();
                ++cnt;
            }
            bw.flush();
            bw.close();
            System.out.println(cnt + " sequences are written in " + outfileS);
        }
        catch (Exception e) {
            System.out.println("Error while writing " + outfileS);
        }
    }

    public void writeFasta(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            for (int i = 0; i < this.records.length; ++i) {
                bw.write(">" + this.records[i].name);
                bw.newLine();
                bw.write(this.records[i].seq);
                bw.newLine();
            }
            bw.flush();
            bw.close();
            System.out.println(this.records.length + " sequences are written in " + outfileS);
        }
        catch (Exception e) {
            System.out.println("Error while writing " + outfileS);
        }
    }

    public void writeLength(String outfileS) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outfileS), 65536);
            bw.write("Name\tLength");
            bw.newLine();
            for (int i = 0; i < this.getSeqNumber(); ++i) {
                bw.write(this.getName(i) + "\t" + String.valueOf(this.getSeqLength(i)));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sortRecordByName() {
        Arrays.sort(this.records, new sortByName());
    }

    public void sortRecordByID() {
        Arrays.sort(this.records, new sortByID());
    }

    public void sortRecordByLengthAscending() {
        Arrays.sort(this.records, new sortByLengthAscending());
    }

    public void sortRecordByLengthDescending() {
        Arrays.sort(this.records, new sortByLengthDescending());
    }

    private class sortByLengthDescending
    implements Comparator<FastaRecord> {
        private sortByLengthDescending() {
        }

        @Override
        public int compare(FastaRecord o1, FastaRecord o2) {
            return o2.seq.length() - o1.seq.length();
        }
    }

    private class sortByLengthAscending
    implements Comparator<FastaRecord> {
        private sortByLengthAscending() {
        }

        @Override
        public int compare(FastaRecord o1, FastaRecord o2) {
            return o1.seq.length() - o2.seq.length();
        }
    }

    private class sortByName
    implements Comparator<FastaRecord> {
        private sortByName() {
        }

        @Override
        public int compare(FastaRecord o1, FastaRecord o2) {
            return o1.name.compareTo(o2.name);
        }
    }

    private class sortByID
    implements Comparator<FastaRecord> {
        private sortByID() {
        }

        @Override
        public int compare(FastaRecord o1, FastaRecord o2) {
            return o1.id - o2.id;
        }
    }

    private class FastaRecord
    implements Comparable<FastaRecord> {
        int id;
        String name;
        String seq;

        FastaRecord(String name, String seq, int id) {
            this.name = name;
            this.seq = seq;
            this.id = id;
        }

        @Override
        public int compareTo(FastaRecord o) {
            return this.name.compareTo(o.name);
        }
    }
}

