/*
 * Decompiled with CFR 0.152.
 */
package analysis.panAnchor;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import format.text.Fasta;
import format.text.Sequence;
import format.text.SimpleAlignment;
import format.text.Table;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class Mo17Utils {
    public void mkDisagreementBlastSyntenyGraph(String samFileS, String compareFileS, String chrInfoFileS, String syntenyDirS) {
        int i;
        int i2;
        Table t = new Table(chrInfoFileS);
        int chrNum = t.getRowNumber();
        int[] chrID = new int[t.getRowNumber()];
        int[] chrLength = new int[t.getRowNumber()];
        int[] centPos = new int[t.getRowNumber()];
        for (int i3 = 0; i3 < chrNum; ++i3) {
            chrID[i3] = Integer.parseInt(t.content[i3][0]);
            chrLength[i3] = Integer.parseInt(t.content[i3][1]);
            centPos[i3] = Integer.parseInt(t.content[i3][2]);
        }
        t = new Table(compareFileS);
        int cnt = 0;
        for (int i4 = 0; i4 < t.getRowNumber(); ++i4) {
            if (!t.content[i4][5].equals("0")) continue;
            ++cnt;
        }
        int contigNum = cnt;
        int[] contigID = new int[contigNum];
        int[] contigLength = new int[contigNum];
        int[] contigAnchorNum = new int[contigNum];
        int[][] anchorContigPos = new int[contigNum][];
        int[][] anchorChr = new int[contigNum][];
        int[][] anchorChrPos = new int[contigNum][];
        cnt = 0;
        for (int i5 = 0; i5 < t.getRowNumber(); ++i5) {
            if (t.content[i5][5].equals("1")) continue;
            contigID[cnt] = Integer.valueOf(t.content[i5][0]);
            contigLength[cnt] = Integer.valueOf(t.content[i5][1]);
            ++cnt;
        }
        SimpleAlignment sa = new SimpleAlignment();
        sa.readFromBowtie2(samFileS);
        boolean[] keepList = new boolean[sa.getAlignmentNumber()];
        for (i2 = 0; i2 < keepList.length; ++i2) {
            Pattern p;
            Matcher m;
            String hit = sa.getHit(i2);
            keepList[i2] = hit == null ? false : !(m = (p = Pattern.compile("\\D")).matcher(sa.getHit(i2))).find();
        }
        sa.toSubset(keepList);
        sa.sortByQuery();
        for (i2 = 0; i2 < contigID.length; ++i2) {
            String contigName = "scaffold" + String.valueOf(contigID[i2]) + "_";
            int startIndex = sa.getAlignmentStartIndexByQueryStartWith(contigName);
            int endIndex = sa.getAlignmentEndIndexByQueryStartWith(contigName);
            contigAnchorNum[i2] = endIndex - startIndex;
            anchorContigPos[i2] = new int[contigAnchorNum[i2]];
            anchorChr[i2] = new int[contigAnchorNum[i2]];
            anchorChrPos[i2] = new int[contigAnchorNum[i2]];
            for (int j = 0; j < contigAnchorNum[i2]; ++j) {
                anchorContigPos[i2][j] = Integer.valueOf(sa.getQuery(j + startIndex).split("_")[1]) * 300;
                anchorChr[i2][j] = Integer.valueOf(sa.getHit(j + startIndex));
                anchorChrPos[i2][j] = sa.getStartPos(j + startIndex);
            }
        }
        int width = 1200;
        int height = 400;
        int maxRecLength = 200;
        int xStart = 50;
        int xInterval = 20;
        int recHeight = 6;
        int yStart = 50;
        int yInterval = 150;
        int contigRecLength = maxRecLength * 5 + xInterval * 4;
        double ratio = (double)maxRecLength / (double)chrLength[0];
        for (i = 0; i < chrNum; ++i) {
            chrLength[i] = (int)(ratio * (double)chrLength[i]);
            centPos[i] = (int)(ratio * (double)centPos[i]);
        }
        for (i = 0; i < contigNum; ++i) {
            double ratioContig = (double)contigRecLength / (double)contigLength[i];
            for (int j = 0; j < contigAnchorNum[i]; ++j) {
                anchorContigPos[i][j] = (int)((double)anchorContigPos[i][j] * ratioContig) + xStart;
                int n = (anchorChr[i][j] - 1) % 5;
                anchorChrPos[i][j] = xStart + n * (maxRecLength + xInterval) + (int)((double)anchorChrPos[i][j] * ratio);
            }
            try {
                int j;
                String fileNameS = new File(syntenyDirS, "scaffold" + this.getSixFigureString(contigID[i])).getAbsolutePath() + ".pdf";
                Document pd = new Document(new Rectangle((float)width, (float)height));
                PdfWriter pw = PdfWriter.getInstance((Document)pd, (OutputStream)new FileOutputStream(fileNameS));
                pd.open();
                PdfContentByte canvas = pw.getDirectContent();
                DefaultFontMapper mapper = new DefaultFontMapper();
                PdfGraphics2D g2d = new PdfGraphics2D(canvas, (float)width, (float)height, (FontMapper)mapper);
                int x = xStart;
                int y = yStart;
                g2d.drawString("Scaffold" + String.valueOf(contigID[i]) + "\t\tLength=" + String.valueOf(contigLength[i]), x, y - 25);
                for (int j2 = 0; j2 < 5; ++j2) {
                    g2d.setColor(Color.black);
                    g2d.drawString(String.valueOf(j2 + 1), x, y - 5);
                    g2d.setColor(Color.ORANGE);
                    g2d.fillRect(x, y, chrLength[j2], recHeight);
                    g2d.setColor(Color.black);
                    g2d.fillRect(x + centPos[j2], y, 3, recHeight);
                    x += chrLength[0];
                    x += xInterval;
                }
                x = xStart;
                int y1 = y += recHeight;
                int y2 = y += yInterval;
                g2d.setColor(Color.cyan);
                g2d.fillRect(x, y, contigRecLength, recHeight);
                int y3 = y += recHeight;
                int y4 = y += yInterval;
                for (j = 5; j < chrNum; ++j) {
                    g2d.setColor(Color.black);
                    g2d.drawString(String.valueOf(j + 1), x, y + recHeight + 15);
                    g2d.setColor(Color.ORANGE);
                    g2d.fillRect(x, y, chrLength[j], recHeight);
                    g2d.setColor(Color.black);
                    g2d.fillRect(x + centPos[j], y, 3, recHeight);
                    x += chrLength[0];
                    x += xInterval;
                }
                g2d.setColor(Color.blue);
                for (j = 0; j < contigAnchorNum[i]; ++j) {
                    if (anchorChr[i][j] <= 5) {
                        g2d.drawLine(anchorChrPos[i][j], y1, anchorContigPos[i][j], y2);
                        continue;
                    }
                    g2d.drawLine(anchorContigPos[i][j], y3, anchorChrPos[i][j], y4);
                }
                g2d.dispose();
                pd.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void mkCompareAnchorAndAlignmentGoodScaffold(String anchorOnContigFileS, String samFileS, String compareFileS) {
        int index;
        int i;
        int contigNum = 0;
        int[] contigID = null;
        int[] contigLength = null;
        int[] contigAnchorNum = null;
        Object anchorContigPos = null;
        Object anchorChr = null;
        Object anchorChrPos = null;
        try {
            int i2;
            BufferedReader br = new BufferedReader(new FileReader(anchorOnContigFileS), 65536);
            contigNum = Integer.parseInt(br.readLine().split("\t")[1]);
            contigID = new int[contigNum];
            contigLength = new int[contigNum];
            contigAnchorNum = new int[contigNum];
            anchorContigPos = new int[contigNum][];
            anchorChr = new int[contigNum][];
            anchorChrPos = new int[contigNum][];
            for (i2 = 0; i2 < 2; ++i2) {
                br.readLine();
            }
            for (i2 = 0; i2 < contigNum; ++i2) {
                String[] temp = br.readLine().substring(1).split("\t");
                contigID[i2] = Integer.parseInt(temp[0]);
                contigLength[i2] = Integer.parseInt(temp[1]);
                contigAnchorNum[i2] = Integer.parseInt(temp[2]);
                anchorContigPos[i2] = new int[contigAnchorNum[i2]];
                anchorChr[i2] = new int[contigAnchorNum[i2]];
                anchorChrPos[i2] = new int[contigAnchorNum[i2]];
                for (int j = 0; j < contigAnchorNum[i2]; ++j) {
                    temp = br.readLine().split("\t");
                    anchorContigPos[i2][j] = Integer.parseInt(temp[1]);
                    anchorChr[i2][j] = Integer.parseInt(temp[2]);
                    anchorChrPos[i2][j] = Integer.parseInt(temp[3]);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        SimpleAlignment sa = new SimpleAlignment();
        sa.readFromBowtie2(samFileS);
        String[] querys = sa.getQuerys();
        TreeSet<Integer> idSet = new TreeSet<Integer>();
        for (int i3 = 0; i3 < querys.length; ++i3) {
            idSet.add(Integer.valueOf(querys[i3].split("_")[0].replaceAll("\\D", "")));
        }
        Object[] ids = idSet.toArray(new Integer[idSet.size()]);
        Arrays.sort(ids);
        ArrayList[] chrList = new ArrayList[ids.length];
        for (i = 0; i < chrList.length; ++i) {
            chrList[i] = new ArrayList();
        }
        for (i = 0; i < sa.getAlignmentNumber(); ++i) {
            Pattern p;
            Matcher m;
            int id = Integer.valueOf(querys[i].split("_")[0].replaceAll("\\D", ""));
            index = Arrays.binarySearch(ids, (Object)id);
            if (sa.getHit(i) == null || (m = (p = Pattern.compile("\\D")).matcher(sa.getHit(i))).find()) continue;
            chrList[index].add(Integer.valueOf(sa.getHit(i)));
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(compareFileS), 65536);
            bw.write("ScaffoldID\tLength\tAnchorNum\tAnchorChr\tAlignChr\tAgreement");
            bw.newLine();
            for (int i4 = 0; i4 < contigNum; ++i4) {
                index = Arrays.binarySearch(ids, (Object)contigID[i4]);
                if (index < 0) continue;
                int anchorMajority = this.getMajority(anchorChr[i4]);
                int[] a = new int[chrList[index].size()];
                for (int j = 0; j < a.length; ++j) {
                    a[j] = (Integer)chrList[index].get(j);
                }
                int alignMajority = this.getMajority(a);
                int agreement = anchorMajority == alignMajority ? 1 : 0;
                bw.write(String.valueOf(contigID[i4]) + "\t" + String.valueOf(contigLength[i4]) + "\t" + String.valueOf(contigAnchorNum[i4]) + "\t" + String.valueOf(anchorMajority) + "\t" + String.valueOf(alignMajority) + "\t" + String.valueOf(agreement));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getMajority(int[] a) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < a.length; ++i) {
            set.add(a[i]);
        }
        Object[] ar = set.toArray(new Integer[set.size()]);
        Arrays.sort(ar);
        int[] count = new int[ar.length];
        for (int i = 0; i < a.length; ++i) {
            int index;
            int n = index = Arrays.binarySearch(ar, (Object)a[i]);
            count[n] = count[n] + 1;
        }
        int max = -1;
        int value = -1;
        for (int i = 0; i < ar.length; ++i) {
            if (count[i] <= max) continue;
            max = count[i];
            value = (Integer)ar[i];
        }
        return value;
    }

    public void mkGoodScaffoldFragments(String assemblyQualityFileS, String mo17Ref, String fragmentFileS) {
        Fasta f = new Fasta(mo17Ref);
        Table t = new Table(assemblyQualityFileS);
        ArrayList<String> scaffoldList = new ArrayList<String>();
        for (int i = 0; i < t.getRowNumber(); ++i) {
            if (Integer.valueOf(t.content[i][2]) < 20 || Double.valueOf(t.content[i][3]) < 0.95) continue;
            scaffoldList.add("scaffold" + t.content[i][0]);
        }
        String[] scaffoldNames = scaffoldList.toArray(new String[scaffoldList.size()]);
        ArrayList<String> fragNameList = new ArrayList<String>();
        ArrayList<String> fragSeqList = new ArrayList<String>();
        for (int i = 0; i < scaffoldNames.length; ++i) {
            int index = f.getIndex(scaffoldNames[i]);
            Sequence s = new Sequence(f.getSeq(index));
            String[] frag = s.getFragments(300);
            for (int j = 0; j < frag.length; ++j) {
                fragNameList.add(scaffoldNames[i] + "_" + String.valueOf(j));
                fragSeqList.add(frag[j]);
            }
        }
        String[] fragName = fragNameList.toArray(new String[fragNameList.size()]);
        String[] fragSeq = fragSeqList.toArray(new String[fragSeqList.size()]);
        int[] ids = new int[fragName.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i + 1;
        }
        Fasta nf = new Fasta(fragName, fragSeq, ids);
        nf.writeFasta(fragmentFileS);
    }

    public void mkGoodContigError(String assemblyQualityFileS, String goodContigList, String goodContigError) {
        Table ta = new Table(assemblyQualityFileS);
        Table tg = new Table(goodContigList);
        Object[] goodName = new String[tg.getRowNumber()];
        for (int i = 0; i < goodName.length; ++i) {
            goodName[i] = tg.content[i][0];
        }
        Arrays.sort(goodName);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(goodContigError), 65536);
            bw.write("Scaffold\tError");
            bw.newLine();
            for (int i = 0; i < ta.getRowNumber(); ++i) {
                int index = Arrays.binarySearch(goodName, ta.content[i][0]);
                if (index < 0) continue;
                bw.write(ta.content[i][0] + "\t" + String.valueOf(1.0 - Double.valueOf(ta.content[i][3])));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkFragmentOnChromosome(String alignFileS, String chrInfoFileS, String fragmentOnChrFileS) {
        Table t = new Table(chrInfoFileS);
        SimpleAlignment sa = new SimpleAlignment(alignFileS);
        boolean[] keepList = new boolean[sa.getAlignmentNumber()];
        for (int i = 0; i < sa.getAlignmentNumber(); ++i) {
            if (!sa.isMatch(i)) continue;
            keepList[i] = true;
        }
        sa.toSubset(keepList);
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fragmentOnChrFileS), 65536);
            bw.write("Contig number:\t" + String.valueOf(1));
            bw.newLine();
            bw.write(">Contig\tContigLength\tAnchorNumber");
            bw.newLine();
            bw.write("AnchorIndex\tContigPos\tRefChr\tRefPos\tIfPAV\tAnchorReadLength");
            bw.newLine();
            for (int i = 0; i < 1; ++i) {
                int alignmentStartIndex = 0;
                int alignmentEndIndex = sa.getAlignmentNumber();
                int alignmentNumber = alignmentEndIndex - alignmentStartIndex;
                bw.write(">" + String.valueOf(162) + "\t" + String.valueOf(363933) + "\t" + String.valueOf(sa.getAlignmentNumber()));
                bw.newLine();
                for (int j = 0; j < alignmentNumber; ++j) {
                    String query = sa.getQuery(j + alignmentStartIndex);
                    bw.write(query + "\t" + String.valueOf(j * 300) + "\t");
                    bw.write(sa.getHit(j) + "\t" + String.valueOf(sa.getStartPos(j)) + "\t");
                    bw.write(String.valueOf("0") + "\t" + String.valueOf(300));
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void mkScaffoldFragments(String mo17Ref, String scaffold, String fragmentFileS) {
        Fasta f = new Fasta(mo17Ref);
        f.sortRecordByName();
        int index = f.getIndex(scaffold);
        Sequence s = new Sequence(f.getSeq(index));
        Fasta sf = s.getFragmentsFasta(300, "");
        sf.writeFasta(fragmentFileS);
    }

    public void mkBarQualityAssembly(String qualityFileS, String barPlotFileS, int intervalLength, int max) {
        double accuracyCut = 0.85;
        int intervalNum = max / intervalLength;
        int[] upperBound = new int[intervalNum];
        int[] lowerBound = new int[intervalNum];
        int[] count = new int[intervalNum];
        ArrayList[] valueList = new ArrayList[intervalNum];
        for (int i = 0; i < intervalNum; ++i) {
            lowerBound[i] = i * intervalLength;
            upperBound[i] = i * intervalLength + intervalLength;
            valueList[i] = new ArrayList();
        }
        Table t = new Table(qualityFileS);
        for (int i = 0; i < t.getRowNumber(); ++i) {
            int index = Arrays.binarySearch(lowerBound, Integer.valueOf(t.content[i][1]));
            if (index < 0) {
                index = -index - 2;
            }
            valueList[index].add(Double.valueOf(t.content[i][3]));
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(barPlotFileS), 65536);
            bw.write("Interval\tContigCount\tMean\tSD\tAccuracyRate");
            bw.newLine();
            for (int i = 0; i < intervalNum; ++i) {
                bw.write(String.valueOf(lowerBound[i]) + "-" + String.valueOf(upperBound[i]) + "\t");
                bw.write(String.valueOf(valueList[i].size()) + "\t");
                double[] value = new double[valueList[i].size()];
                int cnt = 0;
                for (int j = 0; j < valueList[i].size(); ++j) {
                    value[j] = (Double)valueList[i].get(j);
                    if (!(value[j] > accuracyCut)) continue;
                    ++cnt;
                }
                DescriptiveStatistics ds = new DescriptiveStatistics(value);
                bw.write(String.valueOf(ds.getMean()) + "\t" + String.valueOf(ds.getStandardDeviation()) + "\t" + String.valueOf((double)cnt / (double)value.length));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mkStatisticsAssembly(String anchorOnContigFileS, String qualityFileS) {
        int j;
        int i;
        int contigNum = 0;
        int[] contigID = null;
        int[] contigLength = null;
        int[] contigAnchorNum = null;
        Object anchorContigPos = null;
        Object anchorChr = null;
        Object anchorChrPos = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(anchorOnContigFileS), 65536);
            contigNum = Integer.parseInt(br.readLine().split("\t")[1]);
            contigID = new int[contigNum];
            contigLength = new int[contigNum];
            contigAnchorNum = new int[contigNum];
            anchorContigPos = new int[contigNum][];
            anchorChr = new int[contigNum][];
            anchorChrPos = new int[contigNum][];
            for (i = 0; i < 2; ++i) {
                br.readLine();
            }
            for (i = 0; i < contigNum; ++i) {
                String[] temp = br.readLine().substring(1).split("\t");
                contigID[i] = Integer.parseInt(temp[0]);
                contigLength[i] = Integer.parseInt(temp[1]);
                contigAnchorNum[i] = Integer.parseInt(temp[2]);
                anchorContigPos[i] = new int[contigAnchorNum[i]];
                anchorChr[i] = new int[contigAnchorNum[i]];
                anchorChrPos[i] = new int[contigAnchorNum[i]];
                for (j = 0; j < contigAnchorNum[i]; ++j) {
                    temp = br.readLine().split("\t");
                    anchorContigPos[i][j] = Integer.parseInt(temp[1]);
                    anchorChr[i][j] = Integer.parseInt(temp[2]);
                    anchorChrPos[i][j] = Integer.parseInt(temp[3]);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        double[] mainChrRatioOnContig = new double[contigNum];
        for (i = 0; i < contigNum; ++i) {
            int[] c = new int[10];
            for (j = 0; j < 10; ++j) {
                c[j] = 0;
            }
            for (j = 0; j < contigAnchorNum[i]; ++j) {
                int n = anchorChr[i][j] - 1;
                c[n] = c[n] + 1;
            }
            int mainChrID = 0;
            int mainCnt = 0;
            for (int j2 = 0; j2 < 10; ++j2) {
                if (c[j2] <= mainCnt) continue;
                mainCnt = c[j2];
                mainChrID = j2 + 1;
            }
            int cnt = 0;
            for (int j3 = 0; j3 < contigAnchorNum[i]; ++j3) {
                if (anchorChr[i][j3] != mainChrID) continue;
                ++cnt;
            }
            mainChrRatioOnContig[i] = (double)cnt / (double)contigAnchorNum[i];
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(qualityFileS), 65536);
            bw.write("Scaffold\tLength\tAnchorNumber\tRatioAnchorOnMainChr");
            bw.newLine();
            for (int i2 = 0; i2 < contigNum; ++i2) {
                bw.write(String.valueOf(contigID[i2]) + "\t" + String.valueOf(contigLength[i2]) + "\t" + String.valueOf(contigAnchorNum[i2]) + "\t");
                bw.write(String.valueOf(mainChrRatioOnContig[i2]));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void mkSyntenyGraph(String anchorOnContigFileS, String chrInfoFileS, String syntenyDirS, int actualContigNum) {
        int i;
        Table t = new Table(chrInfoFileS);
        int chrNum = t.getRowNumber();
        int[] chrID = new int[t.getRowNumber()];
        int[] chrLength = new int[t.getRowNumber()];
        int[] centPos = new int[t.getRowNumber()];
        for (int i2 = 0; i2 < chrNum; ++i2) {
            chrID[i2] = Integer.parseInt(t.content[i2][0]);
            chrLength[i2] = Integer.parseInt(t.content[i2][1]);
            centPos[i2] = Integer.parseInt(t.content[i2][2]);
        }
        int contigNum = 0;
        int[] contigID = null;
        int[] contigLength = null;
        int[] contigAnchorNum = null;
        Object anchorContigPos = null;
        Object anchorChr = null;
        Object anchorChrPos = null;
        try {
            int i3;
            BufferedReader br = new BufferedReader(new FileReader(anchorOnContigFileS), 65536);
            contigNum = Integer.parseInt(br.readLine().split("\t")[1]);
            contigID = new int[contigNum];
            contigLength = new int[contigNum];
            contigAnchorNum = new int[contigNum];
            anchorContigPos = new int[contigNum][];
            anchorChr = new int[contigNum][];
            anchorChrPos = new int[contigNum][];
            for (i3 = 0; i3 < 2; ++i3) {
                br.readLine();
            }
            for (i3 = 0; i3 < contigNum; ++i3) {
                String[] temp = br.readLine().substring(1).split("\t");
                contigID[i3] = Integer.parseInt(temp[0]);
                contigLength[i3] = Integer.parseInt(temp[1]);
                contigAnchorNum[i3] = Integer.parseInt(temp[2]);
                anchorContigPos[i3] = new int[contigAnchorNum[i3]];
                anchorChr[i3] = new int[contigAnchorNum[i3]];
                anchorChrPos[i3] = new int[contigAnchorNum[i3]];
                for (int j = 0; j < contigAnchorNum[i3]; ++j) {
                    temp = br.readLine().split("\t");
                    anchorContigPos[i3][j] = Integer.parseInt(temp[1]);
                    anchorChr[i3][j] = Integer.parseInt(temp[2]);
                    anchorChrPos[i3][j] = Integer.parseInt(temp[3]);
                }
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        int width = 1200;
        int height = 400;
        int maxRecLength = 200;
        int xStart = 50;
        int xInterval = 20;
        int recHeight = 6;
        int yStart = 50;
        int yInterval = 150;
        int contigRecLength = maxRecLength * 5 + xInterval * 4;
        double ratio = (double)maxRecLength / (double)chrLength[0];
        for (i = 0; i < chrNum; ++i) {
            chrLength[i] = (int)(ratio * (double)chrLength[i]);
            centPos[i] = (int)(ratio * (double)centPos[i]);
        }
        for (i = 0; i < actualContigNum; ++i) {
            double ratioContig = (double)contigRecLength / (double)contigLength[i];
            for (int j = 0; j < contigAnchorNum[i]; ++j) {
                anchorContigPos[i][j] = (int)((double)anchorContigPos[i][j] * ratioContig) + xStart;
                int n = (anchorChr[i][j] - 1) % 5;
                anchorChrPos[i][j] = xStart + n * (maxRecLength + xInterval) + (int)((double)anchorChrPos[i][j] * ratio);
            }
            try {
                int j;
                String fileNameS = new File(syntenyDirS, "contig" + this.getSixFigureString(contigID[i])).getAbsolutePath() + ".pdf";
                Document pd = new Document(new Rectangle((float)width, (float)height));
                PdfWriter pw = PdfWriter.getInstance((Document)pd, (OutputStream)new FileOutputStream(fileNameS));
                pd.open();
                PdfContentByte canvas = pw.getDirectContent();
                DefaultFontMapper mapper = new DefaultFontMapper();
                PdfGraphics2D g2d = new PdfGraphics2D(canvas, (float)width, (float)height, (FontMapper)mapper);
                int x = xStart;
                int y = yStart;
                g2d.drawString("Scaffold" + String.valueOf(contigID[i]) + "\t\tLength=" + String.valueOf(contigLength[i]), x, y - 25);
                for (int j2 = 0; j2 < 5; ++j2) {
                    g2d.setColor(Color.black);
                    g2d.drawString(String.valueOf(j2 + 1), x, y - 5);
                    g2d.setColor(Color.ORANGE);
                    g2d.fillRect(x, y, chrLength[j2], recHeight);
                    g2d.setColor(Color.black);
                    g2d.fillRect(x + centPos[j2], y, 3, recHeight);
                    x += chrLength[0];
                    x += xInterval;
                }
                x = xStart;
                int y1 = y += recHeight;
                int y2 = y += yInterval;
                g2d.setColor(Color.cyan);
                g2d.fillRect(x, y, contigRecLength, recHeight);
                int y3 = y += recHeight;
                int y4 = y += yInterval;
                for (j = 5; j < chrNum; ++j) {
                    g2d.setColor(Color.black);
                    g2d.drawString(String.valueOf(j + 1), x, y + recHeight + 15);
                    g2d.setColor(Color.ORANGE);
                    g2d.fillRect(x, y, chrLength[j], recHeight);
                    g2d.setColor(Color.black);
                    g2d.fillRect(x + centPos[j], y, 3, recHeight);
                    x += chrLength[0];
                    x += xInterval;
                }
                g2d.setColor(Color.blue);
                for (j = 0; j < contigAnchorNum[i]; ++j) {
                    if (anchorChr[i][j] <= 5) {
                        g2d.drawLine(anchorChrPos[i][j], y1, anchorContigPos[i][j], y2);
                        continue;
                    }
                    g2d.drawLine(anchorContigPos[i][j], y3, anchorChrPos[i][j], y4);
                }
                g2d.dispose();
                pd.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getSixFigureString(int number) {
        String s = String.valueOf(number);
        int length = s.length();
        for (int i = 0; i < 6 - length; ++i) {
            s = "0" + s;
        }
        return s;
    }

    public void mkAnchorOnContigFile(String alignFileS, String contigLengthFileS, String anchorFileS, String anchorOnContigFileS, String satisticsFileS) {
        int i;
        Table t = new Table(contigLengthFileS);
        HashMap<String, Integer> contigLengthMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < t.getRowNumber(); ++i2) {
            contigLengthMap.put(t.content[i2][0].replaceAll("\\D", ""), Integer.valueOf(t.content[i2][1]));
        }
        int[] gChr = null;
        int[] gPos = null;
        byte[] anchorLength = null;
        byte[] ifPav = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(anchorFileS), 65536);
            br.readLine();
            int cnt = Integer.valueOf(br.readLine());
            gChr = new int[cnt];
            gPos = new int[cnt];
            anchorLength = new byte[cnt];
            ifPav = new byte[cnt];
            br.readLine();
            for (int i3 = 0; i3 < cnt; ++i3) {
                String[] tem = br.readLine().split("\t");
                gChr[i3] = Integer.valueOf(tem[2]);
                gPos[i3] = Integer.valueOf(tem[3]);
                anchorLength[i3] = Byte.valueOf(tem[1]);
                ifPav[i3] = Byte.valueOf(tem[4]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SimpleAlignment sa = new SimpleAlignment(alignFileS);
        boolean[] keepList = new boolean[sa.getAlignmentNumber()];
        for (int i4 = 0; i4 < sa.getAlignmentNumber(); ++i4) {
            String query = sa.getQuery(i4);
            if (!sa.isUniquePerfectMatch(query) || !sa.isPerfectMatch(i4)) continue;
            keepList[i4] = true;
        }
        sa.toSubset(keepList);
        sa.sortByHitPos();
        String[] chromosomes = sa.getHits();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(anchorOnContigFileS), 65536);
            bw.write("Contig number:\t" + String.valueOf(chromosomes.length));
            bw.newLine();
            bw.write(">Contig\tContigLength\tAnchorNumber");
            bw.newLine();
            bw.write("AnchorIndex\tContigPos\tRefChr\tRefPos\tIfPAV\tAnchorReadLength");
            bw.newLine();
            for (int i5 = 0; i5 < chromosomes.length; ++i5) {
                int alignmentStartIndex = sa.getAlignmentStartIndexByHit(chromosomes[i5]);
                int alignmentEndIndex = sa.getAlignmentEndIndexByHit(chromosomes[i5]);
                int alignmentNumber = alignmentEndIndex - alignmentStartIndex;
                bw.write(">" + chromosomes[i5] + "\t" + String.valueOf(contigLengthMap.get(chromosomes[i5])) + "\t" + String.valueOf(alignmentNumber));
                bw.newLine();
                for (int j = 0; j < alignmentNumber; ++j) {
                    String query = sa.getQuery(j + alignmentStartIndex);
                    bw.write(query + "\t" + String.valueOf(sa.getStartPos(j + alignmentStartIndex)) + "\t");
                    int index = Integer.valueOf(query);
                    bw.write(String.valueOf(gChr[index]) + "\t" + String.valueOf(gPos[index]) + "\t");
                    bw.write(String.valueOf(ifPav[index]) + "\t" + String.valueOf(anchorLength[i5]));
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        int contigNumOnAnchor = chromosomes.length;
        int contigNumTotal = t.getRowNumber();
        long contigLengthOnAnchor = 0L;
        long contigLengthTotal = 0L;
        for (i = 0; i < chromosomes.length; ++i) {
            contigLengthOnAnchor += (long)((Integer)contigLengthMap.get(chromosomes[i])).intValue();
        }
        for (i = 0; i < t.getRowNumber(); ++i) {
            contigLengthTotal += Long.valueOf(t.content[i][1]).longValue();
        }
        int anchorNumTotal = gChr.length;
        int anchorNumOnContig = sa.getQuerys().length;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(satisticsFileS), 65536);
            bw.write("Total contig number:\t" + String.valueOf(contigNumTotal));
            bw.newLine();
            bw.write("Number of contig with anchor:\t" + String.valueOf(contigNumOnAnchor) + "\t" + String.valueOf((double)contigNumOnAnchor / (double)contigNumTotal) + "%");
            bw.newLine();
            bw.write("Total contig length:\t" + String.valueOf(contigLengthTotal));
            bw.newLine();
            bw.write("Length of contig with anchor:\t" + String.valueOf(contigLengthOnAnchor) + "\t" + String.valueOf((double)contigLengthOnAnchor / (double)contigLengthTotal) + "%");
            bw.newLine();
            bw.write("Total anchor number:\t" + String.valueOf(anchorNumTotal));
            bw.newLine();
            bw.write("Number of anchor on contig:\t" + String.valueOf(anchorNumOnContig) + "\t" + String.valueOf((double)anchorNumOnContig / (double)anchorNumTotal) + "%");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

