/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa.tree;

import java.util.Arrays;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.Tree;

public class TreeClusters {
    Tree theTree;
    int nTaxa;
    double[] sortedHeight;
    int nNodes;

    public TreeClusters(Tree theTree) {
        this.theTree = theTree;
        this.nTaxa = theTree.getIdCount();
        this.nNodes = theTree.getInternalNodeCount();
        this.sortedHeight = new double[this.nNodes];
        for (int n = 0; n < this.nNodes; ++n) {
            this.sortedHeight[n] = theTree.getInternalNode(n).getNodeHeight();
        }
        Arrays.sort(this.sortedHeight);
    }

    public int[] getGroups(int numberOfGroups) {
        int[] groups = new int[this.nTaxa];
        if (numberOfGroups == 1) {
            for (int t = 0; t < this.nTaxa; ++t) {
                groups[t] = 0;
            }
        } else if (numberOfGroups == this.nTaxa) {
            for (int t = 0; t < this.nTaxa; ++t) {
                groups[t] = t;
            }
        } else {
            double maxHeight = this.sortedHeight[this.nNodes - numberOfGroups];
            for (int t = 0; t < this.nTaxa; ++t) {
                groups[t] = -1;
            }
            int group = 0;
            for (int t = 0; t < this.nTaxa; ++t) {
                if (groups[t] != -1) continue;
                Node aNode = this.theTree.getExternalNode(t);
                while (aNode.getParent() != null && aNode.getParent().getNodeHeight() <= maxHeight) {
                    aNode = aNode.getParent();
                }
                this.setNodeToGroup(aNode, group, groups);
                ++group;
            }
        }
        return groups;
    }

    public int[] getGroups(double height) {
        int[] groups = new int[this.nTaxa];
        double maxHeight = this.sortedHeight[this.nNodes - 1];
        if (maxHeight < height) {
            for (int t = 0; t < this.nTaxa; ++t) {
                groups[t] = 0;
            }
        } else {
            for (int t = 0; t < this.nTaxa; ++t) {
                groups[t] = -1;
            }
            int group = 0;
            for (int t = 0; t < this.nTaxa; ++t) {
                if (groups[t] != -1) continue;
                Node aNode = this.theTree.getExternalNode(t);
                while (aNode.getParent() != null && aNode.getParent().getNodeHeight() <= height) {
                    aNode = aNode.getParent();
                }
                this.setNodeToGroup(aNode, group, groups);
                ++group;
            }
        }
        return groups;
    }

    public void setNodeToGroup(Node aNode, int group, int[] groups) {
        if (aNode.isLeaf()) {
            Taxon nodeId = aNode.getIdentifier();
            int index = this.theTree.whichIdNumber(nodeId);
            groups[index] = group;
        }
        int nChildren = aNode.getChildCount();
        for (int c = 0; c < nChildren; ++c) {
            this.setNodeToGroup(aNode.getChild(c), group, groups);
        }
    }

    public Taxon getTaxon(int whichTaxon) {
        return this.theTree.getIdentifier(whichTaxon);
    }

    public Tree getTree() {
        return this.theTree;
    }
}

