/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.taxa;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.taxa.TaxaArrayList;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;

public class TaxaListBuilder {
    private List<Taxon> myTaxaList = new ArrayList<Taxon>();
    private HashMap<Taxon, Integer> tempLookup = new HashMap();

    public TaxaListBuilder add(Taxon taxon) {
        if (this.tempLookup.containsKey(taxon)) {
            throw new IllegalStateException("Taxon [" + taxon.getName() + "] already exists in the list.  Duplicated taxa not allowed.");
        }
        this.myTaxaList.add(taxon);
        this.tempLookup.put(taxon, this.myTaxaList.size());
        return this;
    }

    public TaxaListBuilder addAll(Collection<Taxon> taxa) {
        for (Taxon taxon : taxa) {
            this.add(taxon);
        }
        return this;
    }

    public TaxaListBuilder addAll(GenotypeTable a) {
        for (Taxon taxon : a.taxa()) {
            this.add(taxon);
        }
        return this;
    }

    public TaxaListBuilder addAll(String[] taxa) {
        int n = taxa.length;
        for (int i = 0; i < n; ++i) {
            this.add(new Taxon.Builder(taxa[i]).build());
        }
        return this;
    }

    public TaxaListBuilder addAll(Taxon[] taxa) {
        int n = taxa.length;
        for (int i = 0; i < n; ++i) {
            this.add(new Taxon.Builder(taxa[i]).build());
        }
        return this;
    }

    public TaxaList build() {
        return new TaxaArrayList(this);
    }

    public TaxaList buildFromHDF5Genotypes(IHDF5Reader reader) {
        this.myTaxaList.clear();
        for (String taxonName : HDF5Utils.getAllTaxaNames(reader)) {
            if (!HDF5Utils.doTaxonCallsExist(reader, taxonName)) continue;
            this.myTaxaList.add(HDF5Utils.getTaxon(reader, taxonName));
        }
        return this.build();
    }

    public TaxaList buildFromHDF5(IHDF5Reader reader) {
        this.myTaxaList.clear();
        for (String taxonName : HDF5Utils.getAllTaxaNames(reader)) {
            this.myTaxaList.add(HDF5Utils.getTaxon(reader, taxonName));
        }
        return this.build();
    }

    List<Taxon> getImmutableList() {
        return Collections.unmodifiableList(this.myTaxaList);
    }

    public TaxaListBuilder sortTaxaAlphabetically(GenotypeCallTableBuilder genotypes) {
        int numTaxa = this.myTaxaList.size();
        if (numTaxa != genotypes.getTaxaCount()) {
            throw new IllegalArgumentException("TaxaListBuilder: sortTaxaAlphabetically: taxa list size: " + numTaxa + " doesn't match genotypes num taxa: " + genotypes.getTaxaCount());
        }
        genotypes.reorderTaxa(this.sortAlphabetically());
        return this;
    }

    public TaxaListBuilder sortTaxaAlphabetically() {
        this.sortAlphabetically();
        return this;
    }

    private int[] sortAlphabetically() {
        int numTaxa = this.myTaxaList.size();
        final int[] indicesOfSortByTaxa = new int[numTaxa];
        for (int i = 0; i < indicesOfSortByTaxa.length; ++i) {
            indicesOfSortByTaxa[i] = i;
        }
        Swapper swapTaxa = new Swapper(){

            public void swap(int a, int b) {
                int temp = indicesOfSortByTaxa[a];
                indicesOfSortByTaxa[a] = indicesOfSortByTaxa[b];
                indicesOfSortByTaxa[b] = temp;
            }
        };
        IntComparator compTaxa = new IntComparator(){

            public int compare(int a, int b) {
                return ((Taxon)TaxaListBuilder.this.myTaxaList.get(indicesOfSortByTaxa[a])).compareTo((Taxon)TaxaListBuilder.this.myTaxaList.get(indicesOfSortByTaxa[b]));
            }
        };
        GenericSorting.quickSort((int)0, (int)indicesOfSortByTaxa.length, (IntComparator)compTaxa, (Swapper)swapTaxa);
        ArrayList<Taxon> temp = new ArrayList<Taxon>(numTaxa);
        for (int t = 0; t < numTaxa; ++t) {
            temp.add(this.myTaxaList.get(indicesOfSortByTaxa[t]));
        }
        this.myTaxaList = temp;
        return indicesOfSortByTaxa;
    }
}

