/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.maizegenetics.pipeline.TasselPipeline;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.util.ExceptionUtils;
import org.apache.log4j.PropertyConfigurator;

public class TASSELMainApp {
    private final TASSELMainFrame frame;

    public TASSELMainApp() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.net.maizegenetics", "INFO, stdout");
        props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
        props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.TTCCLayout");
        PropertyConfigurator.configure((Properties)props);
        try {
            UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        }
        catch (Exception e) {
            // empty catch block
        }
        TasselPrefs.setPersistPreferences(true);
        this.frame = new TASSELMainFrame();
        this.frame.validate();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.frame.setVisible(true);
    }

    public TASSELMainFrame getTASSELMainFrame() {
        return this.frame;
    }

    public static void main(String[] args) {
        try {
            TASSELMainApp mainApp = new TASSELMainApp();
            if (args.length > 0) {
                new TasselPipeline(args, mainApp.getTASSELMainFrame());
            }
        }
        catch (Throwable e) {
            String userMessage = "TASSEL has experienced an error.  " + ExceptionUtils.getExceptionCauses(e);
            if (e instanceof OutOfMemoryError) {
                userMessage = "You have used up all of the memory allocated to the Java Virtual Machine.  It is recommneded that you adjust your heap settings and possibly add more memory to the computer.  Additionally, some operations are not recommended on a full dataset, i.e., select SNPs *before* determining LD";
            }
            JOptionPane.showMessageDialog(null, userMessage, "Fatal Error", 0);
            e.printStackTrace();
        }
    }
}

