/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.tassel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.gui.AlignmentTableCellRenderer;
import net.maizegenetics.gui.AlignmentTableModel;
import net.maizegenetics.gui.GenotypeTableMask;
import net.maizegenetics.gui.GenotypeTableMaskGeneticDistance;
import net.maizegenetics.gui.GenotypeTableMaskReference;
import net.maizegenetics.gui.RowHeaderRenderer;
import net.maizegenetics.gui.TableRowHeaderListModel;
import net.maizegenetics.gui.VerticalLabelUI;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.tassel.DataTreePanel;
import net.maizegenetics.taxa.Taxon;

public class SeqViewerPanel
extends JPanel
implements ComponentListener,
TableModelListener {
    private static final Map INSTANCES = new WeakHashMap();
    private static final int ROW_HEADER_WIDTH = 150;
    private static final int SCROLL_BAR_WIDTH = 25;
    private static final int TABLE_COLUMN_WIDTH = 10;
    private static final int TABLE_COLUMN_MARGIN = 5;
    private static final int SLIDER_TEXT_WIDTH = 125;
    private JSlider mySlider;
    private JButton myLeftButton;
    private JButton myRightButton;
    private final JTable myTable;
    private final JPopupMenu myMenu = new JPopupMenu();
    private final AlignmentTableModel myTableModel;
    private final GenotypeTable myAlignment;
    private final JScrollPane myScrollPane;
    private JPanel mySliderPane;
    private JLabel searchLabel;
    private JTextField searchField;
    private JButton searchButton;
    private int start;
    private int end;
    private int startPos;
    private int endPos;
    private int siteCount;
    private final DataTreePanel myDataTreePanel;
    private final AlignmentTableCellRenderer myTableCellRenderer;
    private final JComboBox myHighlightingComboBox;

    private SeqViewerPanel(GenotypeTable alignment, GenotypeTableMask[] masks, DataTreePanel dataTreePanel) {
        this(alignment, masks, dataTreePanel, -1, AlignmentTableCellRenderer.RENDERING_TYPE.MajorMinorAllele);
    }

    private SeqViewerPanel(GenotypeTable alignment, GenotypeTableMask[] masks, DataTreePanel dataTreePanel, int sliderPosition, AlignmentTableCellRenderer.RENDERING_TYPE type) {
        boolean multipleAlignments;
        this.setLayout(new BorderLayout());
        this.myAlignment = alignment;
        this.myDataTreePanel = dataTreePanel;
        this.myTableModel = new AlignmentTableModel(alignment);
        this.myTableCellRenderer = new AlignmentTableCellRenderer(this.myTableModel, this.myAlignment, masks);
        this.myHighlightingComboBox = new JComboBox<AlignmentTableCellRenderer.RENDERING_TYPE>(AlignmentTableCellRenderer.RENDERING_TYPE.values());
        this.myHighlightingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentTableCellRenderer.RENDERING_TYPE type = (AlignmentTableCellRenderer.RENDERING_TYPE)((Object)SeqViewerPanel.this.myHighlightingComboBox.getSelectedItem());
                SeqViewerPanel.this.myTableCellRenderer.setRenderingType(type);
                SeqViewerPanel.this.myTableModel.fireTableChanged();
            }
        });
        this.myHighlightingComboBox.setSelectedItem((Object)type);
        this.siteCount = this.myAlignment.numberOfSites();
        this.start = 0;
        this.end = this.siteCount - 1;
        this.startPos = this.myAlignment.chromosomalPosition(0);
        this.endPos = this.myAlignment.chromosomalPosition(this.end);
        this.mySlider = new JSlider();
        this.mySlider.addChangeListener(this.myTableModel);
        if (sliderPosition == -1) {
            this.myTableModel.adjustPositionToCenter();
        } else {
            this.myTableModel.adjustPositionToSite(sliderPosition);
        }
        this.myTableModel.addTableModelListener(this);
        this.myTable = new JTable(this.myTableModel);
        this.myTable.setUI(new MyTableUI());
        this.myTable.setDefaultRenderer(this.myTable.getColumnClass(0), this.myTableCellRenderer);
        this.myTable.setAutoResizeMode(2);
        JList rowHeaders = new JList(new TableRowHeaderListModel(this.myTableModel.getRowHeaders())){

            @Override
            public String getToolTipText(MouseEvent evt) {
                int index = this.locationToIndex(evt.getPoint());
                Taxon id = (Taxon)this.getModel().getElementAt(index);
                return id.getName();
            }
        };
        rowHeaders.setFixedCellWidth(150);
        rowHeaders.setFixedCellHeight(this.myTable.getRowHeight());
        rowHeaders.setCellRenderer(new RowHeaderRenderer(this.myTable));
        this.myScrollPane = new JScrollPane(this.myTable);
        this.myScrollPane.addComponentListener(this);
        this.myScrollPane.setRowHeaderView(rowHeaders);
        this.add((Component)this.getControls(), "North");
        this.add((Component)this.myScrollPane, "Center");
        boolean bl = multipleAlignments = this.myAlignment.numChromosomes() > 1;
        if (multipleAlignments) {
            this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber);
            this.updateSliderSiteNumbers();
        } else {
            this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition);
            this.updateSliderPhysicalPositions();
        }
        this.initMenu();
    }

    public static SeqViewerPanel getInstance(GenotypeTable alignment, GenotypeTableMask[] masks, DataTreePanel dataTreePanel) {
        Object[] instance = (Object[])INSTANCES.get(alignment);
        SeqViewerPanel result = null;
        if (instance == null) {
            result = new SeqViewerPanel(alignment, masks, dataTreePanel);
            SeqViewerPanel.saveInstance(result, alignment, masks);
        } else {
            result = (SeqViewerPanel)instance[0];
            result.setMasks(masks);
            SeqViewerPanel.saveInstance(result, alignment, masks);
        }
        return result;
    }

    private static void saveInstance(SeqViewerPanel panel, GenotypeTable alignment, GenotypeTableMask[] masks) {
        int arraySize = 1;
        if (masks != null) {
            arraySize += masks.length;
        }
        Object[] instance = new Object[arraySize];
        instance[0] = panel;
        if (masks != null) {
            for (int i = 0; i < masks.length; ++i) {
                instance[i + 1] = masks[i];
            }
        }
        INSTANCES.put(alignment, instance);
    }

    public static void removeInstance(GenotypeTable alignment) {
        try {
            INSTANCES.remove(alignment);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SeqViewerPanel getInstance(GenotypeTable alignment, DataTreePanel dataTreePanel) {
        return SeqViewerPanel.getInstance(alignment, null, dataTreePanel);
    }

    public void setMasks(GenotypeTableMask[] masks) {
        this.myTableCellRenderer.setMasks(masks);
    }

    private void initMenu() {
        this.myMenu.setInvoker(this);
        JMenuItem useAsReference = new JMenuItem("Use this Taxa as Reference");
        useAsReference.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SeqViewerPanel.this.myTable.getSelectedRow();
                GenotypeTableMaskReference mask = GenotypeTableMaskReference.getInstanceCompareReference(SeqViewerPanel.this.myAlignment, index);
                SeqViewerPanel.this.myHighlightingComboBox.setSelectedItem((Object)AlignmentTableCellRenderer.RENDERING_TYPE.ReferenceMasks);
                SeqViewerPanel.this.myDataTreePanel.addDatum(new Datum(mask.toString(), mask, null));
            }
        });
        this.myMenu.add(useAsReference);
        JMenuItem useAsGeneticDistance = new JMenuItem("Use this Taxa for Genetic Distance");
        useAsGeneticDistance.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SeqViewerPanel.this.myTable.getSelectedRow();
                GenotypeTableMaskGeneticDistance mask = GenotypeTableMaskGeneticDistance.getInstanceCompareReference(SeqViewerPanel.this.myAlignment, index);
                SeqViewerPanel.this.myHighlightingComboBox.setSelectedItem((Object)AlignmentTableCellRenderer.RENDERING_TYPE.GeneticDistanceMasks);
                SeqViewerPanel.this.myDataTreePanel.addDatum(new Datum(mask.toString(), mask, null));
            }
        });
        this.myMenu.add(useAsGeneticDistance);
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SeqViewerPanel.this.myMenu.setLocation(e.getXOnScreen(), e.getYOnScreen());
                SeqViewerPanel.this.myMenu.setVisible(true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SeqViewerPanel.this.myMenu.setVisible(false);
            }
        });
    }

    private JPanel getControls() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        RadioListener radioListener = new RadioListener();
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean multipleAlignments = this.myAlignment.numChromosomes() > 1;
        JRadioButton physicalPosition = null;
        if (!multipleAlignments) {
            physicalPosition = new JRadioButton("Physical Positions");
            physicalPosition.setActionCommand(AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition.toString());
            physicalPosition.addActionListener(radioListener);
        }
        JRadioButton siteNumber = new JRadioButton("Site Numbers");
        siteNumber.setActionCommand(AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber.toString());
        siteNumber.addActionListener(radioListener);
        JRadioButton locus = new JRadioButton("Locus");
        locus.setActionCommand(AlignmentTableModel.COLUMN_NAME_TYPE.locus.toString());
        locus.addActionListener(radioListener);
        JRadioButton siteName = new JRadioButton("Site Name");
        siteName.setActionCommand(AlignmentTableModel.COLUMN_NAME_TYPE.siteName.toString());
        siteName.addActionListener(radioListener);
        JRadioButton alleles = new JRadioButton("Alleles");
        alleles.setActionCommand(AlignmentTableModel.COLUMN_NAME_TYPE.alleles.toString());
        alleles.addActionListener(radioListener);
        this.searchLabel = new JLabel();
        this.searchLabel.setPreferredSize(new Dimension(70, 25));
        this.searchField = new JTextField();
        this.searchField.setPreferredSize(new Dimension(225, 25));
        this.searchField.setText("(Enter physical position)");
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeqViewerPanel.this.searchButton_actionPerformed(e);
            }
        });
        JPanel selectColumnHeadings = new JPanel(new FlowLayout(0));
        FlowLayout layout = new FlowLayout(1, 0, 0){

            @Override
            public Dimension preferredLayoutSize(Container target) {
                int maxWidth = target.getSize().width == 0 ? Integer.MAX_VALUE : target.getSize().width;
                int resultWidth = 0;
                int resultHeight = 0;
                int currentWidth = 0;
                int currentHeight = 0;
                Component[] components = target.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    if (!components[i].isVisible()) continue;
                    Dimension currentSize = components[i].getPreferredSize();
                    if (currentWidth + currentSize.width > maxWidth) {
                        resultWidth = Math.max(resultWidth, currentWidth);
                        resultHeight += currentHeight;
                        currentWidth = 0;
                        currentHeight = 0;
                    }
                    currentWidth += currentSize.width;
                    currentHeight = Math.max(currentHeight, currentSize.height);
                }
                resultWidth = Math.max(resultWidth, currentWidth);
                return new Dimension(resultWidth, resultHeight += currentHeight);
            }
        };
        selectColumnHeadings.setLayout(layout);
        if (!multipleAlignments) {
            buttonGroup.add(physicalPosition);
        }
        buttonGroup.add(siteNumber);
        buttonGroup.add(locus);
        buttonGroup.add(siteName);
        buttonGroup.add(alleles);
        if (multipleAlignments) {
            buttonGroup.setSelected(siteNumber.getModel(), true);
        } else {
            buttonGroup.setSelected(physicalPosition.getModel(), true);
        }
        if (!multipleAlignments) {
            selectColumnHeadings.add(physicalPosition);
        }
        selectColumnHeadings.add(siteNumber);
        selectColumnHeadings.add(locus);
        selectColumnHeadings.add(siteName);
        selectColumnHeadings.add(alleles);
        JLabel blankSpace = new JLabel();
        blankSpace.setPreferredSize(new Dimension(25, 25));
        selectColumnHeadings.add(blankSpace);
        selectColumnHeadings.add(this.myHighlightingComboBox);
        JLabel blankSpace2 = new JLabel();
        blankSpace2.setPreferredSize(new Dimension(25, 25));
        selectColumnHeadings.add(blankSpace2);
        selectColumnHeadings.add(this.searchLabel);
        selectColumnHeadings.add(this.searchField);
        selectColumnHeadings.add(this.searchButton);
        result.add(selectColumnHeadings);
        result.add(this.getSliderPane());
        return result;
    }

    public AlignmentTableCellRenderer.RENDERING_TYPE getCellRenderingType() {
        return (AlignmentTableCellRenderer.RENDERING_TYPE)((Object)this.myHighlightingComboBox.getSelectedItem());
    }

    private void searchButton_actionPerformed(ActionEvent e) {
        try {
            int searchValue = (int)Double.parseDouble(this.searchField.getText().trim());
            if (this.myTableModel.getColumnNameType().equals((Object)AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition)) {
                if (searchValue > this.endPos) {
                    JOptionPane.showMessageDialog(this.getParent(), "Physical position must be between " + this.startPos + " and " + this.endPos + ".");
                } else if (searchValue < this.startPos) {
                    JOptionPane.showMessageDialog(this.getParent(), "Physical position must be between " + this.startPos + " and " + this.endPos + ".");
                } else {
                    this.mySlider.setValue(searchValue);
                }
            } else if (this.myTableModel.getColumnNameType().equals((Object)AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber)) {
                if (searchValue > this.end) {
                    JOptionPane.showMessageDialog(this.getParent(), "Site number must be between " + this.start + " and " + this.end + ".");
                } else if (searchValue < this.start) {
                    JOptionPane.showMessageDialog(this.getParent(), "Site number must be between " + this.start + " and " + this.end + ".");
                } else {
                    this.mySlider.setValue(searchValue);
                }
            }
        }
        catch (Exception ex) {
            String positionType = "";
            if (this.myTableModel.getColumnNameType().equals((Object)AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition)) {
                positionType = "physical position";
            } else if (this.myTableModel.getColumnNameType().equals((Object)AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber)) {
                positionType = "site number";
            }
            JOptionPane.showMessageDialog(this.getParent(), "Invalid " + positionType + ": " + this.searchField.getText().trim());
        }
    }

    private void hideSearchFunction() {
        this.searchField.setVisible(false);
        this.searchButton.setVisible(false);
    }

    private void showSearchFunction() {
        this.searchField.setVisible(true);
        this.searchButton.setVisible(true);
    }

    private void changeTextPhysicalPosition() {
        this.searchField.setText("(Enter physical position)");
    }

    private void changeTextSiteNumber() {
        this.searchField.setText("(Enter site number)");
    }

    private JPanel getSliderPane() {
        this.mySliderPane = new JPanel(new BorderLayout());
        URL imageURL = SeqViewerPanel.class.getResource("left.gif");
        ImageIcon imageIcon = null;
        if (imageURL != null) {
            imageIcon = new ImageIcon(imageURL);
        }
        this.myLeftButton = new JButton(imageIcon);
        this.myLeftButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SeqViewerPanel.this.myTableModel.isPhysicalPosition()) {
                    int newSite = SeqViewerPanel.this.myTableModel.getHorizontalCenter() - SeqViewerPanel.this.myTableModel.getHorizontalPageSize() * 3 / 4;
                    newSite = Math.max(0, newSite);
                    SeqViewerPanel.this.mySlider.setValue(SeqViewerPanel.this.myAlignment.chromosomalPosition(newSite));
                } else {
                    int newValue = SeqViewerPanel.this.mySlider.getValue() - SeqViewerPanel.this.myTableModel.getHorizontalPageSize() * 3 / 4;
                    newValue = Math.max(SeqViewerPanel.this.mySlider.getMinimum(), newValue);
                    SeqViewerPanel.this.mySlider.setValue(newValue);
                }
            }
        });
        this.mySliderPane.add((Component)this.myLeftButton, "West");
        this.mySliderPane.add((Component)this.mySlider, "Center");
        imageURL = SeqViewerPanel.class.getResource("right.gif");
        imageIcon = null;
        if (imageURL != null) {
            imageIcon = new ImageIcon(imageURL);
        }
        this.myRightButton = new JButton(imageIcon);
        this.myRightButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SeqViewerPanel.this.myTableModel.isPhysicalPosition()) {
                    int newSite = SeqViewerPanel.this.myTableModel.getHorizontalCenter() + SeqViewerPanel.this.myTableModel.getHorizontalPageSize() * 3 / 4;
                    newSite = Math.min(SeqViewerPanel.this.myAlignment.numberOfSites() - 1, newSite);
                    SeqViewerPanel.this.mySlider.setValue(SeqViewerPanel.this.myAlignment.chromosomalPosition(newSite));
                } else {
                    int newValue = SeqViewerPanel.this.mySlider.getValue() + SeqViewerPanel.this.myTableModel.getHorizontalPageSize() * 3 / 4;
                    newValue = Math.min(SeqViewerPanel.this.mySlider.getMaximum(), newValue);
                    SeqViewerPanel.this.mySlider.setValue(newValue);
                }
            }
        });
        this.mySliderPane.add((Component)this.myRightButton, "East");
        return this.mySliderPane;
    }

    public int getSliderPosition() {
        return this.mySlider.getValue();
    }

    public int getSliderPositionAsSite() {
        return this.myTableModel.getHorizontalCenter();
    }

    public GenotypeTable getAlignment() {
        return this.myAlignment;
    }

    private void updateSliderPhysicalPositions() {
        int min = this.myAlignment.chromosomalPosition(0);
        int max = this.myAlignment.chromosomalPosition(this.myAlignment.numberOfSites() - 1);
        int tableSize = max - min + 1;
        int center = this.myTableModel.getHorizontalCenter();
        this.mySlider.setMinimum(min);
        this.mySlider.setMaximum(max);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setPaintLabels(true);
        int scrollWidth = this.myScrollPane.getWidth();
        int numTicks = 0;
        numTicks = scrollWidth <= 0 ? 10 : scrollWidth / 125;
        int spacing = tableSize / numTicks;
        if (spacing < 1) {
            spacing = 1;
        }
        this.mySlider.setLabelTable(this.mySlider.createStandardLabels(spacing));
        this.mySlider.setMajorTickSpacing(spacing);
        this.mySlider.setValue(this.myAlignment.chromosomalPosition(center));
        this.mySlider.validate();
        this.mySliderPane.validate();
        this.mySliderPane.repaint();
        this.repaint();
    }

    private void updateSliderSiteNumbers() {
        int tableSize = this.myTableModel.getRealColumnCount();
        int center = this.myTableModel.getHorizontalCenter();
        this.mySlider.setMinimum(0);
        this.mySlider.setMaximum(tableSize - 1);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setPaintLabels(true);
        int scrollWidth = this.myScrollPane.getWidth();
        int numTicks = 0;
        numTicks = scrollWidth <= 0 ? 10 : scrollWidth / 125;
        int spacing = tableSize / numTicks;
        if (spacing < 1) {
            spacing = 1;
        }
        this.mySlider.setLabelTable(this.mySlider.createStandardLabels(spacing));
        this.mySlider.setMajorTickSpacing(spacing);
        this.mySlider.setValue(center);
        this.mySlider.validate();
        this.mySliderPane.validate();
        this.mySliderPane.repaint();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension size = e.getComponent().getSize();
        int width = (int)size.getWidth() - 150 - 25;
        int columnWidth = 20;
        try {
            columnWidth = this.myAlignment.genotypeAsString(0, 0).length() * 10 + 10;
        }
        catch (Exception ex) {
            // empty catch block
        }
        int numColumns = width / columnWidth;
        this.myTableModel.setHorizontalPageSize(numColumns);
        if (this.myTableModel.isPhysicalPosition()) {
            this.updateSliderPhysicalPositions();
        } else if (!this.myTableModel.isPhysicalPosition()) {
            this.updateSliderSiteNumbers();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        for (int c = 0; c < this.myTable.getColumnCount(); ++c) {
            TableColumn col = this.myTable.getColumnModel().getColumn(c);
            col.setHeaderRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel label = new JLabel(value.toString());
                    label.setBorder(BorderFactory.createEtchedBorder());
                    label.setUI(VerticalLabelUI.getInstance());
                    return label;
                }
            });
        }
        if (this.myTableModel.isPhysicalPosition()) {
            this.updateSliderPhysicalPositions();
        } else if (!this.myTableModel.isPhysicalPosition()) {
            this.updateSliderSiteNumbers();
        }
    }

    public class MyTableUI
    extends BasicTableUI {
        private boolean justClicked = false;

        @Override
        protected MouseInputListener createMouseInputListener() {
            return new MyMouseInputListener();
        }

        public class MyMouseInputListener
        extends BasicTableUI.MouseInputHandler {
            public MyMouseInputListener() {
                super(MyTableUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                if (!table.isRowSelected(table.rowAtPoint(e.getPoint()))) {
                    int mod = e.getModifiers();
                    if ((mod & 4) == 4) {
                        mod ^= 4;
                        e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), mod |= 0x10, e.getX(), e.getY(), e.getClickCount(), true);
                    }
                    super.mousePressed(e);
                    MyTableUI.this.justClicked = true;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!MyTableUI.this.justClicked) {
                    super.mousePressed(e);
                } else {
                    MyTableUI.this.justClicked = false;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals(AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition.toString())) {
                SeqViewerPanel.this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.physicalPosition);
                SeqViewerPanel.this.updateSliderPhysicalPositions();
                SeqViewerPanel.this.showSearchFunction();
                SeqViewerPanel.this.changeTextPhysicalPosition();
            } else if (e.getActionCommand().equals(AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber.toString())) {
                SeqViewerPanel.this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.siteNumber);
                SeqViewerPanel.this.updateSliderSiteNumbers();
                SeqViewerPanel.this.showSearchFunction();
                SeqViewerPanel.this.changeTextSiteNumber();
            } else if (e.getActionCommand().equals(AlignmentTableModel.COLUMN_NAME_TYPE.locus.toString())) {
                SeqViewerPanel.this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.locus);
                SeqViewerPanel.this.hideSearchFunction();
            } else if (e.getActionCommand().equals(AlignmentTableModel.COLUMN_NAME_TYPE.alleles.toString())) {
                SeqViewerPanel.this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.alleles);
                SeqViewerPanel.this.hideSearchFunction();
            } else if (e.getActionCommand().equals(AlignmentTableModel.COLUMN_NAME_TYPE.siteName.toString())) {
                SeqViewerPanel.this.myTableModel.setColumnNameType(AlignmentTableModel.COLUMN_NAME_TYPE.siteName);
                SeqViewerPanel.this.hideSearchFunction();
            }
        }
    }
}

