/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;

public class SweepFast {
    private double[] A;
    private int dimA;
    private boolean[] singular;
    private double[] V;
    private double[] Dmin;
    public static final double TOL = 1.0E-12;

    public SweepFast(DoubleMatrix X, DoubleMatrix y) {
        this(X.crossproduct(), X.crossproduct(y), y.crossproduct().get(0, 0));
    }

    public SweepFast(DoubleMatrix XTX, DoubleMatrix XTy, double yty) {
        int dimXTX = XTX.numberOfRows();
        this.dimA = dimXTX + 1;
        int n = this.dimA * (this.dimA + 1) / 2;
        this.A = new double[n];
        int count = 0;
        for (int r = 0; r < dimXTX; ++r) {
            for (int c = r; c < dimXTX; ++c) {
                this.A[count++] = XTX.get(r, c);
            }
            ++count;
        }
        count = dimXTX;
        int incr = dimXTX;
        for (int r = 0; r < dimXTX; ++r) {
            this.A[count] = XTy.get(r, 0);
            count += incr--;
        }
        this.A[n - 1] = yty;
        this.singular = new boolean[this.dimA];
        this.V = new double[this.dimA];
        for (int i = 0; i < this.dimA; ++i) {
            this.singular[i] = false;
            this.V[i] = 1.0;
        }
        this.initializeDmin();
    }

    public SweepFast(DoubleMatrix[][] xtxMatrices, DoubleMatrix[] xtyMatrices, double yty) {
        this.init(xtxMatrices, xtyMatrices, yty);
    }

    public SweepFast() {
    }

    private void init(DoubleMatrix[][] xtxMatrices, DoubleMatrix[] xtyMatrices, double yty) {
        int nx = xtyMatrices.length;
        this.dimA = 0;
        int[] dimX = new int[nx];
        for (int i = 0; i < nx; ++i) {
            int num;
            dimX[i] = num = xtxMatrices[0][i].numberOfColumns();
            this.dimA += num;
        }
        ++this.dimA;
        int n = this.dimA * (this.dimA + 1) / 2;
        this.A = new double[n];
        int count = 0;
        for (int imain = 0; imain < nx; ++imain) {
            for (int isub = 0; isub < dimX[imain]; ++isub) {
                for (int j = isub; j < dimX[imain]; ++j) {
                    this.A[count++] = xtxMatrices[imain][imain].get(isub, j);
                }
                for (int k = imain + 1; k < nx; ++k) {
                    for (int j = 0; j < dimX[k]; ++j) {
                        this.A[count++] = xtxMatrices[imain][k].get(isub, j);
                    }
                }
                this.A[count++] = xtyMatrices[imain].get(isub, 0);
            }
        }
        this.A[count] = yty;
        this.singular = new boolean[this.dimA];
        this.V = new double[this.dimA];
        for (int i = 0; i < this.dimA; ++i) {
            this.singular[i] = false;
            this.V[i] = 1.0;
        }
        this.initializeDmin();
    }

    private void initializeDmin() {
        this.Dmin = new double[this.dimA];
        for (int i = 0; i < this.dimA; ++i) {
            this.Dmin[i] = 1.0E-12;
        }
    }

    public boolean revg2sweep(int column) {
        double B;
        int j;
        int i;
        int i2;
        if (this.singular[column]) {
            this.singular[column] = false;
            return false;
        }
        int diagndx = this.diagonal(column);
        double D = this.A[this.diagonal(column)];
        if (Math.abs(D) < this.Dmin[column]) {
            this.singular[column] = true;
            return false;
        }
        double[] originalColumnValues = new double[this.dimA];
        int ndx = column;
        int incr = this.dimA - 1;
        for (i2 = 0; i2 <= column; ++i2) {
            originalColumnValues[i2] = this.A[ndx];
            ndx += incr--;
        }
        ndx = diagndx + 1;
        for (i2 = column + 1; i2 < this.dimA; ++i2) {
            originalColumnValues[i2] = this.A[ndx];
            ++ndx;
        }
        int count = 0;
        double vcol = this.V[column];
        for (i = 0; i < column; ++i) {
            for (j = i; j < this.dimA; ++j) {
                B = originalColumnValues[i] / D;
                if (column < j) {
                    int n = count;
                    this.A[n] = this.A[n] - B * originalColumnValues[j];
                }
                if (column > j) {
                    int n = count;
                    this.A[n] = this.A[n] - B * originalColumnValues[j] * this.V[j] * vcol;
                }
                ++count;
            }
        }
        count += this.dimA - column;
        for (i = column + 1; i < this.dimA; ++i) {
            for (j = i; j < this.dimA; ++j) {
                B = this.V[i] * vcol * originalColumnValues[i] / D;
                if (column < j) {
                    int n = count;
                    this.A[n] = this.A[n] - B * originalColumnValues[j];
                }
                if (column > j) {
                    int n = count;
                    this.A[n] = this.A[n] - B * originalColumnValues[j] * this.V[j] * vcol;
                }
                ++count;
            }
        }
        ndx = column;
        incr = this.dimA - 1;
        for (i = 0; i <= column; ++i) {
            this.A[ndx] = -1.0 * originalColumnValues[i] / D;
            ndx += incr--;
        }
        ndx = diagndx;
        for (int j2 = column; j2 < this.dimA; ++j2) {
            this.A[ndx] = originalColumnValues[j2] / D;
            ++ndx;
        }
        this.A[diagndx] = 1.0 / D;
        this.V[column] = this.V[column] * -1.0;
        return true;
    }

    private int diagonal(int d) {
        if (d == 0) {
            return 0;
        }
        return d * this.dimA - d * (d - 1) / 2;
    }

    private int coord(int row, int col) {
        if (row == 0) {
            return col;
        }
        return row * this.dimA - row * (row - 1) / 2 + col - row;
    }

    public int sweepSingularColumns() {
        int swept = 0;
        for (int i = 0; i < this.singular.length; ++i) {
            if (!this.singular[i]) continue;
            this.singular[i] = false;
            if (!this.revg2sweep(i)) continue;
            ++swept;
        }
        return swept;
    }

    public void setcssDmin(double[] css) {
        if (css == null) {
            int n = this.dimA - 1;
            this.Dmin = new double[n];
            for (int i = 0; i < n; ++i) {
                this.Dmin[i] = 1.0E-12;
            }
        } else {
            int n = css.length;
            this.Dmin = new double[n];
            for (int i = 0; i < n; ++i) {
                this.Dmin[i] = css[i] < 1.0 ? 1.0E-12 : css[i] * 1.0E-12;
            }
        }
    }

    public void setDminFromA() {
        int n = this.dimA;
        this.Dmin = new double[n];
        for (int i = 0; i < n; ++i) {
            this.Dmin[i] = Math.max(this.A[this.diagonal(i)] * 1.0E-12, 1.0E-12);
        }
    }

    public double getResidualSS() {
        return this.A[this.A.length - 1];
    }

    public double[] getBeta() {
        int n = this.dimA - 1;
        double[] beta = new double[n];
        int incr = n;
        int count = n;
        for (int i = 0; i < n; ++i) {
            beta[i] = this.A[count];
            count += incr--;
        }
        return beta;
    }

    public DoubleMatrix getXTXpart() {
        int j;
        int i;
        int n = this.dimA - 1;
        DoubleMatrix Amatrix = DoubleMatrixFactory.DEFAULT.make(n, n);
        int count = 0;
        for (i = 0; i < n; ++i) {
            for (j = i; j < n; ++j) {
                Amatrix.set(i, j, this.A[count++]);
            }
            ++count;
        }
        for (i = 0; i < n; ++i) {
            for (j = i + 1; j < n; ++j) {
                Amatrix.set(j, i, Amatrix.get(i, j) * this.V[i] * this.V[j]);
            }
        }
        return Amatrix;
    }

    public DoubleMatrix getA() {
        int j;
        int i;
        DoubleMatrix Amatrix = DoubleMatrixFactory.DEFAULT.make(this.dimA, this.dimA);
        int count = 0;
        for (i = 0; i < this.dimA; ++i) {
            for (j = i; j < this.dimA; ++j) {
                Amatrix.set(i, j, this.A[count++]);
            }
        }
        count = 0;
        for (i = 0; i < this.dimA; ++i) {
            for (j = i; j < this.dimA; ++j) {
                Amatrix.set(j, i, this.A[count++] * this.V[i] * this.V[j]);
            }
        }
        return Amatrix;
    }

    public DoubleMatrix getSubsetOfA(boolean[] exclude) {
        int j;
        int i;
        int n = 0;
        for (boolean delete : exclude) {
            if (delete) continue;
            ++n;
        }
        DoubleMatrix subset = DoubleMatrixFactory.DEFAULT.make(n, n);
        int row = 0;
        int col = 0;
        int count = 0;
        for (i = 0; i < n; ++i) {
            for (j = i; j < n; ++j) {
                while (exclude[col] || exclude[row]) {
                    ++count;
                    if (++col != this.dimA) continue;
                    col = ++row;
                }
                subset.set(i, j, this.A[count++]);
                if (++col != this.dimA) continue;
                col = ++row;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = i + 1; j < n; ++j) {
                subset.set(j, i, subset.get(i, j));
            }
        }
        return subset;
    }

    public double[] getUTA() {
        return this.A;
    }

    public void setUTA(double[] A) {
        this.A = A;
        this.dimA = (int)Math.floor(Math.sqrt(2 * A.length));
        this.singular = new boolean[this.dimA];
        this.V = new double[this.dimA];
        for (int i = 0; i < this.dimA; ++i) {
            this.singular[i] = false;
            this.V[i] = 1.0;
        }
    }

    public void fullSweepSetDmin() {
        this.Dmin = new double[this.dimA];
        this.revg2sweep(0);
        for (int i = 0; i < this.dimA; ++i) {
            this.Dmin[i] = Math.max(this.A[this.diagonal(i)] * 1.0E-12, 1.0E-12);
        }
        for (int k = 1; k < this.dimA; ++k) {
            this.revg2sweep(k);
        }
    }

    public void XTXSweepSetDmin() {
        this.Dmin = new double[this.dimA];
        this.revg2sweep(0);
        for (int i = 0; i < this.dimA; ++i) {
            this.Dmin[i] = Math.max(this.A[this.diagonal(i)] * 1.0E-12, 1.0E-12);
        }
        for (int k = 1; k < this.dimA - 1; ++k) {
            this.revg2sweep(k);
        }
    }

    public SweepFast copy() {
        SweepFast copy = new SweepFast();
        int n = this.A.length;
        double[] newA = new double[n];
        System.arraycopy(this.A, 0, newA, 0, n);
        copy.A = newA;
        copy.dimA = this.dimA;
        n = this.Dmin.length;
        double[] newDmin = new double[n];
        System.arraycopy(this.Dmin, 0, newDmin, 0, n);
        copy.Dmin = newDmin;
        n = this.singular.length;
        boolean[] newsingular = new boolean[n];
        System.arraycopy(this.singular, 0, newsingular, 0, n);
        copy.singular = newsingular;
        n = this.V.length;
        double[] newV = new double[n];
        System.arraycopy(this.V, 0, newV, 0, n);
        copy.V = newV;
        return copy;
    }

    public int getDimensionOfA() {
        return this.dimA;
    }

    public boolean isSingular(int column) {
        return this.singular[column];
    }

    public static double[] UTAFromDoubleMatrix(DoubleMatrix A) {
        int nrows = A.numberOfRows();
        int n = nrows * (nrows + 1) / 2;
        double[] uta = new double[n];
        int count = 0;
        for (int i = 0; i < nrows; ++i) {
            for (int j = i; j < nrows; ++j) {
                uta[count++] = A.get(i, j);
            }
        }
        return uta;
    }
}

