/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.taxa.TaxaList;

public class AlignmentTableModel
extends AbstractTableModel
implements ChangeListener {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getPercentInstance();
    private COLUMN_NAME_TYPE myColumnNameType = COLUMN_NAME_TYPE.physicalPosition;
    private boolean myIsPhysicalPosition = true;
    private final GenotypeTable myAlignment;
    private int myHorizontalPageSize = 0;
    private int myHorizontalCenter = 0;
    private int myHorizontalStart = 0;
    private int myHorizontalEnd = 0;

    public AlignmentTableModel(GenotypeTable alignment, int horizontalPageSize) {
        if (alignment == null) {
            throw new IllegalArgumentException("AlignmentTableModel: init: alignment can not be null.");
        }
        this.myAlignment = alignment;
        this.myHorizontalCenter = this.myAlignment.numberOfSites() / 2;
        this.setHorizontalPageSize(horizontalPageSize);
    }

    public AlignmentTableModel(GenotypeTable alignment) {
        this(alignment, 100);
    }

    @Override
    public int getRowCount() {
        return this.myAlignment.numberOfTaxa();
    }

    @Override
    public int getColumnCount() {
        return this.myHorizontalPageSize;
    }

    @Override
    public Object getValueAt(int row, int col) {
        String result = null;
        int realColumn = 0;
        try {
            realColumn = col + this.myHorizontalStart;
            result = this.myAlignment.genotypeAsString(row, realColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("row: " + row + "   col: " + col + "   realColumn: " + realColumn);
            throw new IllegalStateException("AlignmentTableModel: getValueAt: row: " + row + "   col: " + col + "   realColumn: " + realColumn);
        }
        return result;
    }

    public int getRealColumnIndex(int col) {
        return col + this.myHorizontalStart;
    }

    public Object getRealValueAt(int row, int col) {
        return this.myAlignment.genotype(row, col);
    }

    @Override
    public String getColumnName(int col) {
        int realColumn = col + this.myHorizontalStart;
        if (this.myColumnNameType == COLUMN_NAME_TYPE.physicalPosition) {
            return String.valueOf(realColumn) + ": " + String.valueOf(this.myAlignment.chromosomalPosition(realColumn));
        }
        if (this.myColumnNameType == COLUMN_NAME_TYPE.siteNumber) {
            return String.valueOf(realColumn) + ": " + String.valueOf(this.myAlignment.chromosomalPosition(realColumn));
        }
        if (this.myColumnNameType == COLUMN_NAME_TYPE.locus) {
            return this.myAlignment.chromosomeName(realColumn);
        }
        if (this.myColumnNameType == COLUMN_NAME_TYPE.siteName) {
            return this.myAlignment.siteName(realColumn);
        }
        if (this.myColumnNameType == COLUMN_NAME_TYPE.alleles) {
            int[][] alleles = this.myAlignment.allelesSortedByFrequency(realColumn);
            int numAlleles = alleles[0].length;
            double total = 0.0;
            for (int i = 0; i < numAlleles; ++i) {
                total += (double)alleles[1][i];
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < numAlleles; ++i) {
                if (i != 0) {
                    builder.append("; ");
                }
                builder.append(NUMBER_FORMAT.format((double)alleles[1][i] / total));
                builder.append(this.myAlignment.genotypeAsString(realColumn, (byte)alleles[0][i]));
            }
            return builder.toString();
        }
        return String.valueOf(this.myAlignment.chromosomalPosition(realColumn));
    }

    public void setColumnNameType(COLUMN_NAME_TYPE type) {
        this.myColumnNameType = type;
        if (this.myColumnNameType == COLUMN_NAME_TYPE.physicalPosition) {
            this.myIsPhysicalPosition = true;
        } else if (this.myColumnNameType == COLUMN_NAME_TYPE.siteNumber) {
            this.myIsPhysicalPosition = false;
        }
        this.fireTableStructureChanged();
    }

    public boolean isPhysicalPosition() {
        return this.myIsPhysicalPosition;
    }

    public COLUMN_NAME_TYPE getColumnNameType() {
        return this.myColumnNameType;
    }

    public int getRealColumnCount() {
        return this.myAlignment.numberOfSites();
    }

    public int getHorizontalPageSize() {
        return this.myHorizontalPageSize;
    }

    public void setHorizontalPageSize(int horizontalSize) {
        if (horizontalSize == this.myHorizontalPageSize) {
            return;
        }
        this.myHorizontalPageSize = horizontalSize > this.getRealColumnCount() ? this.getRealColumnCount() : horizontalSize;
        this.adjustPositionInternal(this.myHorizontalCenter);
    }

    public int getHorizontalCenter() {
        return this.myHorizontalCenter;
    }

    private void adjustPositionInternal(int position) {
        int end;
        if (position < 0) {
            position = 0;
        } else if (position > this.getRealColumnCount() - 1) {
            position = this.getRealColumnCount() - 1;
        }
        this.myHorizontalCenter = position;
        int start = position - this.myHorizontalPageSize / 2;
        if (start < 0) {
            start = 0;
        }
        if ((end = start + this.myHorizontalPageSize - 1) >= this.getRealColumnCount()) {
            end = this.getRealColumnCount() - 1;
            start = end - this.myHorizontalPageSize + 1;
        }
        this.myHorizontalStart = start;
        this.myHorizontalEnd = end;
        this.fireTableStructureChanged();
    }

    public void adjustPosition(int position) {
        if (this.isPhysicalPosition() && (position = this.myAlignment.siteOfPhysicalPosition(position, this.myAlignment.chromosome(0))) < 0) {
            position = -position;
        }
        this.adjustPositionInternal(position);
    }

    public void adjustPositionToSite(int site) {
        this.adjustPositionInternal(site);
    }

    public void adjustPositionToCenter() {
        this.adjustPositionInternal(this.myAlignment.numberOfSites() / 2);
    }

    public void resetTable() {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public List getRowHeaders() {
        ArrayList result = new ArrayList();
        TaxaList idGroup = this.myAlignment.taxa();
        int n = idGroup.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            result.add(idGroup.get(i));
        }
        return result;
    }

    public void fireTableChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int position = source.getValue();
        this.adjustPosition(position);
    }

    public static enum COLUMN_NAME_TYPE {
        physicalPosition,
        siteNumber,
        locus,
        alleles,
        siteName;

    }
}

