/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.depth.AlleleDepthBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.HeaderPositions;
import net.maizegenetics.dna.snp.io.ProcessVCFBlock;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class BuilderFromVCF {
    private static final Logger myLogger = Logger.getLogger(BuilderFromHapMap.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[\\s]+");
    private HeaderPositions hp = null;
    private final String infile;
    private boolean includeDepth = false;
    private boolean inMemory = true;
    private String hdf5Outfile = null;
    private GenotypeTableBuilder hdf5GenoTableBuilder = null;

    private BuilderFromVCF(String infile) {
        this.infile = infile;
    }

    public static BuilderFromVCF getBuilder(String infile) {
        return new BuilderFromVCF(infile);
    }

    public BuilderFromVCF convertToHDF5(String hdf5Outfile) {
        this.inMemory = false;
        this.hdf5Outfile = hdf5Outfile;
        int numberOfSites = Utils.getNumberLinesNotHashOrBlank(hdf5Outfile);
        return this;
    }

    public BuilderFromVCF keepDepth() {
        this.includeDepth = true;
        return this;
    }

    public GenotypeTable build() {
        long time = System.nanoTime();
        GenotypeTable result = null;
        try {
            ProcessVCFBlock pb;
            int numThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            BufferedReader r = Utils.getBufferedReader(this.infile, -1);
            HashMap<String, String> infoMap = new HashMap<String, String>();
            HashMap<String, String> formatMap = new HashMap<String, String>();
            TreeMap<String, SetMultimap<String, String>> sampAnnoBuild = new TreeMap<String, SetMultimap<String, String>>();
            String currLine = BuilderFromVCF.parseVCFHeadersIntoMaps(infoMap, formatMap, sampAnnoBuild, r);
            TaxaList taxaList = this.processTaxa(currLine, sampAnnoBuild);
            int linesAtTime = 4096;
            ArrayList<String> txtLines = new ArrayList<String>(linesAtTime);
            ArrayList<ProcessVCFBlock> pbs = new ArrayList<ProcessVCFBlock>();
            int lines = 0;
            while ((currLine = r.readLine()) != null) {
                if (currLine.startsWith("#")) continue;
                txtLines.add(currLine);
                if (++lines % linesAtTime != 0) continue;
                pb = this.inMemory ? ProcessVCFBlock.getInstance(taxaList.numberOfTaxa(), this.hp, txtLines) : ProcessVCFBlock.getInstance(taxaList.numberOfTaxa(), this.hp, txtLines);
                pbs.add(pb);
                pool.execute(pb);
                txtLines = new ArrayList(linesAtTime);
            }
            r.close();
            if (txtLines.size() > 0) {
                pb = ProcessVCFBlock.getInstance(taxaList.numberOfTaxa(), this.hp, txtLines);
                pbs.add(pb);
                pool.execute(pb);
            }
            pool.shutdown();
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("BuilderFromHapMap: processing threads timed out.");
            }
            int currentSite = 0;
            PositionListBuilder posBuild = new PositionListBuilder();
            GenotypeCallTableBuilder gb = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(taxaList.numberOfTaxa(), lines);
            AlleleDepthBuilder db = null;
            if (this.includeDepth) {
                db = AlleleDepthBuilder.getInstance(taxaList.numberOfTaxa(), lines, 6);
            }
            for (ProcessVCFBlock pb2 : pbs) {
                posBuild.addAll(pb2.getBlkPosList());
                byte[][] bgTS = pb2.getGenoTS();
                for (int t = 0; t < bgTS.length; ++t) {
                    gb.setBaseRangeForTaxon(t, currentSite, bgTS[t]);
                }
                if (this.includeDepth) {
                    byte[][][] bdTS = pb2.getDepthTS();
                    for (int t = 0; t < bgTS.length; ++t) {
                        db.setDepthRangeForTaxon(t, currentSite, bdTS[t]);
                    }
                }
                currentSite += pb2.getSiteNumber();
            }
            if (!posBuild.validateOrdering()) {
                throw new IllegalStateException("BuilderFromHapMap: Ordering incorrect HapMap must be ordered by position");
            }
            GenotypeCallTable g = gb.build();
            result = this.includeDepth ? GenotypeTableBuilder.getInstance(g, posBuild.build(), taxaList, null, db.build()) : GenotypeTableBuilder.getInstance(g, posBuild.build(), taxaList);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        long totalTime = System.nanoTime() - time;
        System.out.printf("BuilderFromVCF data timing %gs %n", (double)totalTime / 1.0E9);
        return result;
    }

    private static String parseVCFHeadersIntoMaps(Map<String, String> infoMap, Map<String, String> formatMap, Map<String, SetMultimap<String, String>> sampAnnoBuild, BufferedReader r) throws IOException {
        String currLine;
        while ((currLine = r.readLine()) != null && currLine.startsWith("##")) {
            String[] cat = currLine.split("=", 2);
            if (cat.length < 2) continue;
            switch (cat[0]) {
                case "##SAMPLE": {
                    SetMultimap<String, String> mapOfAnno = TaxaListIOUtils.parseVCFHeadersIntoMap(cat[1]);
                    String taxaID = (String)mapOfAnno.get((Object)"ID").iterator().next();
                    if (taxaID == null) break;
                    sampAnnoBuild.put(taxaID, mapOfAnno);
                    break;
                }
                case "##PEDIGREE": {
                    break;
                }
            }
        }
        return currLine;
    }

    private static String getReplaceCommaWithinQuote(String s) {
        StringBuilder sb = new StringBuilder(s);
        boolean inQuote = false;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\"') {
                boolean bl = inQuote = !inQuote;
            }
            if (inQuote && sb.charAt(i) == ',') {
                sb.setCharAt(i, '\u012c');
            }
            if (!inQuote || sb.charAt(i) != '=') continue;
            sb.setCharAt(i, '\u013d');
        }
        return sb.toString();
    }

    private TaxaList processTaxa(String readLn, Map<String, SetMultimap<String, String>> taxaAnnotation) {
        String[] header = WHITESPACE_PATTERN.split(readLn);
        this.hp = new HeaderPositions(header);
        int numTaxa = header.length - this.hp.NUM_HAPMAP_NON_TAXA_HEADERS;
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (int i = 0; i < numTaxa; ++i) {
            String taxonID = header[i + this.hp.NUM_HAPMAP_NON_TAXA_HEADERS];
            Taxon.Builder at = new Taxon.Builder(taxonID);
            SetMultimap<String, String> taMap = taxaAnnotation.get(taxonID);
            if (taMap != null) {
                for (Map.Entry en : taMap.entries()) {
                    if (((String)en.getKey()).equals("ID")) continue;
                    String s = ((String)en.getValue()).replace("\"", "");
                    at.addAnno((String)en.getKey(), s);
                }
            }
            tlb.add(at.build());
        }
        return tlb.build();
    }
}

