/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.IOException;
import java.io.PushbackReader;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.FormattedInput;
import net.maizegenetics.util.InputSource;

public class ReadSequenceAlignmentUtils {
    private ReadSequenceAlignmentUtils() {
    }

    public static GenotypeTable readBasicAlignments(PushbackReader input, int maxLabelLength) throws IOException {
        GenotypeTable saa = null;
        saa = ReadSequenceAlignmentUtils.readFile(input, maxLabelLength);
        return saa;
    }

    public static GenotypeTable readBasicAlignments(String file, int maxLabelLength) throws IOException {
        InputSource input = InputSource.openFile(file);
        GenotypeTable saa = ReadSequenceAlignmentUtils.readBasicAlignments(input, maxLabelLength);
        input.close();
        return saa;
    }

    private static GenotypeTable readFile(PushbackReader in, int maxLabelLength) throws IOException {
        return ReadSequenceAlignmentUtils.readPHYLIP(in, maxLabelLength);
    }

    private static GenotypeTable readPHYLIP(PushbackReader in, int maxLabelLength) {
        TaxaList idGroup;
        FormattedInput fi = FormattedInput.getInstance();
        int numSeqs = 0;
        int numSites = 0;
        int lineLength = 0;
        char[][] data = null;
        int pos = 0;
        int seq = 0;
        try {
            int c;
            numSeqs = fi.readInt(in);
            numSites = fi.readInt(in);
            String[] identifiers = new String[numSeqs];
            data = new char[numSeqs][numSites];
            String header = fi.readLine(in, false);
            boolean interleaved = true;
            if (header.length() > 0 && header.charAt(0) == 'S') {
                interleaved = false;
            }
            if (interleaved) {
                while (pos < numSites) {
                    c = fi.readNextChar(in);
                    in.unread(c);
                    for (seq = 0; seq < numSeqs; ++seq) {
                        lineLength = ReadSequenceAlignmentUtils.readSeqLineP(in, seq, pos, numSites, data, identifiers, fi, maxLabelLength, lineLength);
                    }
                    pos += lineLength;
                }
            } else {
                for (seq = 0; seq < numSeqs; ++seq) {
                    c = fi.readNextChar(in);
                    in.unread(c);
                    identifiers[seq] = fi.readLabel(in, maxLabelLength).toUpperCase();
                    for (pos = 0; pos < numSites; ++pos) {
                        data[seq][pos] = (char)fi.readNextChar(in);
                        if (data[0][pos] != '.') continue;
                        if (seq == 0) {
                            throw new IllegalArgumentException("Copy character (.) in first sequence not allowed (pos. " + (pos + 1) + ")");
                        }
                        data[seq][pos] = data[0][pos];
                    }
                }
            }
            idGroup = new TaxaListBuilder().addAll(identifiers).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO error after pos. " + (pos + 1) + ", seq. " + (seq + 1));
        }
        String[] s = new String[numSeqs];
        for (int i = 0; i < numSeqs; ++i) {
            s[i] = new String(data[i]).toUpperCase();
        }
        String[] sites = new String[numSites];
        int[] positions = new int[numSites];
        for (int i = 0; i < numSites; ++i) {
            positions[i] = i;
            sites[i] = Integer.toString(i);
        }
        GenotypeCallTable genotype = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(numSeqs, numSites).setBases(s).build();
        return GenotypeTableBuilder.getInstance(genotype, null, idGroup);
    }

    private static int readSeqLineP(PushbackReader in, int s, int pos, int maxPos, char[][] data, String[] identifiers, FormattedInput fi, int maxLabelLength, int lineLength) throws IOException {
        if (pos == 0) {
            identifiers[s] = fi.readLabel(in, maxLabelLength).toUpperCase();
        }
        if (s == 0) {
            String thisLine = fi.readLine(in, false);
            lineLength = thisLine.length() > maxPos - pos ? maxPos - pos : thisLine.length();
            for (int i = 0; i < lineLength; ++i) {
                data[0][pos + i] = thisLine.charAt(i);
                if (data[0][pos + i] != '.') continue;
                throw new IllegalArgumentException("Copy character (.) in first sequence not allowed (pos. " + (i + pos + 1) + ")");
            }
        } else {
            for (int i = 0; i < lineLength; ++i) {
                data[s][pos + i] = (char)fi.readNextChar(in);
                if (data[s][pos + i] != '.') continue;
                data[s][pos + i] = data[0][pos + i];
            }
            fi.nextLine(in);
        }
        return lineLength;
    }
}

