/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.BufferedReader;
import java.util.regex.Pattern;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.BuilderFromVCF;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ImportUtils {
    private static final Logger myLogger = Logger.getLogger(ImportUtils.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    public static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;

    private ImportUtils() {
    }

    public static GenotypeTable readGuessFormat(String fileName) {
        try {
            if (fileName.endsWith(".h5")) {
                return GenotypeTableBuilder.getInstance(fileName);
            }
            if (fileName.endsWith("hmp.txt.gz") || fileName.endsWith("hmp.txt")) {
                return ImportUtils.readFromHapmap(fileName, null);
            }
            if (fileName.endsWith(".vcf") || fileName.endsWith(".vcf.gz")) {
                return ImportUtils.readFromVCF(fileName, null);
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error reading:" + fileName);
            e.printStackTrace();
            return null;
        }
    }

    private static int getNumHeaderRowsVCF(String filename) {
        BufferedReader fileIn = null;
        try {
            int numHeader = 0;
            fileIn = Utils.getBufferedReader(filename, 1000000);
            String currLine = fileIn.readLine();
            while (currLine != null && currLine.substring(0, 1).equals("#")) {
                ++numHeader;
                currLine = fileIn.readLine();
            }
            int n = numHeader;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Error in getNumSiteVCF, unable to read VCF file: " + ExceptionUtils.getExceptionCauses(e));
        }
        finally {
            try {
                fileIn.close();
            }
            catch (Exception e) {}
        }
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener, boolean ignoreDepth) {
        if (ignoreDepth) {
            return BuilderFromVCF.getBuilder(filename).keepDepth().build();
        }
        return BuilderFromVCF.getBuilder(filename).build();
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener) {
        return ImportUtils.readFromVCF(filename, listener, true);
    }

    public static GenotypeTable readFromHapmap(String filename) {
        return BuilderFromHapMap.getBuilder(filename).build();
    }

    public static GenotypeTable readFromHapmap(String filename, ProgressListener listener) {
        return BuilderFromHapMap.getBuilder(filename).build();
    }

    public static GenotypeTable readFromPLink(String pedFilename, String mapFilename, ProgressListener listener) {
        return null;
    }
}

