/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.AbstractTagsOnPhysicalMap;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TagGeneticMappingInfo;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import org.apache.log4j.Logger;

public class TagsOnPhysicalMapV3
extends AbstractTagsOnPhysicalMap
implements TOPMInterface {
    private static final Logger myLogger = Logger.getLogger(TagsOnPhysicalMapV3.class);
    private static final int BITS_TO_SHIFT_FOR_CHUNK = 16;
    private static final int CHUNK_SIZE = 65536;
    private static HDF5GenericStorageFeatures genoFeatures = HDF5GenericStorageFeatures.createDeflation((int)5);
    private static HDF5IntStorageFeatures vectorFeatures = HDF5IntStorageFeatures.createDeflation((int)5);
    protected int mappingNum = 0;
    private IHDF5Writer myHDF5 = null;
    private int cachedTagIndex = -1;
    private int cachedMapIndex = -1;
    private int cachedGeneticMapIndex = -1;
    private TagMappingInfoV3 cachedTMI = null;
    private TagGeneticMappingInfo cachedTGMI = null;
    private TagGeneticMappingInfo cachedTGMIGW = null;
    private int cachedMappingChunkIndex = -1;
    private int cachedGeneticMappingChunkIndex = -1;
    private int cachedGeneticMappingGWChunkIndex = -1;
    private String[] mapNames = null;
    private String[] geneticMapNames = null;
    private TagMappingInfoV3[][] cachedTMIChunk = null;
    private TagGeneticMappingInfo[][] cachedTGMIChunk = null;
    private TagGeneticMappingInfo[] cachedTGMIGWChunk = null;
    private int mappingChunkStartTagIndex;
    private int mappingChunkEndTagIndex;
    private int geneticMappingChunkStartTagIndex;
    private int geneticMappingChunkEndTagIndex;
    private int geneticMappingGWChunkStartTagIndex;
    private int geneticMappingGWChunkEndTagIndex;
    private TagMappingInfoV3.Aligner currentAligner = null;
    private int[] mappingIndexOfAligner = null;
    private boolean cleanMap = true;
    private boolean cacheAllMappingBlocks = false;
    private HDF5CompoundType<TagMappingInfoV3> tmiType = null;
    private HDF5CompoundType<TagGeneticMappingInfo> tgmiType = null;
    private boolean hasDetailedMapping = false;
    int[] bestEndPosition;
    byte[] bestDivergence;
    byte[] bestMapP;
    byte[] bestDcoP;
    byte[] bestEvidence;
    byte[] bestMapIndex;

    public static void createFile(Tags inTags, String newHDF5file) {
        int tagLengthInLong = inTags.getTagSizeInLong();
        int tagCount = inTags.getTagCount();
        long[][] tags = new long[tagLengthInLong][tagCount];
        byte[] tagLength = new byte[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            long[] ct = inTags.getTag(i);
            for (int j = 0; j < tagLengthInLong; ++j) {
                tags[j][i] = ct[j];
            }
            tagLength[i] = (byte)inTags.getTagLength(i);
        }
        IHDF5Writer h5 = null;
        try {
            myLogger.info((Object)("Creating HDF5 File: " + newHDF5file));
            IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(newHDF5file));
            config.overwrite();
            config.useUTF8CharacterEncoding();
            h5 = config.writer();
            h5.setIntAttribute("/", "maxMapping", 0);
            h5.setIntAttribute("/", "tagLengthInLong", tagLengthInLong);
            h5.setIntAttribute("/", "tagCount", tagCount);
            h5.createLongMatrix("tags", (long)inTags.getTagSizeInLong(), (long)tagCount, inTags.getTagSizeInLong(), tagCount, vectorFeatures);
            h5.writeLongMatrix("tags", tags, vectorFeatures);
            tags = null;
            System.out.println("...Tags written");
            h5.createByteArray("tagLength", tagCount, vectorFeatures);
            h5.writeByteArray("tagLength", tagLength, vectorFeatures);
            tagLength = null;
            System.out.println("...Tags lengths written");
            System.gc();
            h5.flush();
            h5.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            h5.close();
            System.exit(1);
        }
    }

    public TagsOnPhysicalMapV3(String theHDF5file) {
        System.out.println("Opening: " + theHDF5file);
        this.myHDF5 = HDF5Factory.open((String)theHDF5file);
        this.tmiType = this.myHDF5.compounds().getInferredType(TagMappingInfoV3.class);
        this.tgmiType = this.myHDF5.compounds().getInferredType(TagGeneticMappingInfo.class);
        this.tagLengthInLong = this.myHDF5.getIntAttribute("/", "tagLengthInLong");
        this.myNumTags = this.myHDF5.getIntAttribute("/", "tagCount");
        this.tags = this.myHDF5.readLongMatrix("tags");
        this.tagLength = this.myHDF5.readByteArray("tagLength");
        this.mappingNum = this.myHDF5.getIntAttribute("/", "maxMapping");
        if (this.getIfHasMapping()) {
            this.renameMapNames();
            this.getMappingInfo(0, 0);
        }
        if (this.getIfHasGeneticMapping()) {
            this.renameGeneticMapNames();
            this.cachedTagIndex = -1;
            this.getGeneticMappingInfo(0, 0);
        }
        if (this.getIfHasGeneticMappingGW()) {
            this.getGeneticMappingInfoGW(0);
            this.cachedTagIndex = -1;
            this.cachedTGMIGW = this.cachedTGMIGWChunk[0];
        }
        if (this.myHDF5.exists("bestStrand")) {
            this.bestStrand = this.myHDF5.readByteArray("bestStrand");
            this.bestChr = this.myHDF5.readIntArray("bestChr");
            this.bestStartPos = this.myHDF5.readIntArray("bestStartPos");
            this.bestEndPosition = this.myHDF5.readIntArray("bestEndPos");
            this.bestDivergence = this.myHDF5.readByteArray("bestDivergence");
            this.bestMapP = this.myHDF5.readByteArray("bestMapP");
            this.bestDcoP = this.myHDF5.readByteArray("bestDcoP");
            this.multimaps = this.myHDF5.readByteArray("multimaps");
            this.bestEvidence = this.myHDF5.readByteArray("bestEvidence");
            this.bestMapIndex = this.myHDF5.readByteArray("bestMapIndex");
            this.loadVariantsIntoMemory();
            this.populateChrAndVarPositions();
            this.initPhysicalSort();
        }
        System.gc();
    }

    public void writeTextMap(String tagCountFileS, String outputFileS) {
        TagCounts tc = new TagCounts(tagCountFileS, TagsByTaxa.FilePacking.Byte);
        String[] title = new String[]{"AChr", "AStartPos", "AEndPos", "Divergence", "Source", "Rank", "Score", "PValue", "GChr", "GPos", "SigSiteNum", "SigSiteRange"};
        try {
            int i;
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileS), 65536);
            bw.write("Tag\tTagLength\tTagCount\tGWGChr\tGWGPos\t");
            for (i = 0; i < this.getMappingNum(); ++i) {
                String mapIndexS = this.getThreeFigureString(i);
                for (int j = 0; j < title.length; ++j) {
                    bw.write(title[j] + "-" + mapIndexS + "\t");
                }
            }
            bw.newLine();
            for (i = 0; i < this.getTagCount(); ++i) {
                long[] tag = this.getTag(i);
                bw.write(BaseEncoder.getSequenceFromLong(tag) + "\t" + String.valueOf(this.getTagLength(i)) + "\t");
                int index = tc.getTagIndex(tag);
                bw.write(String.valueOf(tc.getReadCount(index)) + "\t");
                TagGeneticMappingInfo tgmi = this.getGeneticMappingInfoGW(i);
                bw.write(String.valueOf(tgmi.chromosome) + "\t" + String.valueOf(tgmi.position) + "\t");
                for (int j = 0; j < this.getMappingNum(); ++j) {
                    TagMappingInfoV3 tmi = this.getMappingInfo(i, j);
                    bw.write(String.valueOf(tmi.chromosome) + "\t");
                    bw.write(String.valueOf(tmi.startPosition) + "\t");
                    bw.write(String.valueOf(tmi.endPosition) + "\t");
                    bw.write(String.valueOf(tmi.divergence) + "\t");
                    bw.write(String.valueOf(tmi.mappingSource) + "\t");
                    bw.write(String.valueOf(tmi.mappingRank) + "\t");
                    bw.write(String.valueOf(tmi.mappingScore) + "\t");
                    tgmi = this.getGeneticMappingInfo(i, j);
                    bw.write(String.valueOf(tgmi.p) + "\t");
                    bw.write(String.valueOf(tgmi.chromosome) + "\t");
                    bw.write(String.valueOf(tgmi.position) + "\t");
                    bw.write(String.valueOf(tgmi.sigSiteNum) + "\t");
                    bw.write(String.valueOf(tgmi.sigSiteRange) + "\t");
                }
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    public void writeSubTOPM(String outputFileS, int[] tagIndex) {
        int k;
        int j;
        int actualSize;
        int endTagIndex;
        int startTagIndex;
        int i;
        int tagLengthInLong = this.getTagSizeInLong();
        int tagCount = tagIndex.length;
        long[][] tags = new long[tagLengthInLong][tagCount];
        byte[] tagLength = new byte[tagCount];
        for (int i2 = 0; i2 < tagCount; ++i2) {
            long[] t = this.getTag(tagIndex[i2]);
            for (int j2 = 0; j2 < tagLengthInLong; ++j2) {
                tags[j2][i2] = t[j2];
            }
            tagLength[i2] = (byte)this.getTagLength(tagIndex[i2]);
        }
        IHDF5Writer h5 = null;
        try {
            myLogger.info((Object)("Creating HDF5 File: " + outputFileS));
            IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(outputFileS));
            config.overwrite();
            config.useUTF8CharacterEncoding();
            h5 = config.writer();
            h5.setIntAttribute("/", "maxMapping", 0);
            h5.setIntAttribute("/", "tagLengthInLong", tagLengthInLong);
            h5.setIntAttribute("/", "tagCount", tagCount);
            h5.createLongMatrix("tags", (long)tagLengthInLong, (long)tagCount, tagLengthInLong, tagCount, vectorFeatures);
            h5.writeLongMatrix("tags", tags, vectorFeatures);
            tags = null;
            System.out.println("...Tags written");
            h5.createByteArray("tagLength", tagCount, vectorFeatures);
            h5.writeByteArray("tagLength", tagLength, vectorFeatures);
            tagLength = null;
            System.out.println("...Tags lengths written");
            System.gc();
            h5.flush();
            h5.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            h5.close();
            System.exit(1);
        }
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(outputFileS);
        if (this.getMappingNum() != 0) {
            String[] mapNames = topm.creatTagMappingInfoDatasets(0, this.getMappingNum());
            TagMappingInfoV3[][] tmiBuffer = new TagMappingInfoV3[this.getMappingNum()][topm.getChunkSize()];
            for (i = 0; i < topm.getChunkNum(); ++i) {
                startTagIndex = i * topm.getChunkSize();
                endTagIndex = startTagIndex + topm.getChunkSize();
                actualSize = topm.getChunkSize();
                if (endTagIndex > topm.getTagCount()) {
                    for (j = actualSize = topm.getTagCount() - startTagIndex; j < topm.getChunkSize(); ++j) {
                        for (k = 0; k < this.getMappingNum(); ++k) {
                            tmiBuffer[k][j] = new TagMappingInfoV3();
                        }
                    }
                }
                for (j = 0; j < actualSize; ++j) {
                    for (k = 0; k < this.getMappingNum(); ++k) {
                        tmiBuffer[k][j] = this.getMappingInfo(tagIndex[startTagIndex + j], k);
                    }
                }
                topm.writeTagMappingInfoDataSets(mapNames, tmiBuffer, i);
            }
            topm.setMappingNum(this.getMappingNum());
        }
        if (this.getIfHasGeneticMapping()) {
            String[] mapNames = topm.creatTagGeneticMappingInfoDatasets(0, this.getMappingNum());
            TagGeneticMappingInfo[][] tgmiBuffer = new TagGeneticMappingInfo[this.getMappingNum()][topm.getChunkSize()];
            for (i = 0; i < topm.getChunkNum(); ++i) {
                startTagIndex = i * topm.getChunkSize();
                endTagIndex = startTagIndex + topm.getChunkSize();
                actualSize = topm.getChunkSize();
                if (endTagIndex > topm.getTagCount()) {
                    for (j = actualSize = topm.getTagCount() - startTagIndex; j < topm.getChunkSize(); ++j) {
                        for (k = 0; k < this.getMappingNum(); ++k) {
                            tgmiBuffer[k][j] = new TagGeneticMappingInfo();
                        }
                    }
                }
                for (j = 0; j < actualSize; ++j) {
                    for (k = 0; k < this.getMappingNum(); ++k) {
                        tgmiBuffer[k][j] = this.getGeneticMappingInfo(tagIndex[startTagIndex + j], k);
                    }
                }
                topm.writeTagGeneticMappingInfoDataSets(mapNames, tgmiBuffer, i);
            }
        }
        if (this.getIfHasGeneticMappingGW()) {
            String dataSetName = topm.creatTagGeneticMappingInfoGWDataset();
            for (i = 0; i < topm.getChunkNum(); ++i) {
                TagGeneticMappingInfo[] gmChunk = new TagGeneticMappingInfo[topm.getChunkSize()];
                startTagIndex = i * topm.getChunkSize();
                endTagIndex = startTagIndex + topm.getChunkSize();
                actualSize = topm.getChunkSize();
                if (endTagIndex > topm.getTagCount()) {
                    for (j = actualSize = topm.getTagCount() - startTagIndex; j < topm.getChunkSize(); ++j) {
                        gmChunk[j] = new TagGeneticMappingInfo();
                    }
                }
                for (j = 0; j < actualSize; ++j) {
                    gmChunk[j] = this.getGeneticMappingInfoGW(tagIndex[startTagIndex + j]);
                }
                topm.writeTagGeneticMappingInfoGWDataSet(dataSetName, gmChunk, i);
                if (i % 100 != 0) continue;
                System.out.println("Chunk " + i + "(index) with " + topm.getChunkSize() + " tags is annotated with genome wide genetic mapping");
            }
        }
    }

    public String[] creatTagMappingInfoDatasets(int startIndex, int size) {
        int i;
        int chunkCount = this.getChunkNum();
        int chunkSize = this.getChunkSize();
        String[] dataSetNames = new String[size];
        for (i = 0; i < size; ++i) {
            dataSetNames[i] = "map" + this.getThreeFigureString(i + startIndex);
            this.myHDF5.compounds().createArray(dataSetNames[i], this.tmiType, (long)(chunkSize * chunkCount), chunkSize, genoFeatures);
        }
        System.out.println("Created new TagMappingInfo datasets. They are");
        for (i = 0; i < dataSetNames.length; ++i) {
            System.out.println(dataSetNames[i]);
        }
        return dataSetNames;
    }

    public String[] creatTagGeneticMappingInfoDatasets(int startIndex, int size) {
        int i;
        int chunkCount = this.getChunkNum();
        int chunkSize = this.getChunkSize();
        String[] dataSetNames = new String[size];
        for (i = 0; i < size; ++i) {
            dataSetNames[i] = "gm" + this.getThreeFigureString(i + startIndex);
            this.myHDF5.compounds().createArray(dataSetNames[i], this.tgmiType, (long)(chunkSize * chunkCount), chunkSize, genoFeatures);
        }
        System.out.println("Created new TagGeneticMappingInfo datasets. They are");
        for (i = 0; i < dataSetNames.length; ++i) {
            System.out.println(dataSetNames[i]);
        }
        return dataSetNames;
    }

    public String creatTagGeneticMappingInfoGWDataset() {
        int chunkCount = this.getChunkNum();
        int chunkSize = this.getChunkSize();
        this.myHDF5.compounds().createArray("gmgw", this.tgmiType, (long)(chunkSize * chunkCount), chunkSize, genoFeatures);
        System.out.println("Created new TagGeneticMappingInfoGW dataset: gmgw");
        return "gmgw";
    }

    public void writeBestMappingDataSets(byte[] bestStrand, int[] bestChr, int[] bestStartPos, int[] bestEndPos, byte[] bestDivergence, byte[] bestMapP, byte[] bestDcoP, byte[] multimaps, byte[] bestEvidence, byte[] bestMapIndex) {
        this.bestStrand = bestStrand;
        this.bestChr = bestChr;
        this.bestStartPos = bestStartPos;
        this.multimaps = multimaps;
        this.bestEvidence = bestEvidence;
        if (bestStrand.length != this.getTagCount() || bestChr.length != this.getTagCount() || bestStartPos.length != this.getTagCount() || multimaps.length != this.getTagCount()) {
            System.out.println("Size of best mapping arrays is not equal to tag count, program quits");
            System.exit(0);
        }
        this.myHDF5.createByteArray("bestStrand", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestStrand", bestStrand);
        this.myHDF5.createIntArray("bestChr", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeIntArray("bestChr", bestChr);
        this.myHDF5.createIntArray("bestStartPos", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeIntArray("bestStartPos", bestStartPos);
        this.myHDF5.createIntArray("bestEndPos", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeIntArray("bestEndPos", bestEndPos);
        this.myHDF5.createByteArray("bestDivergence", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestDivergence", bestDivergence);
        this.myHDF5.createByteArray("bestMapP", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestMapP", bestMapP);
        this.myHDF5.createByteArray("bestDcoP", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestDcoP", bestDcoP);
        this.myHDF5.createByteArray("multimaps", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("multimaps", multimaps);
        this.myHDF5.createByteArray("bestEvidence", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestEvidence", bestEvidence);
        this.myHDF5.createByteArray("bestMapIndex", this.getTagCount(), vectorFeatures);
        this.myHDF5.writeByteArray("bestMapIndex", bestMapIndex);
        System.out.println("Best mapping positions from hypotheses are selected and saved to HDF5 TOPM");
    }

    public void writeTagMappingInfoDataSets(String[] dataSetNames, TagMappingInfoV3[][] tmiChunk, int chunkIndex) {
        for (int i = 0; i < dataSetNames.length; ++i) {
            this.myHDF5.compounds().writeArrayBlock(dataSetNames[i], this.tmiType, tmiChunk[i], (long)chunkIndex);
        }
    }

    public void writeTagGeneticMappingInfoDataSets(String[] dataSetNames, TagGeneticMappingInfo[][] tgmiChunk, int chunkIndex) {
        for (int i = 0; i < dataSetNames.length; ++i) {
            this.myHDF5.compounds().writeArrayBlock(dataSetNames[i], this.tgmiType, tgmiChunk[i], (long)chunkIndex);
        }
    }

    public void writeTagGeneticMappingInfoGWDataSet(String dataSetName, TagGeneticMappingInfo[] tgmiChunk, int chunkIndex) {
        this.myHDF5.compounds().writeArrayBlock(dataSetName, this.tgmiType, (Object[])tgmiChunk, (long)chunkIndex);
    }

    public void setMappingNum(int mappingNum) {
        this.mappingNum = mappingNum;
        this.myHDF5.setIntAttribute("/", "maxMapping", mappingNum);
        this.renameMapNames();
        System.out.println("TOPM maxMapping attibute was set to " + String.valueOf(mappingNum));
    }

    private void renameMapNames() {
        if (this.mappingNum == 0) {
            this.mapNames = null;
            return;
        }
        this.mapNames = new String[this.mappingNum];
        for (int i = 0; i < this.mappingNum; ++i) {
            this.mapNames[i] = "map" + this.getThreeFigureString(i);
        }
    }

    private void renameGeneticMapNames() {
        if (!this.getIfHasGeneticMapping()) {
            this.geneticMapNames = null;
            return;
        }
        this.geneticMapNames = new String[this.mappingNum];
        for (int i = 0; i < this.mappingNum; ++i) {
            this.geneticMapNames[i] = "gm" + this.getThreeFigureString(i);
        }
    }

    private boolean loadVariantsIntoMemory() {
        int howManyDef = 0;
        int readBlock = this.getChunkSize();
        this.variantDefs = new byte[this.myNumTags][];
        this.variantOffsets = new byte[this.myNumTags][];
        if (!this.myHDF5.exists("variantDef")) {
            return false;
        }
        for (int blockStep = 0; blockStep < this.myNumTags; blockStep += readBlock) {
            int blockSize = this.myNumTags - blockStep < readBlock ? this.myNumTags - blockStep : readBlock;
            byte[][] vd = this.myHDF5.readByteMatrixBlockWithOffset("variantDef", blockSize, this.myMaxVariants, (long)blockStep, 0L);
            byte[][] vo = this.myHDF5.readByteMatrixBlockWithOffset("variantPosOff", blockSize, this.myMaxVariants, (long)blockStep, 0L);
            for (int j = 0; j < blockSize; ++j) {
                int cnt = 0;
                for (byte bs : vd[j]) {
                    if (bs == -128) continue;
                    ++cnt;
                }
                if (cnt == 0) continue;
                byte[] vdReDim = new byte[cnt];
                byte[] voReDim = new byte[cnt];
                for (int i = 0; i < cnt; ++i) {
                    vdReDim[i] = vd[j][i];
                    voReDim[i] = vo[j][i];
                    ++howManyDef;
                }
                this.variantDefs[blockStep + j] = vdReDim;
                this.variantOffsets[blockStep + j] = voReDim;
            }
        }
        System.out.println("Real Variant Defs:" + howManyDef);
        return true;
    }

    private static boolean writeVariantsToHDF5(IHDF5Writer aHDF5, AbstractTagsOnPhysicalMap aTOPM) {
        int howManyDef = 0;
        int readBlock = 65536;
        int myNumTags = aTOPM.myNumTags;
        int myMaxVariants = aTOPM.myMaxVariants;
        aHDF5.createByteMatrix("variantDef", myNumTags, myMaxVariants);
        aHDF5.createByteMatrix("variantPosOff", myNumTags, myMaxVariants);
        if (!aHDF5.exists("variantDef")) {
            return false;
        }
        byte[][] vd = new byte[readBlock][myMaxVariants];
        byte[][] vo = new byte[readBlock][myMaxVariants];
        for (int blockStep = 0; blockStep < myNumTags; blockStep += readBlock) {
            int blockSize = myNumTags - blockStep < readBlock ? myNumTags - blockStep : readBlock;
            vd = new byte[blockSize][myMaxVariants];
            vo = new byte[blockSize][myMaxVariants];
            for (int j = 0; j < blockSize; ++j) {
                for (int v = 0; v < vo[0].length; ++v) {
                    vd[j][v] = aTOPM.getVariantDef(blockStep + j, v);
                    vo[j][v] = aTOPM.getVariantPosOff(blockStep + j, v);
                }
            }
            aHDF5.writeByteMatrixBlockWithOffset("variantDef", vd, (long)blockStep, 0L);
            aHDF5.writeByteMatrixBlockWithOffset("variantPosOff", vo, (long)blockStep, 0L);
        }
        System.out.println("Real Variant Defs:" + howManyDef);
        return true;
    }

    private synchronized void cacheMappingInfoChunk(int chunkIndex) {
        this.cachedTMIChunk = new TagMappingInfoV3[this.getMappingNum()][this.getChunkSize()];
        for (int i = 0; i < this.mappingNum; ++i) {
            this.cachedTMIChunk[i] = (TagMappingInfoV3[])this.myHDF5.compounds().readArrayBlock(this.mapNames[i], this.tmiType, this.getChunkSize(), (long)chunkIndex);
        }
        this.cachedMappingChunkIndex = chunkIndex;
        this.mappingChunkStartTagIndex = chunkIndex * this.getChunkSize();
        this.mappingChunkEndTagIndex = this.mappingChunkStartTagIndex + this.getChunkSize();
        if (this.mappingChunkEndTagIndex > this.getTagCount()) {
            this.mappingChunkEndTagIndex = this.getTagCount();
        }
    }

    private synchronized void cacheGeneticMappingInfoChunk(int chunkIndex) {
        this.cachedTGMIChunk = new TagGeneticMappingInfo[this.getMappingNum()][this.getChunkSize()];
        for (int i = 0; i < this.mappingNum; ++i) {
            this.cachedTGMIChunk[i] = (TagGeneticMappingInfo[])this.myHDF5.compounds().readArrayBlock(this.geneticMapNames[i], this.tgmiType, this.getChunkSize(), (long)chunkIndex);
        }
        this.cachedGeneticMappingChunkIndex = chunkIndex;
        this.geneticMappingChunkStartTagIndex = chunkIndex * this.getChunkSize();
        this.geneticMappingChunkEndTagIndex = this.geneticMappingChunkStartTagIndex + this.getChunkSize();
        if (this.geneticMappingChunkEndTagIndex > this.getTagCount()) {
            this.geneticMappingChunkEndTagIndex = this.getTagCount();
        }
    }

    private synchronized void cacheGeneticMappingInfoGWChunk(int chunkIndex) {
        this.cachedTGMIGWChunk = new TagGeneticMappingInfo[this.getChunkSize()];
        this.cachedTGMIGWChunk = (TagGeneticMappingInfo[])this.myHDF5.compounds().readArrayBlock("gmgw", this.tgmiType, this.getChunkSize(), (long)chunkIndex);
        this.cachedGeneticMappingGWChunkIndex = chunkIndex;
        this.geneticMappingGWChunkStartTagIndex = chunkIndex * this.getChunkSize();
        this.geneticMappingGWChunkEndTagIndex = this.geneticMappingGWChunkStartTagIndex + this.getChunkSize();
        if (this.geneticMappingGWChunkEndTagIndex > this.getTagCount()) {
            this.geneticMappingGWChunkEndTagIndex = this.getTagCount();
        }
    }

    private synchronized void cacheMappingInfo(int tagIndex, int mapIndex) {
        if (tagIndex == this.cachedTagIndex && mapIndex == this.cachedMapIndex) {
            return;
        }
        int chunkIndex = tagIndex >> 16;
        if (chunkIndex != this.cachedMappingChunkIndex) {
            this.cacheMappingInfoChunk(chunkIndex);
        }
        this.cachedTMI = this.cachedTMIChunk[mapIndex][tagIndex % this.getChunkSize()];
        this.cachedTagIndex = tagIndex;
        this.cachedMapIndex = mapIndex;
    }

    private synchronized void cacheGeneticMappingInfo(int tagIndex, int geneticMapIndex) {
        if (tagIndex == this.cachedTagIndex && geneticMapIndex == this.cachedGeneticMapIndex) {
            return;
        }
        int chunkIndex = tagIndex >> 16;
        if (chunkIndex != this.cachedGeneticMappingChunkIndex) {
            this.cacheGeneticMappingInfoChunk(chunkIndex);
        }
        this.cachedTGMI = this.cachedTGMIChunk[geneticMapIndex][tagIndex % this.getChunkSize()];
        this.cachedTagIndex = tagIndex;
        this.cachedGeneticMapIndex = geneticMapIndex;
    }

    private synchronized void cacheGeneticMappingInfoGW(int tagIndex) {
        if (tagIndex == this.cachedTagIndex) {
            return;
        }
        int chunkIndex = tagIndex >> 16;
        if (chunkIndex != this.cachedGeneticMappingGWChunkIndex) {
            this.cacheGeneticMappingInfoGWChunk(chunkIndex);
        }
        this.cachedTGMIGW = this.cachedTGMIGWChunk[tagIndex % this.getChunkSize()];
        this.cachedTagIndex = tagIndex;
    }

    public int getChunkNum() {
        int num = this.getTagCount() / this.getChunkSize();
        if (this.getTagCount() % this.getChunkSize() == 0) {
            return num;
        }
        return num + 1;
    }

    public int getChunkSize() {
        return 65536;
    }

    public void getFileReadyForClosing() {
    }

    public int getMappingNum() {
        return this.mappingNum;
    }

    public boolean getIfHasMapping() {
        return this.myHDF5.exists("map" + this.getThreeFigureString(0));
    }

    public boolean getIfHasGeneticMapping() {
        return this.myHDF5.exists("gm" + this.getThreeFigureString(0));
    }

    public boolean getIfHasGeneticMappingGW() {
        return this.myHDF5.exists("gmgw" + this.getThreeFigureString(0));
    }

    private synchronized void calMappingIndicesOfAligner(TagMappingInfoV3.Aligner alignerName) {
        int i;
        byte mappingSourceValue = alignerName.getValue();
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (i = 0; i < this.cachedTMIChunk.length; ++i) {
            if (this.cachedTMIChunk[i][0].mappingSource != mappingSourceValue) continue;
            l.add(i);
        }
        this.mappingIndexOfAligner = new int[l.size()];
        for (i = 0; i < this.mappingIndexOfAligner.length; ++i) {
            this.mappingIndexOfAligner[i] = (Integer)l.get(i);
        }
        this.currentAligner = alignerName;
    }

    public synchronized int[] getUniqueMappingOfAligner(int tagIndex, TagMappingInfoV3.Aligner alignerName) {
        if (alignerName != this.currentAligner) {
            this.calMappingIndicesOfAligner(alignerName);
        }
        ArrayList<Integer> l = new ArrayList<Integer>();
        int cnt = 0;
        for (int i = 0; i < this.mappingIndexOfAligner.length; ++i) {
            TagMappingInfoV3 tempTMI = this.getMappingInfo(tagIndex, this.mappingIndexOfAligner[i]);
            if (tempTMI.mappingRank != 0) continue;
            if (tempTMI.chromosome < 0) {
                return null;
            }
            if (++cnt > 1) {
                return null;
            }
            l.add(tempTMI.chromosome);
            l.add(tempTMI.startPosition);
        }
        if (l.isEmpty()) {
            return null;
        }
        int[] chrPos = new int[]{(Integer)l.get(0), (Integer)l.get(1)};
        return chrPos;
    }

    @Override
    public int addVariant(int tagIndex, byte offset, byte base) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getBestMapIndex(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestMapIndex[tagIndex];
    }

    @Override
    public byte getDcoP(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestDcoP[tagIndex];
    }

    @Override
    public byte getStrand(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestStrand[tagIndex];
    }

    @Override
    public byte getDivergence(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestDivergence[tagIndex];
    }

    @Override
    public int getStartPosition(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestStartPos[tagIndex];
    }

    @Override
    public int getEndPosition(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestEndPosition[tagIndex];
    }

    public byte getEvidence(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestEvidence[tagIndex];
    }

    @Override
    public byte getMapP(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.bestMapP[tagIndex];
    }

    @Override
    public byte getMultiMaps(int tagIndex) {
        if (this.bestStrand == null) {
            throw new IllegalStateException("Best mapping not present");
        }
        return this.multimaps[tagIndex];
    }

    public int[] getMappingIndicesOfAligner(TagMappingInfoV3.Aligner alignerName) {
        byte value = alignerName.getValue();
        ArrayList<Integer> list = new ArrayList<Integer>();
        int tagIndex = 0;
        while (list.isEmpty()) {
            for (int i = 0; i < this.getMappingNum(); ++i) {
                byte c = this.cachedTMIChunk[i][tagIndex].mappingSource;
                if (c != value) continue;
                list.add(i);
            }
            ++tagIndex;
        }
        if (list.isEmpty()) {
            return null;
        }
        int[] indices = new int[list.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)list.get(i);
        }
        return indices;
    }

    @Override
    public int[] getPositionArray(int tagIndex) {
        int[] r = new int[]{this.bestChr[tagIndex], this.bestStrand[tagIndex], this.bestStartPos[tagIndex]};
        return r;
    }

    @Override
    public int getReadIndexForPositionIndex(int posIndex) {
        return this.indicesOfSortByPosition[posIndex];
    }

    public TagMappingInfoV3 getMappingInfo(int tagIndex, int mapIndex) {
        this.cacheMappingInfo(tagIndex, mapIndex);
        return this.cachedTMI;
    }

    public TagMappingInfoV3[][] getMappingInfoChunk(int tagIndex) {
        if (this.getMappingNum() == 0) {
            return null;
        }
        this.getMappingInfo(tagIndex, 0);
        return this.cachedTMIChunk;
    }

    public TagGeneticMappingInfo getGeneticMappingInfo(int tagIndex, int geneticMapIndex) {
        this.cacheGeneticMappingInfo(tagIndex, geneticMapIndex);
        return this.cachedTGMI;
    }

    public TagGeneticMappingInfo getGeneticMappingInfoGW(int tagIndex) {
        this.cacheGeneticMappingInfoGW(tagIndex);
        return this.cachedTGMIGW;
    }

    private String getThreeFigureString(int number) {
        String s = String.valueOf(number);
        int length = s.length();
        for (int i = 0; i < 3 - length; ++i) {
            s = "0" + s;
        }
        return s;
    }

    @Override
    public int[] getUniquePositions(int chromosome) {
        if (this.myUniquePositions == null) {
            this.populateChrAndVarPositions();
        }
        return this.myUniquePositions[chromosome];
    }

    public void setMultimaps(int index, byte multimaps) {
        this.multimaps[index] = multimaps;
    }

    @Override
    public void setChromoPosition(int index, int chromosome, byte strand, int positionMin, int positionMax) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDivergence(int index, byte divergence) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMapP(int index, byte mapP) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMapP(int index, double mapP) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void setVariantDef(int tagIndex, int variantIndex, byte def) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantDef", (byte[][])new byte[][]{{def}}, (long)tagIndex, (long)variantIndex);
        this.variantDefs[tagIndex][variantIndex] = def;
    }

    @Override
    public synchronized void setVariantPosOff(int tagIndex, int variantIndex, byte offset) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantPosOff", (byte[][])new byte[][]{{offset}}, (long)tagIndex, (long)variantIndex);
        this.variantOffsets[tagIndex][variantIndex] = offset;
    }

    public synchronized void setAllVariantInfo(int tagIndex, byte[][] defAndOffset) {
        this.myHDF5.writeByteMatrixBlockWithOffset("variantDef", (byte[][])new byte[][]{defAndOffset[0]}, (long)tagIndex, 0L);
        this.myHDF5.writeByteMatrixBlockWithOffset("variantPosOff", (byte[][])new byte[][]{defAndOffset[1]}, (long)tagIndex, 0L);
        this.variantDefs[tagIndex] = defAndOffset[1];
        this.variantOffsets[tagIndex] = defAndOffset[1];
    }

    public long sortTable(boolean byHaplotype) {
        System.out.print("Starting Read Table Sort ...");
        if (!byHaplotype) {
            System.out.print("ERROR:  Position sorting has been eliminated ...");
            return -1L;
        }
        long time = System.currentTimeMillis();
        GenericSorting.quickSort((int)0, (int)this.tags[0].length, (IntComparator)this, (Swapper)this);
        long totalTime = System.currentTimeMillis() - time;
        System.out.println("Done in " + totalTime + "ms");
        this.initPhysicalSort();
        return totalTime;
    }

    @Override
    public void clearVariants() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

