/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.File;
import net.maizegenetics.dna.map.AbstractTagsOnPhysicalMap;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.map.TagsOnPhysMapHDF5;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.util.Utils;

public class TOPMUtils {
    private TOPMUtils() {
    }

    public static TOPMInterface readTOPM(String filename) {
        String temp = filename.trim().toLowerCase();
        if (temp.endsWith(".topm.txt")) {
            return new TagsOnPhysicalMap(filename, false);
        }
        if (temp.endsWith(".topm.bin") || temp.endsWith(".topm")) {
            return new TagsOnPhysicalMap(filename, true);
        }
        if (temp.endsWith(".topm.h5")) {
            return new TagsOnPhysMapHDF5(filename, true);
        }
        throw new IllegalArgumentException("TOPMUtils: readTOPM: Unknown file extension: " + filename);
    }

    public static void writeTOPM(TOPMInterface topm, String filename) {
        filename = Utils.addSuffixIfNeeded(filename, ".topm.h5", new String[]{".topm.bin", ".topm.txt", ".topm.h5"});
        String temp = filename.trim().toLowerCase();
        if (topm instanceof TagsOnPhysicalMap && temp.endsWith(".topm.bin")) {
            ((TagsOnPhysicalMap)topm).writeBinaryFile(new File(filename));
        } else if (topm instanceof TagsOnPhysicalMap && temp.endsWith(".topm.txt")) {
            ((TagsOnPhysicalMap)topm).writeTextFile(new File(filename));
        } else if (topm instanceof AbstractTagsOnPhysicalMap && temp.endsWith(".topm.h5")) {
            TagsOnPhysMapHDF5.createFile((AbstractTagsOnPhysicalMap)topm, filename, 1, topm.getMaxNumVariants());
        }
    }
}

