/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import net.maizegenetics.analysis.numericaltransform.Conversion;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;

public class TransformationPanel
extends JPanel {
    private Datum theDatum;
    private static final String BASE_10 = "Base 10";
    private static final String BASE_2 = "Base 2";
    private static final String E_CONSTANT = "Natural";
    private static final int SCALE = 5;
    private Phenotype aCharacterAlignment;
    private JRadioButton rdoPower = new JRadioButton();
    private JRadioButton rdoLog = new JRadioButton();
    private JCheckBox ckbxStandardize = new JCheckBox("Standardize");
    private JComboBox cbxPower = new JComboBox();
    private JComboBox cbxLog = new JComboBox();
    private LinkedHashMap powerMap = new LinkedHashMap();
    private String[] dataLog = new String[]{"Base 10", "Base 2", "Natural"};
    private boolean rdoPowerSelected = true;
    private int[] colSelected;
    private double[][] transformedColumnData;
    private StringBuffer procedure;
    private StringBuffer procedureReport;
    private Frame myParentFrame = null;

    public TransformationPanel(Datum theDatum, Frame parentFrame) {
        this.myParentFrame = parentFrame;
        try {
            if (!(theDatum.getData() instanceof Phenotype)) {
                throw new Exception("Must be Character Alignment");
            }
            this.theDatum = theDatum;
            this.aCharacterAlignment = (Phenotype)theDatum.getData();
            this.powerMap.put("2", new Double(2.0));
            this.powerMap.put("3", new Double(3.0));
            this.powerMap.put("4", new Double(4.0));
            this.powerMap.put("10", new Double(10.0));
            this.powerMap.put("1/2", new Double(0.5));
            this.powerMap.put("1/3", new Double(0.3333333333333333));
            this.powerMap.put("1/4", new Double(0.25));
            this.powerMap.put("1/10", new Double(0.1));
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel fillerPanel = new JPanel();
        this.setLayout(new BorderLayout());
        JPanel optPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        JPanel jpow = new JPanel(new BorderLayout());
        this.rdoPower.setText("Raise to Power");
        this.cbxPower = new JComboBox<Object>(this.powerMap.keySet().toArray());
        jpow.add((Component)this.rdoPower, "West");
        jpow.add((Component)this.cbxPower, "Center");
        optPanel.add(jpow);
        JPanel jlog = new JPanel(new BorderLayout());
        this.rdoLog.setText("Take Log");
        this.rdoLog.setSelected(!this.rdoPowerSelected);
        this.cbxLog = new JComboBox<String>(this.dataLog);
        jlog.add((Component)this.rdoLog, "West");
        jlog.add((Component)this.cbxLog, "Center");
        optPanel.add(jlog);
        optPanel.add(this.ckbxStandardize);
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this.rdoPower);
        rbg.add(this.rdoLog);
        this.add((Component)optPanel, "North");
        this.add((Component)fillerPanel, "Center");
    }

    public Datum createNormalizedData(JTable tblNormalityTraits) {
        this.colSelected = tblNormalityTraits.getSelectedRows();
        double[][] tempData = null;
        if (this.colSelected == null || this.colSelected.length == 0) {
            JOptionPane.showMessageDialog(this.myParentFrame, "Please select a column to test.");
        } else {
            tempData = Conversion.parseColumnData(this.aCharacterAlignment, this.colSelected);
        }
        if (tempData == null) {
            JOptionPane.showMessageDialog(this.myParentFrame, "There is no numeric data in the selected column.");
            return null;
        }
        this.procedure = new StringBuffer("(");
        this.procedureReport = new StringBuffer("\nProcedure(s) applied:");
        if (this.rdoPower.isSelected()) {
            double powerValue = 1.0;
            String power = (String)this.cbxPower.getSelectedItem();
            try {
                powerValue = (Double)this.powerMap.get(power);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
            for (int i = 0; i < tempData.length; ++i) {
                for (int j = 0; j < tempData[i].length; ++j) {
                    if (Double.isNaN(tempData[i][j])) continue;
                    BigDecimal bd = new BigDecimal(Math.pow(tempData[i][j], powerValue));
                    bd = bd.setScale(5, RoundingMode.HALF_UP);
                    tempData[i][j] = bd.doubleValue();
                }
            }
            this.procedure.append(" power: " + powerValue);
            this.procedureReport.append("\n\tPower: " + powerValue);
        } else if (this.rdoLog.isSelected()) {
            for (int i = 0; i < tempData.length; ++i) {
                for (int j = 0; j < tempData[j].length; ++j) {
                    BigDecimal bd;
                    if (tempData[i][j] <= 1.0E-6) {
                        tempData[i][j] = Double.NaN;
                    }
                    if (Double.isNaN(tempData[i][j])) continue;
                    if ((String)this.cbxLog.getSelectedItem() == E_CONSTANT) {
                        bd = new BigDecimal(Math.log(tempData[i][j]));
                        bd = bd.setScale(5, RoundingMode.HALF_UP);
                        tempData[i][j] = bd.doubleValue();
                        continue;
                    }
                    if ((String)this.cbxLog.getSelectedItem() == BASE_2) {
                        bd = new BigDecimal(Math.log(tempData[i][j]) / Math.log(2.0));
                        bd = bd.setScale(5, RoundingMode.HALF_UP);
                        tempData[i][j] = bd.doubleValue();
                        continue;
                    }
                    if ((String)this.cbxLog.getSelectedItem() != BASE_10) continue;
                    bd = new BigDecimal(Math.log(tempData[i][j]) / Math.log(10.0));
                    bd = bd.setScale(5, RoundingMode.HALF_UP);
                    tempData[i][j] = bd.doubleValue();
                }
            }
            this.procedure.append(" log " + (String)this.cbxLog.getSelectedItem());
            this.procedureReport.append("\n\tLog " + (String)this.cbxLog.getSelectedItem());
        }
        if (this.ckbxStandardize.isSelected()) {
            tempData = Conversion.normalizeData(tempData);
            this.procedure.append(" normalized");
            this.procedureReport.append("\n\tNormalization");
        }
        this.transformedColumnData = tempData;
        if (this.procedure.toString().equals("(")) {
            JOptionPane.showMessageDialog(this.myParentFrame, "Please select a transformation to do.");
            return null;
        }
        SimplePhenotype sca = Conversion.reconstituteDataset(this.aCharacterAlignment, this.colSelected, this.transformedColumnData);
        StringWriter sw = new StringWriter();
        String theComment = sw.toString() + "Converted Column:\n" + this.procedureReport.toString();
        String theName = this.theDatum.getName() + ": " + this.colSelected.length + " col(s) " + this.procedure.append(")").toString();
        Datum result = new Datum(theName, sca, theComment);
        return result;
    }
}

