/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.math.BigDecimal;
import java.util.ArrayList;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;

public class Conversion {
    public static double[] parseColumnData(Phenotype tableReport, int colSelected) {
        double[][] rawData = tableReport.getData();
        double[] tempData = new double[rawData.length];
        int naNCount = 0;
        for (int i = 0; i < rawData.length; ++i) {
            tempData[i] = rawData[i][colSelected];
            if (!Double.isNaN(tempData[i])) continue;
            ++naNCount;
        }
        if (naNCount == rawData.length) {
            return null;
        }
        return tempData;
    }

    public static double[][] parseColumnData(Phenotype theCharacterAlignment, int[] selectedCol) {
        int i;
        int[] includedColumn;
        if (selectedCol == null) {
            int colCount = theCharacterAlignment.getNumberOfTraits();
            includedColumn = new int[colCount];
            for (i = 0; i < colCount; ++i) {
                includedColumn[i] = i;
            }
        } else {
            includedColumn = selectedCol;
        }
        double[][] tempData = new double[theCharacterAlignment.getNumberOfTaxa()][includedColumn.length];
        for (i = 0; i < theCharacterAlignment.getNumberOfTaxa(); ++i) {
            for (int j = 0; j < includedColumn.length; ++j) {
                tempData[i][j] = theCharacterAlignment.getData(i, includedColumn[j]);
            }
        }
        return tempData;
    }

    public static SimplePhenotype reconstituteDataset(Phenotype originalSca, int[] colSelected, double[][] changedData) {
        ArrayList<Trait> newtraits = new ArrayList<Trait>();
        for (int col : colSelected) {
            newtraits.add(Trait.getInstance(originalSca.getTrait(col)));
        }
        return new SimplePhenotype(originalSca.getTaxa(), newtraits, changedData);
    }

    public static double[] removeNaNValues(double[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        double[] cleanData = new double[data.length];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            cleanData[count++] = data[i];
        }
        double[] tempData = new double[count];
        System.arraycopy(cleanData, 0, tempData, 0, count);
        return tempData;
    }

    public static double[][] removeNaNValues(double[][] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        double[][] cleanData = new double[data.length][];
        boolean count = false;
        for (int i = 0; i < data.length; ++i) {
            cleanData[i] = Conversion.removeNaNValues(data[i]);
        }
        return cleanData;
    }

    public static Object[] getPercentMissingData(Phenotype tableReportIn, int precision) {
        double[][] rawData = tableReportIn.getData();
        double[] tempData = new double[rawData.length];
        int colCount = rawData[0].length;
        int rowCount = rawData.length;
        BigDecimal hundred = new BigDecimal("100");
        Object[] percentData = new BigDecimal[colCount];
        for (int j = 0; j < colCount; ++j) {
            int naNCount = 0;
            for (int i = 0; i < rowCount; ++i) {
                tempData[i] = Double.valueOf(String.valueOf(rawData[i][j]));
                if (!Double.isNaN(tempData[i])) continue;
                ++naNCount;
            }
            BigDecimal bd = new BigDecimal((double)naNCount / (double)rowCount);
            BigDecimal percentage = bd.multiply(hundred);
            percentData[j] = percentage.setScale(precision, 4);
        }
        return percentData;
    }

    public static double[] normalizeData(double[] dataIn) {
        double[] data = new double[dataIn.length + 1];
        System.arraycopy(dataIn, 0, data, 1, dataIn.length);
        double avg = 0.0;
        double cumulativeValue = 0.0;
        int n = 0;
        for (int i = 1; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            cumulativeValue += data[i];
            ++n;
        }
        avg = cumulativeValue / (double)n;
        double stDev = Conversion.calculateStandardDeviation(dataIn);
        double[] result = new double[dataIn.length];
        for (int i = 0; i < dataIn.length; ++i) {
            result[i] = !Double.isNaN(dataIn[i]) ? (dataIn[i] - avg) / stDev : Double.NaN;
        }
        return result;
    }

    public static double[][] normalizeData(double[][] dataIn) {
        double[][] result = new double[dataIn.length][dataIn[0].length];
        int colCount = dataIn[0].length;
        for (int j = 0; j < colCount; ++j) {
            double[] colData = new double[dataIn.length];
            for (int row = 0; row < dataIn.length; ++row) {
                colData[row] = dataIn[row][j];
            }
            double[] normalizedData = Conversion.normalizeData(colData);
            for (int q = 0; q < dataIn.length; ++q) {
                result[q][j] = !Double.isNaN(dataIn[q][j]) ? normalizedData[q] : Double.NaN;
            }
        }
        return result;
    }

    public static double calculateMean(double[] data) {
        if (data.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            sum += data[i];
        }
        return sum / (double)data.length;
    }

    public static double calculateVariance(double[] dataIn) {
        double[] data = new double[dataIn.length + 1];
        System.arraycopy(dataIn, 0, data, 1, dataIn.length);
        int n = 0;
        double sum = 0.0;
        double sumSqr = 0.0;
        for (int i = 1; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            ++n;
            sum += data[i];
            sumSqr += data[i] * data[i];
        }
        return (sumSqr - sum * sum / (double)n) / (double)(n - 1);
    }

    public static double calculateStandardDeviation(double[] data) {
        return Math.sqrt(Conversion.calculateVariance(data));
    }
}

