/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.FILLINDonorGenotypeUtils;
import net.maizegenetics.analysis.imputation.FILLINImputationUtils;
import net.maizegenetics.analysis.imputation.ImputedTaxon;
import net.maizegenetics.analysis.imputation.TransitionProbability;
import net.maizegenetics.analysis.imputation.ViterbiAlgorithm;
import net.maizegenetics.analysis.popgen.DonorHypoth;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.ProjectionBuilder;
import net.maizegenetics.dna.snp.io.ProjectionGenotypeIO;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class FILLINImputationPlugin
extends AbstractPlugin {
    private String hmpFile;
    private String donorFile;
    private String outFileBase;
    private boolean hybridNN = true;
    private int minMinorCnt = 20;
    private int minMajorRatioToMinorCnt = 10;
    private int maxDonorHypotheses = 20;
    private boolean isOutputProjection = false;
    private double maximumInbredError = 0.01;
    private double maxHybridErrorRate = 0.003;
    private int minTestSites = 100;
    private boolean twoWayViterbi = true;
    private double minimumDonorDistance = this.maximumInbredError * 5.0;
    private double maxNonMedelian = this.maximumInbredError * 5.0;
    private int appoxSitesPerDonorGenotypeTable = 8000;
    private double maxHybridErrFocusHomo = 0.3333 * this.maxHybridErrorRate;
    private double maxInbredErrFocusHomo = 0.3 * this.maximumInbredError;
    private double maxSmashErrFocusHomo = this.maximumInbredError;
    private double maxInbredErrFocusHet = 0.1 * this.maximumInbredError;
    private double maxSmashErrFocusHet = this.maximumInbredError;
    private double hetThresh = 0.02;
    public static GenotypeTable unimpAlign;
    private int testing = 0;
    private boolean isSwapMajorMinor = true;
    private boolean resolveHetIfUndercalled = false;
    private boolean verboseOutput = true;
    double[][] transition = new double[][]{{0.999, 1.0E-4, 3.0E-4, 1.0E-4, 5.0E-4}, {2.0E-4, 0.999, 5.0E-5, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 0.999, 5.0E-5, 2.0E-4}, {2.0E-4, 5.0E-5, 5.0E-5, 0.999, 2.0E-4}, {5.0E-4, 1.0E-4, 3.0E-4, 1.0E-4, 0.999}};
    double[][] emission = new double[][]{{0.998, 0.001, 0.001}, {0.6, 0.2, 0.2}, {0.4, 0.2, 0.4}, {0.2, 0.2, 0.6}, {0.001, 0.001, 0.998}};
    private static ArgsEngine engine;
    private static final Logger myLogger;

    public FILLINImputationPlugin() {
        super(null, false);
    }

    public FILLINImputationPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public void runFILLINImputation(String donorFile, String unImpTargetFile, String exportFile, int minMinorCnt, int minTestSites, int minSitesPresent, double maxHybridErrorRate, boolean isOutputProjection, boolean imputeDonorFile) {
        long time = System.currentTimeMillis();
        this.minTestSites = minTestSites;
        this.isOutputProjection = isOutputProjection;
        unimpAlign = ImportUtils.readGuessFormat(unImpTargetFile);
        GenotypeTable[] donorAlign = FILLINDonorGenotypeUtils.loadDonors(donorFile, unimpAlign, minTestSites, this.verboseOutput, this.appoxSitesPerDonorGenotypeTable);
        OpenBitSet[][] conflictMasks = FILLINDonorGenotypeUtils.createMaskForAlignmentConflicts(unimpAlign, donorAlign, this.verboseOutput);
        System.out.printf("Unimputed taxa:%d sites:%d %n", unimpAlign.numberOfTaxa(), unimpAlign.numberOfSites());
        System.out.println("Creating Export GenotypeTable:" + exportFile);
        Object mna = isOutputProjection ? new ProjectionBuilder(ImportUtils.readGuessFormat(donorFile)) : (exportFile.contains("hmp.h5") ? GenotypeTableBuilder.getTaxaIncremental(unimpAlign.positions(), exportFile) : GenotypeTableBuilder.getTaxaIncremental(unimpAlign.positions()));
        int numThreads = Runtime.getRuntime().availableProcessors();
        System.out.println("Time to read in files and generate masks: " + (System.currentTimeMillis() - time) / 1000L + " sec");
        ExecutorService pool = Executors.newFixedThreadPool(numThreads);
        for (int taxon = 0; taxon < unimpAlign.numberOfTaxa(); ++taxon) {
            int[] trackBlockNN = new int[5];
            ImputeOneTaxon theTaxon = (double)unimpAlign.heterozygousCountForTaxon(taxon) / (double)unimpAlign.totalNonMissingForTaxon(taxon) < this.hetThresh ? new ImputeOneTaxon(taxon, donorAlign, minSitesPresent, conflictMasks, imputeDonorFile, mna, trackBlockNN, this.maxInbredErrFocusHomo, this.maxHybridErrFocusHomo, this.maxSmashErrFocusHomo, true) : new ImputeOneTaxon(taxon, donorAlign, minSitesPresent, conflictMasks, imputeDonorFile, mna, trackBlockNN, this.maxInbredErrFocusHet, 0.0, this.maxSmashErrFocusHet, false);
            pool.execute(theTaxon);
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(48L, TimeUnit.HOURS)) {
                System.out.println("processing threads timed out.");
            }
        }
        catch (Exception e) {
            System.out.println("Error processing threads");
        }
        System.out.println("");
        StringBuilder s = new StringBuilder();
        s.append(String.format("%s %s MinMinor:%d ", donorFile, unImpTargetFile, minMinorCnt));
        System.out.println(s.toString());
        double runtime = (double)(System.currentTimeMillis() - time) / 1000.0;
        if (isOutputProjection) {
            ProjectionGenotypeIO.writeToFile(exportFile, ((ProjectionBuilder)mna).build());
        } else {
            GenotypeTableBuilder ab = (GenotypeTableBuilder)mna;
            if (ab.isHDF5()) {
                ab.build();
            } else {
                ExportUtils.writeToHapmap(ab.build(), false, exportFile, '\t', null);
            }
        }
        System.out.printf("%d %g %d %n", minMinorCnt, this.maximumInbredError, this.maxDonorHypotheses);
        System.out.println("Time to read in files, impute target genotypes, and calculate accuracy: " + runtime + " seconds");
    }

    private ImputedTaxon solveEntireDonorRegion(int taxon, GenotypeTable donorAlign, int donorOffset, DonorHypoth[][] regionHypoth, ImputedTaxon impT, BitSet[] maskedTargetBits, double maxHybridErrorRate, byte[][][] targetToDonorDistances) {
        int blocks = maskedTargetBits[0].getNumWords();
        if (this.testing == 1) {
            System.out.println("Starting complete hybrid search");
        }
        int[] d = FILLINImputationUtils.bestDonorsAcrossEntireRegion(targetToDonorDistances, this.minTestSites, this.maxDonorHypotheses);
        int[] testList = FILLINImputationUtils.fillInc(0, donorAlign.numberOfTaxa() - 1);
        int[] bestDonorList = Arrays.copyOfRange(d, 0, Math.min(d.length, 5));
        DonorHypoth[] bestDBasedOnBest = FILLINImputationUtils.findHeterozygousDonorHypoth(taxon, maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), 0, blocks - 1, blocks / 2, donorAlign, bestDonorList, testList, this.maxDonorHypotheses, this.minTestSites);
        DonorHypoth[] best2Dsearchdonors = FILLINImputationUtils.findHeterozygousDonorHypoth(taxon, maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), 0, blocks - 1, blocks / 2, donorAlign, d, d, this.maxDonorHypotheses, this.minTestSites);
        Object[] best2donors = FILLINImputationUtils.combineDonorHypothArrays(this.maxDonorHypotheses, bestDBasedOnBest, best2Dsearchdonors);
        if (this.testing == 1) {
            System.out.println(Arrays.toString(best2donors));
        }
        ArrayList<Object> goodDH = new ArrayList<Object>();
        for (Object dh : best2donors) {
            if (dh == null) continue;
            if (((DonorHypoth)dh).isInbred() && ((DonorHypoth)dh).getErrorRate() < this.maximumInbredError) {
                goodDH.add(dh);
                continue;
            }
            if (!(((DonorHypoth)dh).getErrorRate() < maxHybridErrorRate) || (dh = this.getStateBasedOnViterbi((DonorHypoth)dh, donorOffset, donorAlign, this.twoWayViterbi, this.transition)) == null) continue;
            goodDH.add(dh);
        }
        if (goodDH.isEmpty()) {
            return impT;
        }
        DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
        for (int i = 0; i < vdh.length; ++i) {
            vdh[i] = (DonorHypoth)goodDH.get(i);
        }
        impT.setSegmentSolved(true);
        return this.setAlignmentWithDonors(donorAlign, vdh, donorOffset, false, impT, false, false);
    }

    private ImputedTaxon solveByBlockNearestNeighbor(ImputedTaxon impT, int targetTaxon, GenotypeTable donorAlign, int donorOffset, DonorHypoth[][] regionHypth, boolean hybridMode, BitSet[] maskedTargetBits, int minMinorCnt, double focusInbredErr, double focusHybridErr, double focusSmashErr, int[] donorIndices, int[] blockNN, boolean hetsToMiss) {
        int[] currBlocksSolved = new int[5];
        int blocks = maskedTargetBits[0].getNumWords();
        for (int focusBlock = 0; focusBlock < blocks; ++focusBlock) {
            boolean vit = false;
            int[] d = this.getUniqueDonorsForBlock(regionHypth, focusBlock);
            int[] resultRange = FILLINImputationUtils.getBlockWithMinMinorCount(maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), focusBlock, minMinorCnt, minMinorCnt * this.minMajorRatioToMinorCnt);
            if (resultRange == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            if (d == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            DonorHypoth[] best2donors = FILLINImputationUtils.findHeterozygousDonorHypoth(targetTaxon, maskedTargetBits[0].getBits(resultRange[0], resultRange[2]), maskedTargetBits[1].getBits(resultRange[0], resultRange[2]), resultRange[0], resultRange[2], focusBlock, donorAlign, d, d, this.maxDonorHypotheses, this.minTestSites);
            if (best2donors[0] == null) {
                currBlocksSolved[3] = currBlocksSolved[3] + 1;
                continue;
            }
            ArrayList<DonorHypoth> goodDH = new ArrayList<DonorHypoth>();
            if (best2donors[0].getErrorRate() < focusInbredErr) {
                for (DonorHypoth dh : best2donors) {
                    if (dh == null) continue;
                    if (!dh.isInbred() && dh.getErrorRate() < focusHybridErr && (dh = this.getStateBasedOnViterbi(dh, donorOffset, donorAlign, this.twoWayViterbi, this.transition)) != null) {
                        vit = true;
                    }
                    if (dh == null || !(dh.getErrorRate() < focusInbredErr)) continue;
                    goodDH.add(dh);
                }
                if (goodDH.size() == 0) continue;
                DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
                for (int i = 0; i < vdh.length; ++i) {
                    vdh[i] = (DonorHypoth)goodDH.get(i);
                }
                regionHypth[focusBlock] = vdh;
                impT = this.setAlignmentWithDonors(donorAlign, regionHypth[focusBlock], donorOffset, true, impT, false, false);
                impT.incBlocksSolved();
                if (vit) {
                    currBlocksSolved[1] = currBlocksSolved[1] + 1;
                } else {
                    currBlocksSolved[0] = currBlocksSolved[0] + 1;
                }
                currBlocksSolved[4] = currBlocksSolved[4] + 1;
                continue;
            }
            if (hybridMode && best2donors[0].getErrorRate() < focusSmashErr) {
                for (DonorHypoth dh : best2donors) {
                    if (dh != null && dh.getErrorRate() < focusSmashErr) {
                        goodDH.add(dh);
                    }
                    if (goodDH.size() == 0) continue;
                    DonorHypoth[] vdh = new DonorHypoth[goodDH.size()];
                    for (int i = 0; i < vdh.length; ++i) {
                        vdh[i] = (DonorHypoth)goodDH.get(i);
                    }
                    regionHypth[focusBlock] = vdh;
                    impT = this.setAlignmentWithDonors(donorAlign, regionHypth[focusBlock], donorOffset, true, impT, true, hetsToMiss);
                    impT.incBlocksSolved();
                    currBlocksSolved[2] = currBlocksSolved[2] + 1;
                    currBlocksSolved[4] = currBlocksSolved[4] + 1;
                }
                continue;
            }
            currBlocksSolved[3] = currBlocksSolved[3] + 1;
        }
        if (currBlocksSolved[4] != 0) {
            impT.setSegmentSolved(true);
        } else {
            impT.setSegmentSolved(false);
        }
        int leftNullCnt = currBlocksSolved[3];
        if (this.testing == 1) {
            System.out.printf("targetTaxon:%d hybridError:%g block:%d proportionBlocksImputed:%d null:%d inbredDone:%d viterbiDone:%d hybridDone:%d noData:%d %n", targetTaxon, focusHybridErr, blocks, currBlocksSolved[4] / blocks, leftNullCnt, currBlocksSolved[0], currBlocksSolved[1], currBlocksSolved[2], currBlocksSolved[3]);
        }
        for (int i = 0; i < currBlocksSolved.length; ++i) {
            int n = i;
            blockNN[n] = blockNN[n] + currBlocksSolved[i];
        }
        return impT;
    }

    private DonorHypoth getStateBasedOnViterbi(DonorHypoth dh, int donorOffset, GenotypeTable donorAlign, boolean forwardReverse, double[][] trans) {
        int endSite = dh.endSite >= donorAlign.numberOfSites() ? donorAlign.numberOfSites() - 1 : dh.endSite;
        int sites = endSite - dh.startSite + 1;
        StatePositionChain informative = this.createInformativeStateChainForViterbi(dh.startSite, this.maxNonMedelian, this.minimumDonorDistance, unimpAlign.genotypeRange(dh.targetTaxon, dh.startSite + donorOffset, endSite + 1 + donorOffset), donorAlign.genotypeRange(dh.donor1Taxon, dh.startSite, endSite + 1), donorAlign.genotypeRange(dh.donor2Taxon, dh.startSite, endSite + 1));
        if (informative == null) {
            return null;
        }
        int chrlength = donorAlign.chromosomalPosition(endSite) - donorAlign.chromosomalPosition(dh.startSite);
        byte[] callsF = this.callsFromViterbi(trans, chrlength / sites, informative);
        DonorHypoth dh2 = new DonorHypoth(dh.targetTaxon, dh.donor1Taxon, dh.donor2Taxon, dh.startBlock, dh.focusBlock, dh.endBlock);
        dh2.phasedResults = callsF;
        if (forwardReverse) {
            byte[] callsR = this.callsFromViterbi(trans, chrlength / sites, StatePositionChain.reverseInstance(informative));
            ArrayUtils.reverse((byte[])callsR);
            byte[] callsC = new byte[callsF.length];
            System.arraycopy(callsR, 0, callsC, 0, callsC.length / 2);
            System.arraycopy(callsF, callsC.length / 2, callsC, callsC.length / 2, callsC.length - callsC.length / 2);
            dh2.phasedResults = callsC;
        }
        return dh2;
    }

    private byte[] callsFromViterbi(double[][] trans, int avgChrLength, StatePositionChain informative) {
        TransitionProbability tpF = new TransitionProbability();
        EmissionProbability ep = new EmissionProbability();
        tpF.setTransitionProbability(trans);
        ep.setEmissionProbability(this.emission);
        double probHeterozygous = 0.5;
        double phom = 0.25;
        double[] pTrue = new double[]{0.25, 0.125, 0.25, 0.125, 0.25};
        tpF.setAverageSegmentLength(avgChrLength);
        tpF.setPositions(informative.informSites);
        ViterbiAlgorithm vaF = new ViterbiAlgorithm(informative.informStates, tpF, ep, pTrue);
        vaF.calculate();
        byte[] resultStatesF = vaF.getMostProbableStateSequence();
        int currPos = 0;
        byte[] callsF = new byte[informative.totalSiteCnt];
        for (int cs = 0; cs < informative.totalSiteCnt; ++cs) {
            byte by = callsF[cs] = resultStatesF[currPos] == 1 ? (byte)1 : (byte)(resultStatesF[currPos] / 2);
            if (informative.informSites[currPos] >= cs + informative.startSite || currPos >= resultStatesF.length - 1) continue;
            ++currPos;
        }
        return callsF;
    }

    private StatePositionChain createInformativeStateChainForViterbi(int startSite, double maxNonMendelian, double minDonorDistance, byte[] targetGenotype, byte[] donor1Genotype, byte[] donor2Genotype) {
        int nonMendel = 0;
        int donorDifferences = 0;
        ArrayList<Byte> nonMissingObs = new ArrayList<Byte>();
        ArrayList<Integer> informSites = new ArrayList<Integer>();
        for (int cs = 0; cs < targetGenotype.length; ++cs) {
            if (targetGenotype[cs] == -1 || donor1Genotype[cs] == -1 || donor2Genotype[cs] == -1 || targetGenotype[cs] == 85 || donor1Genotype[cs] == 85 || donor2Genotype[cs] == 85 || GenotypeTableUtils.isHeterozygous(donor1Genotype[cs]) || GenotypeTableUtils.isHeterozygous(donor2Genotype[cs])) continue;
            if (donor1Genotype[cs] == donor2Genotype[cs]) {
                if (targetGenotype[cs] == donor1Genotype[cs]) continue;
                ++nonMendel;
                continue;
            }
            ++donorDifferences;
            int state = 1;
            if (targetGenotype[cs] == donor1Genotype[cs]) {
                state = 0;
            } else if (targetGenotype[cs] == donor2Genotype[cs]) {
                state = 2;
            }
            nonMissingObs.add((byte)state);
            informSites.add(cs + startSite);
        }
        if (informSites.size() < 10) {
            return null;
        }
        if ((double)nonMendel / (double)informSites.size() > maxNonMendelian) {
            return null;
        }
        if ((double)donorDifferences / (double)informSites.size() < minDonorDistance) {
            return null;
        }
        return new StatePositionChain(startSite, targetGenotype.length, Bytes.toArray(nonMissingObs), Ints.toArray(informSites));
    }

    private int[] getUniqueDonorsForBlock(DonorHypoth[][] regionHypth, int block) {
        HashSet<Integer> donors = new HashSet<Integer>();
        for (int h = 0; h < regionHypth[block].length; ++h) {
            if (regionHypth[block][h] == null) continue;
            donors.add(regionHypth[block][h].donor1Taxon);
            donors.add(regionHypth[block][h].donor2Taxon);
        }
        if (donors.isEmpty()) {
            return null;
        }
        return Ints.toArray(donors);
    }

    private ImputedTaxon setAlignmentWithDonors(GenotypeTable donorAlign, DonorHypoth[] theDH, int donorOffset, boolean setJustFocus, ImputedTaxon impT, boolean smashOn, boolean hetsMiss) {
        int endSite;
        if (theDH[0].targetTaxon < 0) {
            return impT;
        }
        boolean print = false;
        int startSite = setJustFocus ? theDH[0].getFocusStartSite() : theDH[0].startSite;
        int n = endSite = setJustFocus ? theDH[0].getFocusEndSite() : theDH[0].endSite;
        if (endSite >= donorAlign.numberOfSites()) {
            endSite = donorAlign.numberOfSites() - 1;
        }
        int[] prevDonors = new int[]{-1, -1};
        if (theDH[0].getPhaseForSite(startSite) == 0) {
            prevDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor1Taxon};
        } else if (theDH[0].getPhaseForSite(startSite) == 2) {
            prevDonors = new int[]{theDH[0].donor2Taxon, theDH[0].donor2Taxon};
        } else if (theDH[0].getPhaseForSite(startSite) == 1) {
            prevDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor2Taxon};
        }
        int prevDonorStart = startSite;
        int[] currDonors = prevDonors;
        for (int cs = startSite; cs <= endSite; ++cs) {
            byte donorEst = -1;
            int neighbor = 0;
            for (int i = 0; i < theDH.length && donorEst == -1; ++i) {
                neighbor = (byte)(neighbor + 1);
                if (theDH[i] == null || theDH[i].donor1Taxon < 0 || theDH[i].getErrorRate() > this.maximumInbredError) continue;
                byte bD1 = donorAlign.genotype(theDH[i].donor1Taxon, cs);
                if (theDH[i].getPhaseForSite(cs) == 0) {
                    donorEst = bD1;
                    if (i != 0) continue;
                    currDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor1Taxon};
                    continue;
                }
                byte bD2 = donorAlign.genotype(theDH[i].donor2Taxon, cs);
                if (theDH[i].getPhaseForSite(cs) == 2) {
                    donorEst = bD2;
                    if (i != 0) continue;
                    currDonors = new int[]{theDH[0].donor2Taxon, theDH[0].donor2Taxon};
                    continue;
                }
                donorEst = GenotypeTableUtils.getUnphasedDiploidValueNoHets(bD1, bD2);
                if (i != 0) continue;
                currDonors = new int[]{theDH[0].donor1Taxon, theDH[0].donor2Taxon};
            }
            byte knownBase = impT.getOrigGeno(cs + donorOffset);
            if (!Arrays.equals(prevDonors, currDonors)) {
                DonorHaplotypes dhaps = new DonorHaplotypes(donorAlign.chromosome(prevDonorStart), donorAlign.chromosomalPosition(prevDonorStart), donorAlign.chromosomalPosition(cs), prevDonors[0], prevDonors[1]);
                impT.addBreakPoint(dhaps);
                prevDonors = currDonors;
                prevDonorStart = cs;
            }
            impT.chgHis[cs + donorOffset] = theDH[0].phasedResults == null ? (int)(-neighbor) : neighbor;
            impT.impGeno[cs + donorOffset] = donorEst;
            if (knownBase == -1) {
                if (GenotypeTableUtils.isHeterozygous(donorEst)) {
                    if (smashOn && hetsMiss) {
                        impT.resolveGeno[cs + donorOffset] = knownBase;
                        continue;
                    }
                    impT.resolveGeno[cs + donorOffset] = donorEst;
                    continue;
                }
                impT.resolveGeno[cs + donorOffset] = donorEst;
                continue;
            }
            if (!GenotypeTableUtils.isHeterozygous(donorEst) || !this.resolveHetIfUndercalled || !GenotypeTableUtils.isPartiallyEqual(knownBase, donorEst) || smashOn) continue;
            impT.resolveGeno[cs + donorOffset] = donorEst;
        }
        DonorHaplotypes dhaps = new DonorHaplotypes(donorAlign.chromosome(prevDonorStart), donorAlign.chromosomalPosition(prevDonorStart), donorAlign.chromosomalPosition(endSite), prevDonors[0], prevDonors[1]);
        impT.addBreakPoint(dhaps);
        return impT;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        engine.add("-hmp", "-hmpFile", true);
        engine.add("-o", "--outFile", true);
        engine.add("-d", "--donorH", true);
        engine.add("-maskKeyFile", "--maskKeyFile", true);
        engine.add("-propSitesMask", "--propSitesMask", true);
        engine.add("-mxHet", "--hetThresh", true);
        engine.add("-minMnCnt", "--minMnCnt", true);
        engine.add("-mxInbErr", "--mxInbErr", true);
        engine.add("-mxHybErr", "--mxHybErr", true);
        engine.add("-hybNNOff", "--hybNNOff", true);
        engine.add("-mxDonH", "--mxDonH", true);
        engine.add("-mnTestSite", "--mnTestSite", true);
        engine.add("-projA", "--projAlign", false);
        engine.add("-hapSize", "--hapSize", true);
        engine.add("-runChrMode", "--runChrMode", false);
        engine.add("-nV", "--nonVerbose", false);
        engine.parse(args);
        this.hmpFile = engine.getString("-hmp");
        this.outFileBase = engine.getString("-o");
        this.donorFile = engine.getString("-d");
        if (engine.getBoolean("-mxHet")) {
            this.hetThresh = Double.parseDouble(engine.getString("-mxHet"));
        }
        if (engine.getBoolean("-mxInbErr")) {
            this.maximumInbredError = Double.parseDouble(engine.getString("-mxInbErr"));
        }
        if (engine.getBoolean("-mxHybErr")) {
            this.maxHybridErrorRate = Double.parseDouble(engine.getString("-mxHybErr"));
        }
        if (engine.getBoolean("-mxVitFocusErr")) {
            this.maxHybridErrFocusHomo = Double.parseDouble(engine.getString("-mxVitFocusErr"));
        }
        if (engine.getBoolean("-mxInbFocusErr")) {
            this.maxInbredErrFocusHomo = Double.parseDouble(engine.getString("-mxInbFocusErr"));
        }
        if (engine.getBoolean("-mxComFocusErr")) {
            this.maxSmashErrFocusHomo = Double.parseDouble(engine.getString("-mxComFocusErr"));
        }
        if (engine.getBoolean("-mxInbFocusErrHet")) {
            this.maxInbredErrFocusHet = Double.parseDouble(engine.getString("-mxInbFocusErrHet"));
        }
        if (engine.getBoolean("-mxComFocusErrHet")) {
            this.maxSmashErrFocusHet = Double.parseDouble(engine.getString("-mxComFocusErrHet"));
        }
        if (engine.getBoolean("-minMnCnt")) {
            this.minMinorCnt = Integer.parseInt(engine.getString("-minMnCnt"));
        }
        if (engine.getBoolean("-hybNNOff")) {
            this.hybridNN = false;
        }
        if (engine.getBoolean("-mxDonH")) {
            this.maxDonorHypotheses = Integer.parseInt(engine.getString("-mxDonH"));
        }
        if (engine.getBoolean("-mnTestSite")) {
            this.minTestSites = Integer.parseInt(engine.getString("-mnTestSite"));
        }
        if (engine.getBoolean("-hapSize")) {
            this.appoxSitesPerDonorGenotypeTable = Integer.parseInt(engine.getString("-hapSize"));
        }
        if (engine.getBoolean("-projA")) {
            this.isOutputProjection = true;
        }
        if (engine.getBoolean("-nV")) {
            this.verboseOutput = false;
        }
        this.maxHybridErrFocusHomo = 0.3333 * this.maxHybridErrorRate;
        this.maxInbredErrFocusHomo = 0.3 * this.maximumInbredError;
        this.maxSmashErrFocusHomo = this.maximumInbredError;
        this.maxInbredErrFocusHet = 0.1 * this.maximumInbredError;
        this.maxSmashErrFocusHet = this.maximumInbredError;
        this.minimumDonorDistance = this.maximumInbredError * 5.0;
        this.maxNonMedelian = this.maximumInbredError * 5.0;
    }

    private void printUsage() {
        myLogger.info((Object)("\n\n\nAvailable options for the FILLINImputationPlugin are as follows:\n-hmp   Input HapMap file of target genotypes to impute. Accepts all file types supported by TASSEL5\n-d    Donor haplotype files from output of FILLINFindHaplotypesPlugin. Use .gX in the input filename to denote the substring .gc#s# found in donor files\n-o     Output file; hmp.txt.gz and .hmp.h5 accepted. Required\n-mxHet   Threshold per taxon heterozygosity for treating taxon as heterozygous (no Viterbi, het thresholds). (default:" + this.hetThresh + "\n" + "-minMnCnt    Minimum number of informative minor alleles in the search window (or " + this.minMajorRatioToMinorCnt + "X major)\n" + "-mxInbErr    Maximum error rate for applying one haplotype to entire site window (default:" + this.maximumInbredError + "\n" + "-mxHybErr    Maximum error rate for applying Viterbi with to haplotypes to entire site window (default:" + this.maxHybridErrorRate + "\n" + "-hybNNOff    Whether to model two haplotypes as heterozygotic for focus blocks (default:" + this.hybridNN + ")\n" + "-mxDonH   Maximum number of donor hypotheses to be explored (default: " + this.maxDonorHypotheses + ")\n" + "-mnTestSite   Minimum number of sites to test for IBS between haplotype and target in focus block  (default:" + this.minTestSites + ")\n" + "-projA   Create a projection alignment for high density markers (default off)\n" + "-hapSize    Preferred haplotype block size in sites when a single donor file is used (e.g. phased whole genome) \n"));
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.runFILLINImputation(this.donorFile, this.hmpFile, this.outFileBase, this.minMinorCnt, this.minTestSites, 100, this.maxHybridErrorRate, this.isOutputProjection, false);
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "ImputeByFILLIN";
    }

    @Override
    public String getToolTipText() {
        return "Imputation that relies on a combination of HMM and Nearest Neighbor";
    }

    static {
        engine = new ArgsEngine();
        myLogger = Logger.getLogger(FILLINImputationPlugin.class);
    }

    private static class StatePositionChain {
        final int startSite;
        final int totalSiteCnt;
        final byte[] informStates;
        final int[] informSites;

        private StatePositionChain(int startSite, int totalSiteCnt, byte[] informStates, int[] informSites) {
            this.startSite = startSite;
            this.totalSiteCnt = totalSiteCnt;
            this.informStates = informStates;
            this.informSites = informSites;
        }

        protected static StatePositionChain reverseInstance(StatePositionChain forwardSPC) {
            byte[] informStatesR = Arrays.copyOf(forwardSPC.informStates, forwardSPC.informStates.length);
            ArrayUtils.reverse((byte[])informStatesR);
            int[] informSitesReverse = Arrays.copyOf(forwardSPC.informSites, forwardSPC.informSites.length);
            ArrayUtils.reverse((int[])informSitesReverse);
            return new StatePositionChain(forwardSPC.startSite, forwardSPC.totalSiteCnt, informStatesR, informSitesReverse);
        }
    }

    private class ImputeOneTaxon
    implements Runnable {
        int taxon;
        GenotypeTable[] donorAlign;
        int minSitesPresent;
        OpenBitSet[][] conflictMasks;
        boolean imputeDonorFile;
        GenotypeTableBuilder alignBuilder = null;
        ProjectionBuilder projBuilder = null;
        int[] trackBlockNN;
        double focusInbredErr;
        double focusHybridErr;
        double focusSmashErr;
        boolean hetsMiss;

        public ImputeOneTaxon(int taxon, GenotypeTable[] donorAlign, int minSitesPresent, OpenBitSet[][] conflictMasks, boolean imputeDonorFile, Object mna, int[] trackBlockNN, double focusInbErr, double focusHybridErr, double focusSmashErr, boolean hetsToMissing) {
            this.taxon = taxon;
            this.donorAlign = donorAlign;
            this.minSitesPresent = minSitesPresent;
            this.conflictMasks = conflictMasks;
            this.imputeDonorFile = imputeDonorFile;
            this.trackBlockNN = trackBlockNN;
            this.focusInbredErr = focusInbErr;
            this.focusHybridErr = focusHybridErr;
            this.focusSmashErr = focusSmashErr;
            this.hetsMiss = hetsToMissing;
            if (mna instanceof GenotypeTableBuilder) {
                this.alignBuilder = (GenotypeTableBuilder)mna;
            } else if (mna instanceof ProjectionBuilder) {
                this.projBuilder = (ProjectionBuilder)mna;
            } else {
                throw new IllegalArgumentException("Only Aligmnent or Projection Builders may be used.");
            }
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            String name = unimpAlign.taxaName(this.taxon);
            ImputedTaxon impTaxon = new ImputedTaxon(this.taxon, unimpAlign.genotypeAllSites(this.taxon), FILLINImputationPlugin.this.isOutputProjection);
            boolean het = this.focusHybridErr == 0.0;
            int[] unkHets = FILLINImputationUtils.countUnknownAndHeterozygotes(impTaxon.getOrigGeno());
            sb.append(String.format("Imputing %d:%s AsHet:%b Mj:%d, Mn:%d Unk:%d Hets:%d... ", this.taxon, name, het, unimpAlign.allelePresenceForAllSites(this.taxon, GenotypeTable.WHICH_ALLELE.Major).cardinality(), unimpAlign.allelePresenceForAllSites(this.taxon, GenotypeTable.WHICH_ALLELE.Minor).cardinality(), unkHets[0], unkHets[1]));
            boolean enoughData = unimpAlign.totalNonMissingForTaxon(this.taxon) > this.minSitesPresent;
            int countFullLength = 0;
            int countByFocus = 0;
            for (int da = 0; da < this.donorAlign.length && enoughData; ++da) {
                int i;
                int[] donorIndices;
                int donorOffset = unimpAlign.siteOfPhysicalPosition(this.donorAlign[da].chromosomalPosition(0), this.donorAlign[da].chromosome(0));
                int blocks = this.donorAlign[da].allelePresenceForAllSites(0, GenotypeTable.WHICH_ALLELE.Major).getNumWords();
                BitSet[] maskedTargetBits = FILLINDonorGenotypeUtils.arrangeMajorMinorBtwAlignments(unimpAlign, this.taxon, donorOffset, this.donorAlign[da].numberOfSites(), this.conflictMasks[da][0], this.conflictMasks[da][1], FILLINImputationPlugin.this.isSwapMajorMinor);
                if (this.imputeDonorFile) {
                    donorIndices = new int[this.donorAlign[da].numberOfTaxa() - 1];
                    for (i = 0; i < donorIndices.length; ++i) {
                        donorIndices[i] = i;
                        if (i < this.taxon) continue;
                        int n = i;
                        donorIndices[n] = donorIndices[n] + 1;
                    }
                } else {
                    donorIndices = new int[this.donorAlign[da].numberOfTaxa()];
                    for (i = 0; i < donorIndices.length; ++i) {
                        donorIndices[i] = i;
                    }
                }
                DonorHypoth[][] regionHypthInbred = new DonorHypoth[blocks][FILLINImputationPlugin.this.maxDonorHypotheses];
                byte[][][] targetToDonorDistances = FILLINImputationUtils.calcAllelePresenceCountsBtwTargetAndDonors(maskedTargetBits, this.donorAlign[da]);
                for (int focusBlock = 0; focusBlock < blocks; ++focusBlock) {
                    int[] resultRange = FILLINImputationUtils.getBlockWithMinMinorCount(maskedTargetBits[0].getBits(), maskedTargetBits[1].getBits(), focusBlock, FILLINImputationPlugin.this.minMinorCnt, FILLINImputationPlugin.this.minMinorCnt * FILLINImputationPlugin.this.minMajorRatioToMinorCnt);
                    if (resultRange == null) continue;
                    regionHypthInbred[focusBlock] = FILLINImputationUtils.findHomozygousDonorHypoth(this.taxon, resultRange[0], resultRange[2], focusBlock, donorIndices, targetToDonorDistances, FILLINImputationPlugin.this.minTestSites, FILLINImputationPlugin.this.maxDonorHypotheses);
                }
                impTaxon.setSegmentSolved(false);
                impTaxon = FILLINImputationPlugin.this.solveEntireDonorRegion(this.taxon, this.donorAlign[da], donorOffset, regionHypthInbred, impTaxon, maskedTargetBits, FILLINImputationPlugin.this.maxHybridErrorRate, targetToDonorDistances);
                if (impTaxon.isSegmentSolved()) {
                    ++countFullLength;
                    continue;
                }
                if (!(impTaxon = FILLINImputationPlugin.this.solveByBlockNearestNeighbor(impTaxon, this.taxon, this.donorAlign[da], donorOffset, regionHypthInbred, FILLINImputationPlugin.this.hybridNN, maskedTargetBits, FILLINImputationPlugin.this.minMinorCnt, this.focusInbredErr, this.focusHybridErr, this.focusSmashErr, donorIndices, this.trackBlockNN, this.hetsMiss)).isSegmentSolved()) continue;
                ++countByFocus;
            }
            double totalFocus = (double)this.trackBlockNN[3] + (double)this.trackBlockNN[4];
            sb.append(String.format("InbredOrViterbi:%d FocusBlock:%d PropFocusInbred:%f PropFocusViterbi:%f PropFocusSmash:%f PropFocusMissing:%f BlocksSolved:%d ", countFullLength, countByFocus, (double)this.trackBlockNN[0] / totalFocus, (double)this.trackBlockNN[1] / totalFocus, (double)this.trackBlockNN[2] / totalFocus, (double)this.trackBlockNN[3] / totalFocus, impTaxon.getBlocksSolved()));
            int[] unk = FILLINImputationUtils.countUnknownAndHeterozygotes(impTaxon.resolveGeno);
            sb.append(String.format("Unk:%d PropMissing:%g ", unk[0], (double)unk[0] / (double)impTaxon.getOrigGeno().length));
            sb.append(String.format("Het:%d PropHet:%g ", unk[1], (double)unk[1] / (double)impTaxon.getOrigGeno().length));
            sb.append(" BreakPoints:" + impTaxon.getBreakPoints().size());
            if (!FILLINImputationPlugin.this.isOutputProjection) {
                this.alignBuilder.addTaxon((Taxon)unimpAlign.taxa().get(this.taxon), impTaxon.resolveGeno);
            } else {
                this.projBuilder.addTaxon((Taxon)unimpAlign.taxa().get(this.taxon), impTaxon.getBreakPoints());
            }
            if (FILLINImputationPlugin.this.verboseOutput) {
                System.out.println(sb.toString());
            }
        }
    }
}

