/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.Random;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.FILLINImputationPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class FILLINImputationAccuracyPlugin
extends AbstractPlugin {
    public int[] MAF = null;
    private double[][] all = new double[3][5];
    private double[][][] mafAll = null;
    private String maskKeyFile;
    private String unimpFile;
    private String donorFile;
    private String outFile;
    private double propSitesMask;
    private GenotypeTable maskKey = null;
    private double[] MAFClass = null;
    private boolean verboseOutput = true;
    String[] FILLINargs;
    private static ArgsEngine engine = new ArgsEngine();
    private static final Logger myLogger = Logger.getLogger(FILLINImputationPlugin.class);

    public void initiateAccuracy(String unimpFile, String maskKeyFile, double[] mafClass, double propSitesMask) {
        GenotypeTable unimp = ImportUtils.readGuessFormat(unimpFile);
        System.out.println(unimpFile + " read in with " + unimp.numberOfSites() + " sites and " + unimp.numberOfTaxa() + " taxa");
        if (maskKeyFile != null) {
            if (this.verboseOutput) {
                System.out.println("File already masked. Use input key file for calculating accuracy");
            }
            this.maskKey = ImportUtils.readGuessFormat(maskKeyFile);
            if (!Arrays.equals(this.maskKey.physicalPositions(), unimp.physicalPositions())) {
                this.maskKey = this.filterKey(this.maskKey, unimp);
            }
            if (this.maskKey == null) {
                FILLINImputationPlugin.unimpAlign = this.maskPropSites(unimp, propSitesMask);
            }
        } else {
            FILLINImputationPlugin.unimpAlign = this.maskPropSites(unimp, propSitesMask);
        }
    }

    public void generateMAF(GenotypeTable[] donorAlign, GenotypeTable unimpAlign, double[] mafClass) {
        this.MAF = new int[unimpAlign.numberOfSites()];
        for (GenotypeTable don : donorAlign) {
            for (int site = 0; site < don.numberOfSites(); ++site) {
                int search;
                int unimpSite = unimpAlign.positions().indexOf(don.positions().get(site));
                this.MAF[unimpSite] = unimpSite < 0 ? -1 : ((search = Arrays.binarySearch(mafClass, don.minorAlleleFrequency(site))) < 0 ? Math.abs(search) - 1 : search);
            }
        }
    }

    private GenotypeTable maskFileByDepth(GenotypeTable a, int depthToMask, int maskDenom) {
        if (this.verboseOutput) {
            System.out.println("Masking file using depth\nSite depth to mask: " + depthToMask + "Divisor for physical positions to be masked: " + maskDenom);
        }
        GenotypeCallTableBuilder mask = GenotypeCallTableBuilder.getInstance(a.numberOfTaxa(), a.numberOfSites());
        GenotypeCallTableBuilder key = GenotypeCallTableBuilder.getInstance(a.numberOfTaxa(), a.numberOfSites());
        int cnt = 0;
        for (int taxon = 0; taxon < a.numberOfTaxa(); ++taxon) {
            int taxaCnt = 0;
            mask.setBaseRangeForTaxon(taxon, 0, a.genotypeAllSites(taxon));
            for (int site = 0; site < a.numberOfSites(); ++site) {
                int[] currD;
                if (GenotypeTableUtils.isEqual((byte)-1, a.genotype(taxon, site)) || a.physicalPositions()[site] % maskDenom != 0 || (currD = a.depthForAlleles(taxon, site))[0] + currD[1] != depthToMask || a.isHeterozygous(taxon, site) && (depthToMask <= 3 || currD[0] <= 1 || currD[1] <= 1) && depthToMask >= 4) continue;
                mask.setBase(taxon, site, (byte)-1);
                key.setBase(taxon, site, a.genotype(taxon, site));
                ++taxaCnt;
            }
            if (this.verboseOutput) {
                System.out.println(taxaCnt + " sites masked for " + a.taxaName(taxon));
            }
            cnt += taxaCnt;
        }
        if (this.verboseOutput) {
            System.out.println(cnt + " sites masked at a depth of " + depthToMask + " (site numbers that can be divided by " + maskDenom + ")");
        }
        this.maskKey = GenotypeTableBuilder.getInstance(key.build(), a.positions(), a.taxa());
        return GenotypeTableBuilder.getInstance(mask.build(), a.positions(), a.taxa());
    }

    private GenotypeTable maskPropSites(GenotypeTable a, double propSitesMask) {
        if (this.verboseOutput) {
            System.out.println("Masking file without depth\nMasking " + propSitesMask + " proportion of sites");
        }
        GenotypeCallTableBuilder mask = GenotypeCallTableBuilder.getInstance(a.numberOfTaxa(), a.numberOfSites());
        GenotypeCallTableBuilder key = GenotypeCallTableBuilder.getInstance(a.numberOfTaxa(), a.numberOfSites());
        int presGenos = 0;
        for (int taxon = 0; taxon < a.numberOfTaxa(); ++taxon) {
            presGenos += a.totalNonMissingForTaxon(taxon);
        }
        int expected = (int)(propSitesMask * (double)presGenos);
        int cnt = 0;
        for (int taxon = 0; taxon < a.numberOfTaxa(); ++taxon) {
            int taxaCnt = 0;
            mask.setBaseRangeForTaxon(taxon, 0, a.genotypeAllSites(taxon));
            for (int site = 0; site < a.numberOfSites(); ++site) {
                if (!(Math.random() < propSitesMask) || GenotypeTableUtils.isEqual((byte)-1, a.genotype(taxon, site))) continue;
                mask.setBase(taxon, site, (byte)-1);
                key.setBase(taxon, site, a.genotype(taxon, site));
                ++taxaCnt;
            }
            cnt += taxaCnt;
        }
        if (this.verboseOutput) {
            System.out.println(cnt + " sites masked randomly not based on depth (" + expected + " expected at " + propSitesMask + ")");
        }
        this.maskKey = GenotypeTableBuilder.getInstance(key.build(), a.positions(), a.taxa());
        return GenotypeTableBuilder.getInstance(mask.build(), a.positions(), a.taxa());
    }

    private GenotypeTable filterKey(GenotypeTable maskKey, GenotypeTable unimp) {
        if (this.verboseOutput) {
            System.out.println("Filtering user input key file...\nsites in original Key file: " + maskKey.numberOfSites());
        }
        String[] unimpNames = new String[unimp.numberOfSites()];
        for (int site = 0; site < unimp.numberOfSites(); ++site) {
            unimpNames[site] = unimp.siteName(site);
        }
        ArrayList<String> keepSites = new ArrayList<String>();
        if (!Arrays.equals(unimp.chromosomes(), maskKey.chromosomes())) {
            maskKey = this.matchChromosomes(unimp, maskKey);
        }
        if (maskKey == null) {
            return null;
        }
        for (Chromosome chr : unimp.chromosomes()) {
            int posOnChr;
            int[] startEndUnimp = unimp.firstLastSiteOfChromosome(chr);
            int[] startEndKey = maskKey.firstLastSiteOfChromosome(chr);
            int[] unimpPos = Arrays.copyOfRange(unimp.physicalPositions(), startEndUnimp[0], startEndUnimp[1] + 1);
            int[] keyPos = Arrays.copyOfRange(maskKey.physicalPositions(), startEndKey[0], startEndKey[1] + 1);
            for (posOnChr = 0; posOnChr < unimpPos.length; ++posOnChr) {
                if (Arrays.binarySearch(keyPos, unimpPos[posOnChr]) >= 0) continue;
                return null;
            }
            for (posOnChr = 0; posOnChr < keyPos.length; ++posOnChr) {
                if (Arrays.binarySearch(unimpPos, keyPos[posOnChr]) <= -1) continue;
                keepSites.add(maskKey.siteName(startEndKey[0] + posOnChr));
            }
        }
        FilterGenotypeTable filter = FilterGenotypeTable.getInstance(maskKey, keepSites.toArray(new String[keepSites.size()]));
        GenotypeTable newMask = GenotypeTableBuilder.getGenotypeCopyInstance(filter);
        if (this.verboseOutput) {
            System.out.println("Sites in new mask: " + newMask.numberOfSites());
        }
        return newMask;
    }

    private GenotypeTable matchChromosomes(GenotypeTable unimp, GenotypeTable maskKey) {
        Object[] unimpChr = unimp.chromosomes();
        Object[] keyChr = maskKey.chromosomes();
        ArrayList<Integer> keepSites = new ArrayList<Integer>();
        for (Chromosome chromosome : unimpChr) {
            if (Arrays.binarySearch(keyChr, chromosome) >= 0) continue;
            return null;
        }
        for (Chromosome chromosome : keyChr) {
            if (Arrays.binarySearch(unimpChr, chromosome) <= -1) continue;
            int[] startEnd = maskKey.firstLastSiteOfChromosome(chromosome);
            for (int site = startEnd[0]; site <= startEnd[1]; ++site) {
                keepSites.add(site);
            }
        }
        FilterGenotypeTable filter = FilterGenotypeTable.getInstance(maskKey, ArrayUtils.toPrimitive((Integer[])keepSites.toArray(new Integer[keepSites.size()])));
        GenotypeTable matchChr = GenotypeTableBuilder.getGenotypeCopyInstance(filter);
        return matchChr;
    }

    private double pearsonR2(double[][] all) {
        int size = 0;
        for (int x = 0; x < 3; ++x) {
            size = (int)((double)size + (all[x][4] - all[x][3]));
        }
        double[][] xy = new double[2][size];
        int last = 0;
        for (double x = 0.0; x < 3.0; x += 1.0) {
            for (double y = 0.0; y < 3.0; y += 1.0) {
                int fill = last;
                while ((double)fill < (double)last + all[(int)x][(int)y]) {
                    xy[0][fill] = x;
                    xy[1][fill] = y;
                    ++fill;
                }
                last += (int)all[(int)x][(int)y];
            }
        }
        double meanX = 0.0;
        double meanY = 0.0;
        double varX = 0.0;
        double varY = 0.0;
        double covXY = 0.0;
        double r2 = 0.0;
        for (int i = 0; i < xy[0].length; ++i) {
            meanX += xy[0][i];
            meanY += xy[1][i];
        }
        meanX /= (double)(xy[0].length - 1);
        meanY /= (double)(xy[1].length - 1);
        for (int i = 0; i < xy[0].length; ++i) {
            double currX = xy[0][i] - meanX;
            double currY = xy[1][i] - meanY;
            varX += currX * currX;
            varY += currY * currY;
            covXY += currX * currY;
        }
        r2 = covXY / (Math.sqrt(varX) * Math.sqrt(varY)) * (covXY / (Math.sqrt(varX) * Math.sqrt(varY)));
        if (this.verboseOutput) {
            System.out.println("Unadjusted R2 value for " + size + " comparisons: " + r2);
        }
        return r2;
    }

    private void accuracyOut(double[][] all, double time) {
        block6: {
            DecimalFormat df = new DecimalFormat("0.########");
            double r2 = this.pearsonR2(all);
            try {
                File outputFile = new File(this.outFile.substring(0, this.outFile.indexOf(".hmp")) + "DepthAccuracy.txt");
                DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                outStream.writeBytes("##Taxon\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumMinor\tCorrectMinor\tMinorToHet\tMinorToMajor\tUnimpMinor\tNumHets\tHetToMinor\tCorrectHet\tHetToMajor\tUnimpHet\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimpMajor\tR2\n");
                outStream.writeBytes("##TotalByImputed\t" + (all[0][4] + all[1][4] + all[2][4]) + "\t" + (all[0][4] + all[1][4] + all[2][4] - all[0][3] - all[1][3] - all[2][3]) + "\t" + (all[0][3] + all[1][3] + all[2][3]) / (all[0][4] + all[1][4] + all[2][4]) + "\t" + all[0][4] + "\t" + all[0][0] + "\t" + all[0][1] + "\t" + all[0][2] + "\t" + all[0][3] + "\t" + all[1][4] + "\t" + all[1][0] + "\t" + all[1][1] + "\t" + all[1][2] + "\t" + all[1][3] + "\t" + all[2][4] + "\t" + all[2][0] + "\t" + all[2][1] + "\t" + all[2][2] + "\t" + all[2][3] + "\t" + r2 + "\n");
                outStream.writeBytes("#Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nx\ty\tN\tprop\n0\t0\t" + all[0][0] + "\t" + df.format(all[0][0] / (all[0][0] + all[0][1] + all[0][2])) + "\n" + 0 + "\t" + 0.5 + "\t" + all[0][1] + "\t" + df.format(all[0][1] / (all[0][0] + all[0][1] + all[0][2])) + "\n" + 0 + "\t" + 1 + "\t" + all[0][2] + "\t" + df.format(all[0][2] / (all[0][0] + all[0][1] + all[0][2])) + "\n" + 0.5 + "\t" + 0 + "\t" + all[1][0] + "\t" + df.format(all[1][0] / (all[1][0] + all[1][1] + all[1][2])) + "\n" + 0.5 + "\t" + 0.5 + "\t" + all[1][1] + "\t" + df.format(all[1][1] / (all[1][0] + all[1][1] + all[1][2])) + "\n" + 0.5 + "\t" + 1 + "\t" + all[1][2] + "\t" + df.format(all[1][2] / (all[1][0] + all[1][1] + all[1][2])) + "\n" + 1 + "\t" + 0 + "\t" + all[2][0] + "\t" + df.format(all[2][0] / (all[2][0] + all[2][1] + all[2][2])) + "\n" + 1 + "\t" + 0.5 + "\t" + all[2][1] + "\t" + df.format(all[2][1] / (all[2][0] + all[2][1] + all[2][2])) + "\n" + 1 + "\t" + 1 + "\t" + all[2][2] + "\t" + df.format(all[2][2] / (all[2][0] + all[2][1] + all[2][2])) + "\n");
                outStream.writeBytes("#Proportion unimputed:\n#minor <- " + all[0][3] / all[0][4] + "\n#het<- " + all[1][3] / all[1][4] + "\n#major<- " + all[2][3] / all[2][4] + "\n");
                outStream.writeBytes("#Time to impute and calculate accuracy: " + time + " seconds");
                if (this.verboseOutput) {
                    System.out.println("##Taxon\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumMinor\tCorrectMinor\tMinorToHet\tMinorToMajor\tUnimpMinor\tNumHets\tHetToMinor\tCorrectHet\tHetToMajor\tUnimpHet\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimpMajor\tR2");
                }
                if (this.verboseOutput) {
                    System.out.println("TotalByImputed\t" + (all[0][4] + all[1][4] + all[2][4]) + "\t" + (all[0][4] + all[1][4] + all[2][4] - all[0][3] - all[1][3] - all[2][3]) + "\t" + (all[0][3] + all[1][3] + all[2][3]) / (all[0][4] + all[1][4] + all[2][4]) + "\t" + all[0][4] + "\t" + all[0][0] + "\t" + all[0][1] + "\t" + all[0][2] + "\t" + all[0][3] + "\t" + all[1][4] + "\t" + all[1][0] + "\t" + all[1][1] + "\t" + all[1][2] + "\t" + all[1][3] + "\t" + all[2][4] + "\t" + all[2][0] + "\t" + all[2][1] + "\t" + all[2][2] + "\t" + all[2][3] + "\t" + r2);
                }
                if (this.verboseOutput) {
                    System.out.println("Proportion unimputed:\nminor: " + all[0][3] / all[0][4] + "\nhet: " + all[1][3] / all[1][4] + "\nmajor: " + all[2][3] / all[2][4]);
                }
                if (this.verboseOutput) {
                    System.out.println("#Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nx\ty\tN\tprop\n0\t0\t" + all[0][0] + "\t" + all[0][0] / (all[0][0] + all[0][1] + all[0][2]) + "\n" + 0 + "\t" + 0.5 + "\t" + all[0][1] + "\t" + all[0][1] / (all[0][0] + all[0][1] + all[0][2]) + "\n" + 0 + "\t" + 1 + "\t" + all[0][2] + "\t" + all[0][2] / (all[0][0] + all[0][1] + all[0][2]) + "\n" + 0.5 + "\t" + 0 + "\t" + all[1][0] + "\t" + all[1][0] / (all[1][0] + all[1][1] + all[1][2]) + "\n" + 0.5 + "\t" + 0.5 + "\t" + all[1][1] + "\t" + all[1][1] / (all[1][0] + all[1][1] + all[1][2]) + "\n" + 0.5 + "\t" + 1 + "\t" + all[1][2] + "\t" + all[1][2] / (all[1][0] + all[1][1] + all[1][2]) + "\n" + 1 + "\t" + 0 + "\t" + all[2][0] + "\t" + all[2][0] / (all[2][0] + all[2][1] + all[2][2]) + "\n" + 1 + "\t" + 0.5 + "\t" + all[2][1] + "\t" + all[2][1] / (all[2][0] + all[2][1] + all[2][2]) + "\n" + 1 + "\t" + 1 + "\t" + all[2][2] + "\t" + all[2][2] / (all[2][0] + all[2][1] + all[2][2]) + "\n");
                }
                outStream.close();
            }
            catch (Exception e) {
                if (!this.verboseOutput) break block6;
                System.out.println(e);
            }
        }
    }

    private void accuracyMAFOut(double[][][] mafAll) {
        block6: {
            DecimalFormat df = new DecimalFormat("0.########");
            if (this.MAF != null && this.MAFClass != null) {
                try {
                    int i;
                    File outputFile = new File(this.outFile.substring(0, this.outFile.indexOf(".hmp")) + "DepthAccuracyMAF.txt");
                    DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                    outStream.writeBytes("##\tMAFClass\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumHets\tHetToMinor\tHetToMajor\tCorrectHet\tUnimpHet\tNumMinor\tMinorToMajor\tMinorToHet\tCorrectMinor\tUnimpMinor\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimputedMajor\tr2\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes("##TotalByImputed\t" + this.MAFClass[i] + "\t" + (mafAll[i][0][4] + mafAll[i][1][4] + mafAll[i][2][4]) + "\t" + (mafAll[i][0][4] + mafAll[i][1][4] + mafAll[i][2][4] - mafAll[i][0][3] - mafAll[i][1][3] - mafAll[i][2][3]) + "\t" + (mafAll[i][0][3] + mafAll[i][1][3] + mafAll[i][2][3]) / (mafAll[i][0][4] + mafAll[i][1][4] + mafAll[i][2][4]) + "\t" + mafAll[i][0][4] + "\t" + mafAll[i][0][0] + "\t" + mafAll[i][0][1] + "\t" + mafAll[i][0][2] + "\t" + mafAll[i][0][3] + "\t" + mafAll[i][1][4] + "\t" + mafAll[i][1][0] + "\t" + mafAll[i][1][1] + "\t" + mafAll[i][1][2] + "\t" + mafAll[i][1][3] + "\t" + mafAll[i][2][4] + "\t" + mafAll[i][2][0] + "\t" + mafAll[i][2][1] + "\t" + mafAll[i][2][2] + "\t" + mafAll[i][2][3] + "\t" + this.pearsonR2(mafAll[i]) + "\n");
                    }
                    outStream.writeBytes("#MAFClass,Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nMAF\tx\ty\tN\tprop\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes(this.MAFClass[i] + "\t" + 0 + "\t" + 0 + "\t" + mafAll[i][0][0] + "\t" + df.format(mafAll[i][0][0] / (mafAll[i][0][0] + mafAll[i][0][1] + mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0 + "\t" + 0.5 + "\t" + mafAll[i][0][1] + "\t" + df.format(mafAll[i][0][1] / (mafAll[i][0][0] + mafAll[i][0][1] + mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0 + "\t" + 1 + "\t" + mafAll[i][0][2] + "\t" + df.format(mafAll[i][0][2] / (mafAll[i][0][0] + mafAll[i][0][1] + mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 0 + "\t" + mafAll[i][1][0] + "\t" + df.format(mafAll[i][1][0] / (mafAll[i][1][0] + mafAll[i][1][1] + mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 0.5 + "\t" + mafAll[i][1][1] + "\t" + df.format(mafAll[i][1][1] / (mafAll[i][1][0] + mafAll[i][1][1] + mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 1 + "\t" + mafAll[i][1][2] + "\t" + df.format(mafAll[i][1][2] / (mafAll[i][1][0] + mafAll[i][1][1] + mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 0 + "\t" + mafAll[i][2][0] + "\t" + df.format(mafAll[i][2][0] / (mafAll[i][2][0] + mafAll[i][2][1] + mafAll[i][2][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 0.5 + "\t" + mafAll[i][2][1] + "\t" + df.format(mafAll[i][2][1] / (mafAll[i][2][0] + mafAll[i][2][1] + mafAll[i][2][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 1 + "\t" + mafAll[i][2][2] + "\t" + df.format(mafAll[i][2][2] / (mafAll[i][2][0] + mafAll[i][2][1] + mafAll[i][2][2])) + "\n");
                    }
                    outStream.writeBytes("#Proportion unimputed:\n#MAF\tminor\thet\tmajor\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes("#" + this.MAFClass[i] + "\t" + mafAll[i][0][3] / mafAll[i][0][4] + "\t" + mafAll[i][1][3] / mafAll[i][1][4] + "\t" + mafAll[i][2][3] / mafAll[i][2][4] + "\n");
                    }
                    outStream.flush();
                    outStream.close();
                }
                catch (Exception e) {
                    if (!this.verboseOutput) break block6;
                    System.out.println(e);
                }
            }
        }
    }

    public void checkForMAF() {
    }

    public void calcAccuracy(GenotypeTable imputed, GenotypeTable unimpAlign, double runtime) {
        byte diploidN = -1;
        boolean use = false;
        boolean mafOn = false;
        int maf = -1;
        this.checkForMAF();
        if (this.mafAll != null) {
            use = true;
            mafOn = true;
        }
        for (int taxon = 0; taxon < imputed.numberOfTaxa(); ++taxon) {
            int keyTaxon = this.maskKey.taxa().indexOf(imputed.taxaName(taxon));
            if (keyTaxon < 0) continue;
            for (int site = 0; site < imputed.numberOfSites(); ++site) {
                byte known;
                boolean bl = use = mafOn && this.MAF[site] > -1;
                if (use) {
                    maf = this.MAF[site];
                }
                if ((known = this.maskKey.genotype(keyTaxon, site)) == diploidN) continue;
                byte imp = imputed.genotype(taxon, site);
                if (GenotypeTableUtils.isHeterozygous(known)) {
                    double[] dArray = this.all[1];
                    dArray[4] = dArray[4] + 1.0;
                    if (use) {
                        double[] dArray2 = this.mafAll[maf][1];
                        dArray2[4] = dArray2[4] + 1.0;
                    }
                    if (imp == diploidN) {
                        double[] dArray3 = this.all[1];
                        dArray3[3] = dArray3[3] + 1.0;
                        if (!use) continue;
                        double[] dArray4 = this.mafAll[maf][1];
                        dArray4[3] = dArray4[3] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isEqual(imp, known)) {
                        double[] dArray5 = this.all[1];
                        dArray5[1] = dArray5[1] + 1.0;
                        if (!use) continue;
                        double[] dArray6 = this.mafAll[maf][1];
                        dArray6[1] = dArray6[1] + 1.0;
                        continue;
                    }
                    if (!GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, unimpAlign.minorAllele(site))) {
                        double[] dArray7 = this.all[1];
                        dArray7[0] = dArray7[0] + 1.0;
                        if (!use) continue;
                        double[] dArray8 = this.mafAll[maf][1];
                        dArray8[0] = dArray8[0] + 1.0;
                        continue;
                    }
                    if (!GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, unimpAlign.majorAllele(site))) {
                        double[] dArray9 = this.all[1];
                        dArray9[2] = dArray9[2] + 1.0;
                        if (!use) continue;
                        double[] dArray10 = this.mafAll[maf][1];
                        dArray10[2] = dArray10[2] + 1.0;
                        continue;
                    }
                    double[] dArray11 = this.all[1];
                    dArray11[4] = dArray11[4] - 1.0;
                    if (!use) continue;
                    double[] dArray12 = this.mafAll[maf][1];
                    dArray12[4] = dArray12[4] - 1.0;
                    continue;
                }
                if (known == GenotypeTableUtils.getDiploidValue(unimpAlign.minorAllele(site), unimpAlign.minorAllele(site))) {
                    double[] dArray = this.all[0];
                    dArray[4] = dArray[4] + 1.0;
                    if (use) {
                        double[] dArray13 = this.mafAll[maf][0];
                        dArray13[4] = dArray13[4] + 1.0;
                    }
                    if (imp == diploidN) {
                        double[] dArray14 = this.all[0];
                        dArray14[3] = dArray14[3] + 1.0;
                        if (!use) continue;
                        double[] dArray15 = this.mafAll[maf][0];
                        dArray15[3] = dArray15[3] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isEqual(imp, known)) {
                        double[] dArray16 = this.all[0];
                        dArray16[0] = dArray16[0] + 1.0;
                        if (!use) continue;
                        double[] dArray17 = this.mafAll[maf][0];
                        dArray17[0] = dArray17[0] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, known)) {
                        double[] dArray18 = this.all[0];
                        dArray18[1] = dArray18[1] + 1.0;
                        if (!use) continue;
                        double[] dArray19 = this.mafAll[maf][0];
                        dArray19[1] = dArray19[1] + 1.0;
                        continue;
                    }
                    double[] dArray20 = this.all[0];
                    dArray20[2] = dArray20[2] + 1.0;
                    if (!use) continue;
                    double[] dArray21 = this.mafAll[maf][0];
                    dArray21[3] = dArray21[3] + 1.0;
                    continue;
                }
                if (known != GenotypeTableUtils.getDiploidValue(unimpAlign.majorAllele(site), unimpAlign.majorAllele(site))) continue;
                double[] dArray = this.all[2];
                dArray[4] = dArray[4] + 1.0;
                if (use) {
                    double[] dArray22 = this.mafAll[maf][2];
                    dArray22[4] = dArray22[4] + 1.0;
                }
                if (imp == diploidN) {
                    double[] dArray23 = this.all[2];
                    dArray23[3] = dArray23[3] + 1.0;
                    if (!use) continue;
                    double[] dArray24 = this.mafAll[maf][2];
                    dArray24[3] = dArray24[3] + 1.0;
                    continue;
                }
                if (GenotypeTableUtils.isEqual(imp, known)) {
                    double[] dArray25 = this.all[2];
                    dArray25[2] = dArray25[2] + 1.0;
                    if (!use) continue;
                    double[] dArray26 = this.mafAll[maf][2];
                    dArray26[2] = dArray26[2] + 1.0;
                    continue;
                }
                if (GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, known)) {
                    double[] dArray27 = this.all[2];
                    dArray27[1] = dArray27[1] + 1.0;
                    if (!use) continue;
                    double[] dArray28 = this.mafAll[maf][2];
                    dArray28[1] = dArray28[1] + 1.0;
                    continue;
                }
                double[] dArray29 = this.all[2];
                dArray29[0] = dArray29[0] + 1.0;
                if (!use) continue;
                double[] dArray30 = this.mafAll[maf][2];
                dArray30[0] = dArray30[0] + 1.0;
            }
        }
        this.accuracyOut(this.all, runtime);
        if (this.MAFClass != null) {
            this.accuracyMAFOut(this.mafAll);
        }
    }

    @Override
    public void setParameters(String[] args) {
        this.FILLINargs = Arrays.copyOf(args, args.length);
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        engine.add("-hmp", "-hmpFile", true);
        engine.add("-o", "--outFile", true);
        engine.add("-d", "--donorH", true);
        engine.add("-maskKeyFile", "--maskKeyFile", true);
        engine.add("-propSitesMask", "--propSitesMask", true);
        engine.add("-mxHet", "--hetThresh", true);
        engine.add("-minMnCnt", "--minMnCnt", true);
        engine.add("-mxInbErr", "--mxInbErr", true);
        engine.add("-mxHybErr", "--mxHybErr", true);
        engine.add("-hybNNOff", "--hybNNOff", true);
        engine.add("-mxDonH", "--mxDonH", true);
        engine.add("-mnTestSite", "--mnTestSite", true);
        engine.add("-projA", "--projAlign", false);
        engine.add("-runChrMode", "--runChrMode", false);
        engine.add("-nV", "--nonVerbose", false);
        engine.parse(args);
        this.unimpFile = engine.getString("-hmp");
        this.outFile = engine.getString("-o");
        this.maskKeyFile = engine.getString("-maskKeyFile");
        if (engine.getBoolean("-propSitesMask")) {
            this.propSitesMask = Double.parseDouble(engine.getString("-propSitesMask"));
        }
        if (engine.getBoolean("-nV")) {
            this.verboseOutput = false;
        }
    }

    private void printUsage() {
        myLogger.info((Object)("\n\n\nThis plugin masks files, calls FILLINImputationPlugin and calculates accuracy by unadjusted R2 at masked sites.\nIf not provided with a masked file and associated key file, random sites masked. \nIf masked data provided, please set masked sites to missing in the file for imputation and indicate masked sites bynon-missing genotypes in the associated key file.\nAvailable options for the FILLINImputationAccuracyPlugin are as follows:\n-hmp   Input HapMap file of target genotypes to impute. Accepts all file types supported by TASSEL5\n-d    Donor haplotype files from output of FILLINFindHaplotypesPlugin. Use .gX in the input filename to denote the substring .gc#s# found in donor files\n-o     Output file; hmp.txt.gz and .hmp.h5 accepted. Required\n-maskKeyFile An optional key file to indicate that file is already masked for accuracy calculation. Non-missing genotypes indicate masked sites. Else, will generate own mask\n-propSitesMask   The proportion of non missing sites to mask for accuracy calculation if depth is not available (default:" + this.propSitesMask + "\n" + "-mxHet   Threshold per taxon heterozygosity for treating taxon as heterozygous (no Viterbi, het thresholds)\n" + "-minMnCnt    Minimum number of informative minor alleles in the search window\n" + "-mxInbErr    Maximum error rate for applying one haplotype to entire site window\n" + "-mxHybErr    Maximum error rate for applying Viterbi with to haplotypes to entire site window\n" + "-hybNNOff    Whether to model two haplotypes as heterozygotic for focus blocks\n" + "-mxDonH   Maximum number of donor hypotheses to be explored\n" + "-mnTestSite   Minimum number of sites to test for IBS between haplotype and target in focus block\n" + "-projA   Create a projection alignment for high density markers (default off)\n" + "-nV   Supress system out if flagged\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            long time = System.currentTimeMillis();
            FILLINImputationPlugin FILLIN = new FILLINImputationPlugin();
            FILLIN.setParameters(this.FILLINargs);
            this.initiateAccuracy(this.unimpFile, this.maskKeyFile, null, this.propSitesMask);
            FILLIN.performFunction(null);
            double runtime = (double)(System.currentTimeMillis() - time) / 1000.0;
            this.calcAccuracy(ImportUtils.readGuessFormat(this.outFile), FILLINImputationPlugin.unimpAlign, runtime);
        }
        finally {
            this.fireProgress(100);
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "ImputeByFILLIN";
    }

    @Override
    public String getToolTipText() {
        return "Imputation that relies on a combination of HMM and Nearest Neighbor";
    }

    @Deprecated
    public static int[] compareAlignment(String origFile, String maskFile, String impFile, boolean noMask) {
        boolean taxaOut = false;
        GenotypeTable oA = ImportUtils.readGuessFormat(origFile);
        System.out.printf("Orig taxa:%d sites:%d %n", oA.numberOfTaxa(), oA.numberOfSites());
        GenotypeTable mA = null;
        if (!noMask) {
            mA = ImportUtils.readGuessFormat(maskFile);
            System.out.printf("Mask taxa:%d sites:%d %n", mA.numberOfTaxa(), mA.numberOfSites());
        }
        GenotypeTable iA = ImportUtils.readGuessFormat(impFile);
        System.out.printf("Imp taxa:%d sites:%d %n", iA.numberOfTaxa(), iA.numberOfSites());
        int correct = 0;
        int errors = 0;
        int unimp = 0;
        int hets = 0;
        int gaps = 0;
        for (int t = 0; t < iA.numberOfTaxa(); ++t) {
            int e = 0;
            int c = 0;
            int u = 0;
            int h = 0;
            int oATaxa = oA.taxa().indexOf(iA.taxaName(t));
            for (int s = 0; s < iA.numberOfSites(); ++s) {
                if (!noMask && oA.genotype(oATaxa, s) == mA.genotype(t, s)) continue;
                byte ib = iA.genotype(t, s);
                byte ob = oA.genotype(oATaxa, s);
                if (ib == -1 || ob == -1) {
                    ++unimp;
                    ++u;
                    continue;
                }
                if (ib == 85) {
                    ++gaps;
                    continue;
                }
                if (ib == ob) {
                    ++correct;
                    ++c;
                    continue;
                }
                if (GenotypeTableUtils.isHeterozygous(ob) || GenotypeTableUtils.isHeterozygous(ib)) {
                    ++hets;
                    ++h;
                    continue;
                }
                ++errors;
                ++e;
            }
            if (!taxaOut) continue;
            System.out.printf("%s %d %d %d %d %n", iA.taxaName(t), u, h, c, e);
        }
        System.out.println("MFile\tIFile\tGap\tUnimp\tUnimpHets\tCorrect\tErrors");
        System.out.printf("%s\t%s\t%d\t%d\t%d\t%d\t%d%n", maskFile, impFile, gaps, unimp, hets, correct, errors);
        return new int[]{gaps, unimp, hets, correct, errors};
    }

    @Deprecated
    public static double[] compareAlignment(GenotypeTable impGT, GenotypeTable keyGT, String taxaPrefix) {
        int hetKeys = 0;
        int hetCompared = 0;
        int hetRight = 0;
        int homoKeys = 0;
        int homoCompared = 0;
        int homoRight = 0;
        if (impGT.numberOfSites() != keyGT.numberOfSites()) {
            throw new InputMismatchException("Number of Sites do not match");
        }
        Random r = new Random();
        for (int t = 0; t < impGT.numberOfTaxa(); ++t) {
            if (taxaPrefix != null && !impGT.taxaName(t).startsWith(taxaPrefix)) continue;
            int tCompStart = homoCompared;
            int tHomoRightStart = homoRight;
            int key_t = keyGT.taxa().indexOf(impGT.taxaName(t));
            if (key_t < 0) continue;
            boolean report = impGT.taxaName(t).startsWith("XZ009E0126");
            for (int s = 0; s < impGT.numberOfSites(); ++s) {
                byte keyB = keyGT.genotype(key_t, s);
                if (keyB == -1) continue;
                byte impB = impGT.genotype(t, s);
                if (GenotypeTableUtils.isHeterozygous(keyB)) {
                    ++hetKeys;
                    if (impB == -1) continue;
                    ++hetCompared;
                    if (keyB != impB) continue;
                    ++hetRight;
                    continue;
                }
                ++homoKeys;
                if (impB == -1) continue;
                ++homoCompared;
                if (keyB == impB) {
                    ++homoRight;
                }
                if (!report) continue;
                if (keyB != impB) {
                    System.out.print("Wrong\t");
                } else {
                    System.out.print("Right\t");
                }
                System.out.printf("%s %d %s %s %n", impGT.chromosome(s).getName(), impGT.chromosomalPosition(s), NucleotideAlignmentConstants.getNucleotideIUPAC(keyB), NucleotideAlignmentConstants.getNucleotideIUPAC(impB));
            }
        }
        double totalKey = hetKeys + homoKeys;
        double propImp = (double)(hetCompared + homoCompared) / totalKey;
        double homoRightProp = (double)homoRight / (double)homoCompared;
        double hetRightProp = (double)hetRight / (double)hetCompared;
        return new double[]{propImp, homoRightProp, hetRightProp};
    }
}

