/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.maizegenetics.dna.map.TagMappingInfoV3;
import net.maizegenetics.dna.map.TagsOnPhysicalMapV3;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TagGroups;

public class TagBlockPosition {
    int[] blockChr;
    int[] blockPos;

    public TagBlockPosition(String tbtH5FileS, String topmH5FileS, String software) {
        long lastTimePoint = System.nanoTime();
        TagsByTaxaByteHDF5TagGroups tbt = new TagsByTaxaByteHDF5TagGroups(tbtH5FileS);
        System.out.println("Loading TBT HDF5 took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds");
        System.out.println("TBT has " + tbt.getTagCount() + " tags and " + tbt.getTaxaCount() + " taxa\n");
        lastTimePoint = System.nanoTime();
        TagMappingInfoV3.Aligner alignerName = TagMappingInfoV3.Aligner.getAlignerFromName(software);
        if (alignerName == null) {
            System.out.println("Input software is not Bowtie2, BWA or Blast, not supporting other aligner for now.");
            System.out.println("Program stops.");
            System.exit(0);
        }
        this.blockChr = new int[tbt.getTagCount()];
        this.blockPos = new int[tbt.getTagCount()];
        TagsOnPhysicalMapV3 topm = new TagsOnPhysicalMapV3(topmH5FileS);
        for (int i = 0; i < tbt.getTagCount(); ++i) {
            long[] t = tbt.getTag(i);
            int index = topm.getTagIndex(t);
            if (index < 0) {
                this.blockChr[i] = Integer.MIN_VALUE;
                this.blockPos[i] = Integer.MIN_VALUE;
                continue;
            }
            int[] chrPos = topm.getUniqueMappingOfAligner(index, alignerName);
            if (chrPos == null) {
                this.blockChr[i] = Integer.MIN_VALUE;
                this.blockPos[i] = Integer.MIN_VALUE;
                continue;
            }
            this.blockChr[i] = chrPos[0];
            this.blockPos[i] = chrPos[1];
        }
        System.out.println("Generating TagBlockPosition from TOPM took " + String.valueOf(this.getTimeSpanSecond(lastTimePoint)) + " seconds\n");
    }

    public TagBlockPosition(String blockFileS) {
        this.readTagBlockPostition(blockFileS);
    }

    public void readTagBlockPostition(String blockFileS) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(blockFileS), 65536));
            int tagCount = (int)(new File(blockFileS).length() / 8L);
            this.blockChr = new int[tagCount];
            this.blockPos = new int[tagCount];
            for (int i = 0; i < tagCount; ++i) {
                this.blockChr[i] = dis.readInt();
                this.blockPos[i] = dis.readInt();
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeTagBlockPosition(String blockFileS) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(blockFileS), 65536));
            dos.writeInt(this.blockChr.length);
            for (int i = 0; i < this.blockChr.length; ++i) {
                dos.writeInt(this.blockChr[i]);
                dos.writeInt(this.blockPos[i]);
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    public int[] getBlockChr() {
        return this.blockChr;
    }

    public int[] getBlockPos() {
        return this.blockPos;
    }

    public int getBlockChr(int index) {
        return this.blockChr[index];
    }

    public int getBlockPos(int index) {
        return this.blockPos[index];
    }

    private double getTimeSpanSecond(long lastTimePoint) {
        return (double)this.getTimeSpanNano(lastTimePoint) / 1.0E9;
    }

    private long getTimeSpanNano(long lastTimePoint) {
        return System.nanoTime() - lastTimePoint;
    }
}

