/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.util.OpenBitSet;

public class SimpleGenotypeSBit {
    public int taxaNum;
    public int chrNum;
    public int siteNum;
    public int wordNum;
    public String[] taxaNames;
    public int[] chromosomeNumber;
    public int[] chrStartIndex;
    public int[] chrEndIndex;
    public int[] position;
    public double[] maf;
    public OpenBitSet[] obsMajor;
    public OpenBitSet[] obsMinor;
    private static final int BITS_TO_SHIFT_FOR_CHUNK = 8;
    private static final int CHUNK_SIZE = 256;
    int maxTaxaNameLength = 100;
    String ROOT = "/";
    String TAXANUM = "taxaNum";
    String CHRNUM = "chrNum";
    String SITENUM = "siteNum";
    String WORDNUM = "wordNum";
    String TAXANAMES = "taxaNames";
    String CHROMOSOME = "chromosome";
    String CHRSTARTINDEX = "chrStartIndex";
    String CHRENDINDEX = "chrEndIndex";
    String POSITION = "position";
    String MAF = "maf";
    String OBSMAJOR = "obsMajor";
    String OBSMINOR = "obsMinor";
    HDF5IntStorageFeatures intFeature = HDF5IntStorageFeatures.createDeflation((int)9);
    HDF5GenericStorageFeatures genericFeature = HDF5GenericStorageFeatures.createDeflation((int)9);
    HDF5FloatStorageFeatures floatFeature = HDF5FloatStorageFeatures.createDeflation((int)9);

    public SimpleGenotypeSBit(String genotypeH5FileS, String sBitFileS) {
        long lastTimePoint = System.nanoTime();
        GenotypeTable gt = ImportUtils.readGuessFormat(genotypeH5FileS);
        this.taxaNames = new String[gt.numberOfTaxa()];
        for (int i = 0; i < this.taxaNames.length; ++i) {
            this.taxaNames[i] = gt.taxaName(i);
        }
        this.taxaNum = this.taxaNames.length;
        int[] chrOffSet = gt.chromosomesOffsets();
        this.chromosomeNumber = new int[gt.numChromosomes()];
        this.chrStartIndex = new int[this.chromosomeNumber.length];
        this.chrEndIndex = new int[this.chromosomeNumber.length];
        for (int i = 0; i < this.chromosomeNumber.length; ++i) {
            this.chromosomeNumber[i] = gt.chromosomes()[i].getChromosomeNumber();
            this.chrStartIndex[i] = chrOffSet[i];
            this.chrEndIndex[i] = chrOffSet[i] + gt.chromosomeSiteCount(gt.chromosomes()[i]);
        }
        this.chrNum = this.chromosomeNumber.length;
        this.position = gt.physicalPositions();
        this.siteNum = this.position.length;
        System.out.println("This genotype has " + this.taxaNum + " taxa, " + this.chromosomeNumber.length + " chromosomes, " + this.siteNum + " sites");
        System.out.println("Will be transformed to sBit with " + this.getChunkNum() + " chunks, each chunk has " + this.getChunkSize() + " sites");
        this.maf = new double[gt.numberOfSites()];
        this.obsMajor = new OpenBitSet[gt.numberOfSites()];
        this.obsMinor = new OpenBitSet[gt.numberOfSites()];
        for (int i = 0; i < this.position.length; ++i) {
            OpenBitSet het = new OpenBitSet((long[])gt.allelePresenceForAllTaxa(i, GenotypeTable.WHICH_ALLELE.Major).getBits().clone());
            OpenBitSet bsMa = new OpenBitSet(gt.allelePresenceForAllTaxa(i, GenotypeTable.WHICH_ALLELE.Major).getBits());
            OpenBitSet bsMi = new OpenBitSet(gt.allelePresenceForAllTaxa(i, GenotypeTable.WHICH_ALLELE.Minor).getBits());
            het.and(bsMi);
            bsMa.xor(het);
            bsMi.xor(het);
            this.obsMajor[i] = bsMa;
            this.obsMinor[i] = bsMi;
            long majorCount = bsMa.cardinality();
            long minorCount = bsMi.cardinality();
            this.maf[i] = (double)minorCount / (double)(majorCount + minorCount);
        }
        this.wordNum = this.obsMajor[0].getNumWords();
        System.out.println("Transform Genotype to sBit took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
        this.writeH5File(sBitFileS);
    }

    public SimpleGenotypeSBit(String inputfileS) {
        this.readH5File(inputfileS);
    }

    public void writeH5File(String outputFileS) {
        long[][] chunk;
        int i;
        long lastTimePoint = this.getCurrentTimeNano();
        IHDF5WriterConfigurator config = HDF5Factory.configure((File)new File(outputFileS));
        config.overwrite();
        config.useUTF8CharacterEncoding();
        IHDF5Writer h5 = config.writer();
        h5.setIntAttribute(this.ROOT, this.TAXANUM, this.taxaNum);
        h5.setIntAttribute(this.ROOT, this.CHRNUM, this.chrNum);
        h5.setIntAttribute(this.ROOT, this.SITENUM, this.siteNum);
        h5.setIntAttribute(this.ROOT, this.WORDNUM, this.wordNum);
        h5.createStringArray(this.TAXANAMES, this.maxTaxaNameLength, this.taxaNames.length, this.genericFeature);
        h5.writeStringArray(this.TAXANAMES, this.taxaNames, this.genericFeature);
        h5.createIntArray(this.CHROMOSOME, this.chrNum, this.intFeature);
        h5.writeIntArray(this.CHROMOSOME, this.chromosomeNumber, this.intFeature);
        h5.createIntArray(this.CHRSTARTINDEX, this.chrNum, this.intFeature);
        h5.writeIntArray(this.CHRSTARTINDEX, this.chrStartIndex, this.intFeature);
        h5.createIntArray(this.CHRENDINDEX, this.chrNum, this.intFeature);
        h5.writeIntArray(this.CHRENDINDEX, this.chrEndIndex, this.intFeature);
        h5.createIntArray(this.POSITION, this.siteNum, this.intFeature);
        h5.writeIntArray(this.POSITION, this.position, this.intFeature);
        h5.createDoubleArray(this.MAF, this.siteNum, this.floatFeature);
        h5.writeDoubleArray(this.MAF, this.maf, this.floatFeature);
        long[][] dis = new long[this.siteNum][];
        for (i = 0; i < this.siteNum; ++i) {
            dis[i] = this.obsMajor[i].getBits();
        }
        h5.createLongMatrix(this.OBSMAJOR, (long)this.siteNum, (long)this.wordNum, this.getChunkSize(), this.wordNum, this.intFeature);
        for (i = 0; i < this.getChunkNum(); ++i) {
            chunk = this.getSubLongMatrix(dis, this.getChunkSize(), i);
            h5.writeLongMatrixBlock(this.OBSMAJOR, chunk, (long)i, 0L);
        }
        for (i = 0; i < this.siteNum; ++i) {
            dis[i] = this.obsMinor[i].getBits();
        }
        h5.createLongMatrix(this.OBSMINOR, (long)this.siteNum, (long)this.wordNum, this.getChunkSize(), this.wordNum, this.intFeature);
        for (i = 0; i < this.getChunkNum(); ++i) {
            chunk = this.getSubLongMatrix(dis, this.getChunkSize(), i);
            h5.writeLongMatrixBlock(this.OBSMINOR, chunk, (long)i, 0L);
        }
        h5.flush();
        h5.close();
        System.out.println("Write to SimpleGenotypeSBit took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
    }

    private long[][] getSubLongMatrix(long[][] dis, int actualChunkSize, int blockNumberX) {
        int i;
        long[][] result = new long[actualChunkSize][];
        int chunkStartSiteIndex = actualChunkSize * blockNumberX;
        if (chunkStartSiteIndex + actualChunkSize > this.siteNum) {
            for (i = actualChunkSize = -(chunkStartSiteIndex - this.siteNum); i < this.getChunkSize(); ++i) {
                result[i] = new long[dis[0].length];
                for (int j = 0; j < dis[0].length; ++j) {
                    result[i][j] = Long.MIN_VALUE;
                }
            }
        }
        for (i = 0; i < actualChunkSize; ++i) {
            result[i] = dis[chunkStartSiteIndex + i];
        }
        return result;
    }

    private long[][] readInSBitChunk(IHDF5Writer h5, String path) {
        long[][] dis = new long[this.siteNum][this.wordNum];
        long[][] sub = new long[this.getChunkSize()][this.wordNum];
        int actualSize = this.getChunkSize();
        for (int i = 0; i < this.getChunkNum(); ++i) {
            int chunkStartSiteIndex = this.getChunkSize() * i;
            actualSize = this.getChunkSize();
            sub = h5.readLongMatrixBlock(path, this.getChunkSize(), this.wordNum, (long)i, 0L);
            if (chunkStartSiteIndex + this.getChunkSize() > this.siteNum) {
                actualSize = this.siteNum - chunkStartSiteIndex;
            }
            for (int j = 0; j < actualSize; ++j) {
                dis[chunkStartSiteIndex + j] = sub[j];
            }
        }
        return dis;
    }

    public void readH5File(String inputFileS) {
        int i;
        long lastTimePoint = this.getCurrentTimeNano();
        IHDF5Writer h5 = HDF5Factory.open((String)inputFileS);
        this.taxaNum = h5.getIntAttribute(this.ROOT, this.TAXANUM);
        this.chrNum = h5.getIntAttribute(this.ROOT, this.CHRNUM);
        this.siteNum = h5.getIntAttribute(this.ROOT, this.SITENUM);
        this.wordNum = h5.getIntAttribute(this.ROOT, this.WORDNUM);
        this.taxaNames = h5.readStringArray(this.TAXANAMES);
        this.chromosomeNumber = h5.readIntArray(this.CHROMOSOME);
        this.chrStartIndex = h5.readIntArray(this.CHRSTARTINDEX);
        this.chrEndIndex = h5.readIntArray(this.CHRENDINDEX);
        this.position = h5.readIntArray(this.POSITION);
        this.maf = h5.readDoubleArray(this.MAF);
        this.obsMajor = new OpenBitSet[this.siteNum];
        this.obsMinor = new OpenBitSet[this.siteNum];
        h5.close();
        ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        long[][] dis = new long[this.siteNum][];
        for (int i2 = 0; i2 < this.getChunkNum(); ++i2) {
            pool.execute(new MTReadInSBitChunk(HDF5Factory.open((String)inputFileS), this.OBSMAJOR, dis, i2));
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.out.println(e.toString());
        }
        for (i = 0; i < this.siteNum; ++i) {
            this.obsMajor[i] = new OpenBitSet(dis[i]);
        }
        pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        dis = new long[this.siteNum][];
        for (i = 0; i < this.getChunkNum(); ++i) {
            pool.execute(new MTReadInSBitChunk(HDF5Factory.open((String)inputFileS), this.OBSMINOR, dis, i));
        }
        pool.shutdown();
        try {
            pool.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.out.println(e.toString());
        }
        for (int i3 = 0; i3 < this.siteNum; ++i3) {
            this.obsMinor[i3] = new OpenBitSet(dis[i3]);
        }
        System.out.println("Read SimpleGenotypeSBit took " + this.getTimeSpanSecond(lastTimePoint) + " seconds");
    }

    public int getSiteNum() {
        return this.siteNum;
    }

    public int getTaxaNum() {
        return this.taxaNum;
    }

    public int getTaxonIndex(String taxonName) {
        for (int i = 0; i < this.taxaNum; ++i) {
            if (!this.taxaNames[i].equals(taxonName)) continue;
            return i;
        }
        return -1;
    }

    private double getTimeSpanSecond(long lastTimePoint) {
        return (double)this.getTimeSpanNano(lastTimePoint) / 1.0E9;
    }

    private long getTimeSpanNano(long lastTimePoint) {
        return this.getCurrentTimeNano() - lastTimePoint;
    }

    private long getCurrentTimeNano() {
        return System.nanoTime();
    }

    public int getSiteIndex(int chr, int pos) {
        int chrIndex = Arrays.binarySearch(this.chromosomeNumber, chr);
        if (chrIndex < 0) {
            return Integer.MIN_VALUE;
        }
        int siteIndex = Arrays.binarySearch(this.position, this.chrStartIndex[chrIndex], this.chrEndIndex[chrIndex], pos);
        if (siteIndex < 0) {
            siteIndex = -siteIndex - 2;
        }
        if (siteIndex < this.chrStartIndex[chrIndex]) {
            siteIndex = this.chrStartIndex[chrIndex];
        }
        if (siteIndex > this.chrEndIndex[chrIndex]) {
            siteIndex = this.chrEndIndex[chrIndex];
        }
        return siteIndex;
    }

    public int[] getAdjacentSiteIndexRange(int siteIndex, int siteNum) {
        int currentChr = this.getChr(siteIndex);
        int half = siteNum / 2;
        int[] indexRange = new int[]{siteIndex - half, siteIndex + half + 1};
        if (indexRange[0] < 0 || this.getChr(indexRange[0]) != currentChr) {
            indexRange[0] = this.chrStartIndex[this.getChrIndex(currentChr)];
        }
        if (indexRange[1] >= this.getSiteNum() || this.getChr(indexRange[1]) != currentChr) {
            indexRange[1] = this.chrEndIndex[this.getChrIndex(currentChr)];
        }
        return indexRange;
    }

    public int getChrIndex(int chr) {
        return Arrays.binarySearch(this.chromosomeNumber, chr);
    }

    public int getChr(int index) {
        int chrIndex = Arrays.binarySearch(this.chrStartIndex, index);
        if (chrIndex < 0) {
            chrIndex = -chrIndex - 2;
        }
        return this.chromosomeNumber[chrIndex];
    }

    public int getChunkNum() {
        int num = this.siteNum / this.getChunkSize();
        if (this.siteNum % this.getChunkSize() == 0) {
            return num;
        }
        return num + 1;
    }

    public int getChunkSize() {
        return 256;
    }

    public int getPosition(int siteIndex) {
        return this.position[siteIndex];
    }

    public int getChromosomeNumber(int siteIndex) {
        int hit = Arrays.binarySearch(this.chrStartIndex, siteIndex);
        if (hit < 0) {
            hit = -hit - 2;
        }
        return this.chromosomeNumber[hit];
    }

    public void writeBinaryFile(String outputFileS) {
        try {
            int i;
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileS), 65536));
            dos.writeInt(this.taxaNames.length);
            dos.writeInt(this.chrNum);
            dos.writeInt(this.siteNum);
            dos.write(this.wordNum);
            for (i = 0; i < this.taxaNames.length; ++i) {
                dos.writeUTF(this.taxaNames[i]);
            }
            for (i = 0; i < this.chromosomeNumber.length; ++i) {
                dos.writeInt(this.chromosomeNumber[i]);
                dos.writeInt(this.chrStartIndex[i]);
                dos.writeInt(this.chrEndIndex[i]);
            }
            for (int i2 = 0; i2 < this.maf.length; ++i2) {
                int j;
                dos.writeInt(this.position[i2]);
                dos.writeDouble(this.maf[i2]);
                long[] bits = this.obsMajor[i2].getBits();
                for (j = 0; j < bits.length; ++j) {
                    dos.writeLong(bits[j]);
                }
                bits = this.obsMinor[i2].getBits();
                for (j = 0; j < bits.length; ++j) {
                    dos.writeLong(bits[j]);
                }
            }
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    public void readBinaryFile(String inputFileS) {
        try {
            int i;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFileS), 65536));
            this.taxaNum = dis.readInt();
            this.chrNum = dis.readInt();
            this.siteNum = dis.readInt();
            this.wordNum = dis.readInt();
            this.initialize();
            for (i = 0; i < this.taxaNum; ++i) {
                this.taxaNames[i] = dis.readUTF();
            }
            for (i = 0; i < this.chrNum; ++i) {
                this.chromosomeNumber[i] = dis.readInt();
                this.chrStartIndex[i] = dis.readInt();
                this.chrEndIndex[i] = dis.readInt();
            }
            long[] bits = new long[this.wordNum];
            for (int i2 = 0; i2 < this.siteNum; ++i2) {
                int j;
                this.position[i2] = dis.readInt();
                this.maf[i2] = dis.readDouble();
                for (j = 0; j < this.wordNum; ++j) {
                    bits[j] = dis.readLong();
                }
                this.obsMajor[i2] = new OpenBitSet(bits);
                for (j = 0; j < this.wordNum; ++j) {
                    bits[j] = dis.readLong();
                }
                this.obsMinor[i2] = new OpenBitSet(bits);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(1);
        }
    }

    private void initialize() {
        this.taxaNames = new String[this.taxaNum];
        this.chromosomeNumber = new int[this.chrNum];
        this.chrStartIndex = new int[this.chrNum];
        this.chrEndIndex = new int[this.chrNum];
        this.position = new int[this.siteNum];
        this.maf = new double[this.siteNum];
        this.obsMajor = new OpenBitSet[this.siteNum];
        this.obsMinor = new OpenBitSet[this.siteNum];
    }

    private class MTReadInSBitChunk
    implements Runnable {
        IHDF5Writer h5;
        String path;
        long[][] dis;
        int chunkIndex;

        public MTReadInSBitChunk(IHDF5Writer h5, String path, long[][] dis, int chunkIndex) {
            this.h5 = h5;
            this.path = path;
            this.dis = dis;
            this.chunkIndex = chunkIndex;
        }

        @Override
        public void run() {
            int chunkStartSiteIndex = SimpleGenotypeSBit.this.getChunkSize() * this.chunkIndex;
            int actualSize = SimpleGenotypeSBit.this.getChunkSize();
            long[][] sub = this.h5.readLongMatrixBlock(this.path, SimpleGenotypeSBit.this.getChunkSize(), SimpleGenotypeSBit.this.wordNum, (long)this.chunkIndex, 0L);
            if (chunkStartSiteIndex + SimpleGenotypeSBit.this.getChunkSize() > SimpleGenotypeSBit.this.siteNum) {
                actualSize = SimpleGenotypeSBit.this.siteNum - chunkStartSiteIndex;
            }
            for (int i = 0; i < actualSize; ++i) {
                this.dis[chunkStartSiteIndex + i] = sub[i];
            }
            this.h5.close();
        }
    }
}

