/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.list.IntArrayList;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByteHDF5TaxaGroups;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class SeqToTBTHDF5Plugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SeqToTBTHDF5Plugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] myFastqFileS = null;
    private String myKeyFile = null;
    private String myEnzyme = null;
    private String myOutputTBTHDF5 = null;
    private String myOutputLogFile = null;
    private Tags myMasterTags = null;
    private static int maxGoodReads = 500000000;
    IntArrayList[] taxaReads;
    int[] readsPerSample;
    int[] mappedReadsPerSample;
    int goodBarcodedReads = 0;
    int allReads = 0;
    int goodMatched = 0;
    HashMap<String, Integer> taxaNameToIndices;

    public SeqToTBTHDF5Plugin() {
        super(null, false);
    }

    public SeqToTBTHDF5Plugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        File possibleFile = new File(this.myOutputTBTHDF5);
        if (!possibleFile.exists()) {
            TagsByTaxaByteHDF5TaxaGroups tagsByTaxaByteHDF5TaxaGroups = new TagsByTaxaByteHDF5TaxaGroups(this.myMasterTags, this.myOutputTBTHDF5);
        }
        this.matchTagsToTaxa(this.myFastqFileS, this.myKeyFile, this.myEnzyme, this.myMasterTags, this.myOutputTBTHDF5, this.myOutputLogFile);
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)"\nUsage is as follows:\n-i  Input directory containing .fastq files\n-k  Barcode key file\n-e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n-o  Output HDF5 file\n-s  Max good reads per lane. (Optional. Default is 500,000,000).\n-L  Output log file \nOne of either:\n    -t  Tag count file, OR A\n    -m  Physical map file containing alignments\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-k", "--key-file", true);
            this.myArgsEngine.add("-e", "--enzyme", true);
            this.myArgsEngine.add("-o", "--output-HDF5", true);
            this.myArgsEngine.add("-L", "--outputlogfile", true);
            this.myArgsEngine.add("-s", "--max-reads", true);
            this.myArgsEngine.add("-t", "--tag-count", true);
            this.myArgsEngine.add("-m", "--physical-map", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-i");
        if (this.myArgsEngine.getBoolean("-s")) {
            maxGoodReads = Integer.parseInt(this.myArgsEngine.getString("-s"));
        }
        if (tempDirectory != null) {
            File fastqDirectory = new File(tempDirectory);
            if (!fastqDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myFastqFileS = DirectoryCrawler.listFileNames("(?i).*\\.fq$|.*\\.fq\\.gz$|.*\\.fastq$|.*_fastq\\.txt$|.*_fastq\\.gz$|.*_fastq\\.txt\\.gz$|.*_sequence\\.txt$|.*_sequence\\.txt\\.gz$|.*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", fastqDirectory.getAbsolutePath());
            if (this.myFastqFileS.length == 0 || this.myFastqFileS == null) {
                this.printUsage();
                throw new IllegalArgumentException("Couldn't find any files that end with \".fq\", \".fq.gz\", \".fastq\", \"_fastq.txt\", \"_fastq.gz\", \"_fastq.txt.gz\", \"_sequence.txt\", or \"_sequence.txt.gz\" in the supplied directory: " + tempDirectory);
            }
            myLogger.info((Object)"FastqToTBTPlugin: setParameters: Using the following fastq files:");
            for (String filename : this.myFastqFileS) {
                myLogger.info((Object)filename);
            }
        }
        if (!this.myArgsEngine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a key file (option -k).");
        }
        this.myKeyFile = this.myArgsEngine.getString("-k");
        if (this.myArgsEngine.getBoolean("-e")) {
            this.myEnzyme = this.myArgsEngine.getString("-e");
        } else {
            myLogger.warn((Object)"No enzyme specified.  Using enzyme listed in key file.");
        }
        if (!this.myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output directory (option -o).");
        }
        this.myOutputTBTHDF5 = this.myArgsEngine.getString("-o");
        if (!this.myArgsEngine.getBoolean("-L")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a log file (option -L).");
        }
        this.myOutputLogFile = this.myArgsEngine.getString("-L");
        if (this.myArgsEngine.getBoolean("-t")) {
            if (this.myArgsEngine.getBoolean("-m")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagCounts(this.myArgsEngine.getString("-t"), TagsByTaxa.FilePacking.Byte);
        } else if (this.myArgsEngine.getBoolean("-m")) {
            if (this.myArgsEngine.getBoolean("-t")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagsOnPhysicalMap(this.myArgsEngine.getString("-m"), true);
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a tagCounts file (-t) *OR* a TagsOnPhysicalMap file (-m)");
        }
    }

    public void matchTagsToTaxa(String[] fastqFileS, String keyFileS, String enzyme, Tags theMasterTags, String outputTBT, String outputLog) {
        for (int laneNum = 0; laneNum < fastqFileS.length; ++laneNum) {
            this.goodMatched = 0;
            this.allReads = 0;
            this.goodBarcodedReads = 0;
            boolean isFastQ = true;
            if (fastqFileS[laneNum].substring(fastqFileS[laneNum].lastIndexOf(File.separator)).contains("qseq")) {
                isFastQ = false;
            }
            System.out.println("\nWorking on fastq file: " + fastqFileS[laneNum]);
            File fastqFile = new File(fastqFileS[laneNum]);
            ParseBarcodeRead thePBR = SeqToTBTHDF5Plugin.initParseBarcodeRead(keyFileS, enzyme, fastqFile);
            if (thePBR == null) continue;
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            this.taxaReads = new IntArrayList[thePBR.getBarCodeCount()];
            this.mappedReadsPerSample = new int[thePBR.getBarCodeCount()];
            this.readsPerSample = new int[thePBR.getBarCodeCount()];
            this.taxaNameToIndices = new HashMap();
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
                this.taxaReads[i] = new IntArrayList(200000000 / taxaNames.length);
                this.taxaNameToIndices.put(taxaNames[i], i);
            }
            int currLine = 0;
            this.goodBarcodedReads = 0;
            this.allReads = 0;
            this.goodMatched = 0;
            try {
                String[] seqAndQual;
                BufferedReader br = SeqToTBTHDF5Plugin.getBufferedReader(fastqFileS[laneNum]);
                while ((seqAndQual = SeqToTBTHDF5Plugin.getNextSeq(br, isFastQ)) != null && this.goodBarcodedReads < maxGoodReads) {
                    ++this.allReads;
                    ++currLine;
                    ReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(seqAndQual[0], seqAndQual[1], true, 0);
                    if (rr != null) {
                        ++this.goodBarcodedReads;
                        int t = this.taxaNameToIndices.get(rr.getTaxonName());
                        int h = theMasterTags.getTagIndex(rr.getRead());
                        int n = t;
                        this.readsPerSample[n] = this.readsPerSample[n] + 1;
                        if (h > -1) {
                            ++this.goodMatched;
                            int n2 = t;
                            this.mappedReadsPerSample[n2] = this.mappedReadsPerSample[n2] + 1;
                            this.taxaReads[t].add(h);
                        }
                    }
                    if (this.allReads % 1000000 != 0) continue;
                    System.out.println("Total Reads:" + this.allReads + " goodReads:" + this.goodBarcodedReads + " goodMatched:" + this.goodMatched);
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline c=" + this.goodBarcodedReads + " e=" + e);
                e.printStackTrace();
            }
            System.out.println("Timing process (writing TagsByTaxa file)...");
            long timePoint1 = System.currentTimeMillis();
            this.writeReport(fastqFileS[laneNum], outputLog);
            this.writeTBT(outputTBT);
            System.out.println("...process (writing TagsByTaxa file) took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            System.out.println("Total number of reads in lane=" + this.allReads);
            System.out.println("Total number of good, barcoded reads=" + this.goodBarcodedReads);
            int filesDone = laneNum + 1;
            System.out.println("Finished reading " + filesDone + " of " + fastqFileS.length + " sequence files: " + fastqFileS[laneNum] + "\n");
        }
    }

    private synchronized boolean writeReport(String seqFile, String outputLog) {
        float goodPct = (float)this.goodBarcodedReads / (float)this.allReads;
        float goodMappedPct = (float)this.goodMatched / (float)this.allReads;
        try {
            DataOutputStream report = new DataOutputStream(new FileOutputStream(outputLog, true));
            report.writeBytes("File: " + seqFile + '\n' + "Total reads: " + this.allReads + '\n' + "Accepted reads (with barcode and cut site): " + this.goodBarcodedReads + "(" + goodPct + " of total)" + '\n' + "Accepted reads found in TOPM: " + this.goodMatched + "(" + goodMappedPct + " of total)" + '\n' + "name" + '\t' + "read count" + '\t' + "fraction of total" + '\t' + "mapped read count" + '\t' + "fraction mapped of total" + '\n');
            for (String name : this.taxaNameToIndices.keySet()) {
                int t = this.taxaNameToIndices.get(name);
                int count = this.readsPerSample[t];
                int mappedCount = this.mappedReadsPerSample[t];
                float pct = (float)count / (float)this.allReads;
                float mappedPct = (float)mappedCount / (float)count;
                report.writeBytes(name + '\t' + count + '\t' + pct + '\t' + mappedCount + '\t' + mappedPct + '\n');
            }
            report.close();
        }
        catch (Exception e) {
            myLogger.warn((Object)("Caught exception while writing report file for file " + seqFile + ": " + e));
            return false;
        }
        return true;
    }

    private synchronized boolean writeTBT(String outputTBT) {
        TagsByTaxaByteHDF5TaxaGroups theTBT = new TagsByTaxaByteHDF5TaxaGroups(outputTBT);
        for (String name : this.taxaNameToIndices.keySet()) {
            int t = this.taxaNameToIndices.get(name);
            byte[] tagByteDist = SeqToTBTHDF5Plugin.getTagsDistribution(theTBT.getTagCount(), this.taxaReads[t]);
            theTBT.addTaxon(name, tagByteDist);
            System.out.printf("Taxon %s written to %s %n", name, outputTBT);
        }
        theTBT.getFileReadyForClosing();
        theTBT = null;
        try {
            System.out.println("Sleeping thread" + Thread.currentThread().getName());
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            System.err.println("Sleeping failed");
            return false;
        }
        return true;
    }

    private static String[] getNextSeq(BufferedReader br, boolean isFastQ) {
        String[] s = new String[2];
        try {
            if (isFastQ) {
                String temp = br.readLine();
                if (temp == null) {
                    return null;
                }
                while (temp.charAt(0) != '@') {
                    temp = br.readLine();
                    if (temp != null) continue;
                    return null;
                }
                s[0] = br.readLine();
                br.readLine();
                s[1] = br.readLine();
            } else {
                String temp = br.readLine();
                if (temp == null) {
                    return null;
                }
                String[] jj = temp.split("\\s");
                s[0] = jj[8];
                s[1] = jj[9];
            }
        }
        catch (IOException e) {
            System.out.println("File closing");
            return null;
        }
        return s;
    }

    private static BufferedReader getBufferedReader(String fileName) {
        BufferedReader br = null;
        try {
            br = fileName.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(fileName)))) : new BufferedReader(new FileReader(fileName), 65536);
        }
        catch (IOException e) {
            System.out.println("Failed to open file:" + fileName);
        }
        return br;
    }

    private static byte[] getTagsDistribution(int tagNumber, IntArrayList tagDist) {
        byte[] result = new byte[tagNumber];
        for (int i : tagDist.elements()) {
            if (result[i] >= 127) continue;
            int n = i;
            result[n] = (byte)(result[n] + 1);
        }
        return result;
    }

    private static ParseBarcodeRead initParseBarcodeRead(String keyFileS, String enzyme, File fastqFile) {
        ParseBarcodeRead thePBR = null;
        String[] np = fastqFile.getName().split("_");
        if (np.length == 3) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[1]);
        } else if (np.length == 5) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
        } else if (np.length == 4) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[2]);
        } else if (np.length == 6) {
            thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
        } else {
            System.out.println("Error in parsing file name:");
            System.out.println("   The filename does not contain either 3 or 5 underscore-delimited values.");
            System.out.println("   Expect: flowcell_lane_fastq.txt OR code_flowcell_s_lane_fastq.txt");
            System.out.println("   Filename: " + fastqFile.getName());
            return null;
        }
        System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
        if (thePBR.getBarCodeCount() == 0) {
            System.out.println("No barcodes found.  Skipping this flowcell.");
            return null;
        }
        return thePBR;
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

