/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.File;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.PETagCounts;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import org.apache.log4j.Logger;

public class MergePETagCountPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(MergePETagCountPlugin.class);
    private String inputDirS = null;
    private String outputFileS = null;

    public MergePETagCountPlugin() {
        super(null, false);
    }

    public MergePETagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -i  input directory containing .pe.cnt for each taxa\n -o  output filename for merged PETagCounts file\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.mergePETagCount();
        return null;
    }

    public void mergePETagCount() {
        File[] infiles = new File(this.inputDirS).listFiles();
        PETagCounts prime = new PETagCounts(infiles[0].getAbsolutePath(), TagsByTaxa.FilePacking.Byte).getCollapsedPETagCounts();
        for (int i = 1; i < infiles.length; ++i) {
            prime = prime.getMergedPETagCounts(new PETagCounts(infiles[i].getAbsolutePath(), TagsByTaxa.FilePacking.Byte), false);
        }
        prime.writeDistFile(this.outputFileS, TagsByTaxa.FilePacking.Byte, 0);
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-i", "--input-directory", true);
            this.engine.add("-o", "--output-file", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-i")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the input directory of PETagCounts files");
        }
        this.inputDirS = this.engine.getString("-i");
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the merged PETagCounts file");
        }
        this.outputFileS = this.engine.getString("-o");
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

