/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.AbstractTags;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import org.apache.log4j.Logger;

public class MergeMultipleTagCountPlugin
extends AbstractPlugin {
    private static boolean textOutput = false;
    private static long[][] ctags;
    private static int[] ctagCnt;
    private static byte[] ctagLength;
    private static int[] chunkTagSizes;
    private static int tagLengthInLong;
    private static int tagsRead;
    private static int outCnt;
    private static int rwOpen;
    private static DataInputStream[] rw;
    private static DataOutputStream outStream;
    private static ArgsEngine myArgsEngine;
    static File inputDirectory;
    static String[] inputFileNames;
    static String outputFileName;
    static int minCount;
    private static final Logger myLogger;

    public MergeMultipleTagCountPlugin() {
        super(null, false);
    }

    public MergeMultipleTagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (myArgsEngine == null) {
            myArgsEngine = new ArgsEngine();
            myArgsEngine.add("-i", "--input-directory", true);
            myArgsEngine.add("-o", "--output_file", true);
            myArgsEngine.add("-c", "--min-count", true);
            myArgsEngine.add("-t", "--fastq");
        }
        myArgsEngine.parse(args);
        if (myArgsEngine.getBoolean("-o")) {
            outputFileName = myArgsEngine.getString("-o");
            if (new File(outputFileName).isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("The output name you supplied is a directory, not a file.");
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output file.");
        }
        if (myArgsEngine.getBoolean("-i")) {
            inputDirectory = new File(myArgsEngine.getString("-i"));
            if (!inputDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("The input name you supplied is not a directory.");
            }
            inputFileNames = DirectoryCrawler.listFileNames(".*\\.cnt", inputDirectory.getAbsolutePath());
            if (inputFileNames == null || inputFileNames.length == 0) {
                this.printUsage();
                throw new IllegalArgumentException("Couldn't find any files ending in \".cnt\" in the directory you specified.");
            }
            myLogger.info((Object)"Merging the following .cnt files...");
            for (String filename : inputFileNames) {
                myLogger.info((Object)filename);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an input file.\n");
        }
        myLogger.info((Object)("...to \"" + outputFileName + "\"."));
        if (myArgsEngine.getBoolean("-t")) {
            textOutput = true;
        }
        minCount = myArgsEngine.getBoolean("-c") ? Integer.parseInt(myArgsEngine.getString("-c")) : 1;
    }

    private void printUsage() {
        myLogger.info((Object)"\nUsage is as follows:\n-i  Input directory containing .cnt files\n-o  Output file name\n-c Minimum count of reads to be output (default 1)\n-t Specifies that reads should be output in FASTQ text format.");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        MergeMultipleTagCountPlugin.mergeChunks(inputFileNames, inputDirectory, outputFileName, minCount);
        return null;
    }

    public static void mergeChunks(String[] chunkFileNames, File inputDirectory, String outputFileName, int minCount) {
        rw = new DataInputStream[chunkFileNames.length];
        chunkTagSizes = new int[rw.length];
        ctagCnt = new int[rw.length];
        ctagLength = new byte[rw.length];
        rwOpen = rw.length;
        try {
            for (int f = 0; f < rw.length; ++f) {
                String infile = chunkFileNames[f];
                MergeMultipleTagCountPlugin.rw[f] = new DataInputStream(new BufferedInputStream(new FileInputStream(infile), 4000000));
                MergeMultipleTagCountPlugin.chunkTagSizes[f] = rw[f].readInt();
                tagLengthInLong = rw[f].readInt();
                myLogger.info((Object)("Opened :" + infile + " tags=" + chunkTagSizes[f]));
            }
            outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFileName + ".fq"), 655360));
            ctags = new long[rw.length][tagLengthInLong];
            MergeMultipleTagCountPlugin.outStack("B:");
            int t = 0;
            while (rwOpen > 0) {
                long[] minTag = MergeMultipleTagCountPlugin.updateCurrentTags();
                if (textOutput) {
                    MergeMultipleTagCountPlugin.writeFASTQ(minTag, minCount);
                } else {
                    MergeMultipleTagCountPlugin.writeTags(minTag, minCount);
                }
                if (t % 1000000 == 0) {
                    System.out.printf("t=%d tagsRead=%d outCnt=%d rwOpen=%d %n", t, tagsRead, outCnt, rwOpen);
                    MergeMultipleTagCountPlugin.outStack("A:" + t);
                    myLogger.info((Object)BaseEncoder.getSequenceFromLong(minTag));
                }
                ++t;
            }
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        if (!textOutput) {
            MergeMultipleTagCountPlugin.prependHeader(outputFileName, outCnt, tagLengthInLong);
        }
    }

    private static void outStack(String prefix) {
        System.out.print(prefix + ":");
        for (int f = 0; f < rw.length; ++f) {
            System.out.print(ctags[f][0] + ":");
        }
        myLogger.info((Object)"");
    }

    private static void writeTags(long[] writeTag, int minCount) {
        int count = 0;
        int tagLength = -1;
        for (int f = 0; f < rw.length; ++f) {
            if (AbstractTags.compareTags(ctags[f], writeTag) != 0) continue;
            count += ctagCnt[f];
            tagLength = ctagLength[f];
            for (int j = 0; j < tagLengthInLong; ++j) {
                MergeMultipleTagCountPlugin.ctags[f][j] = 0L;
            }
        }
        if (count >= minCount) {
            ++outCnt;
        } else {
            return;
        }
        try {
            for (int i = 0; i < tagLengthInLong; ++i) {
                long test1 = writeTag[i];
                outStream.writeLong(test1);
            }
            byte test2 = (byte)tagLength;
            int test3 = count;
            outStream.writeByte(test2);
            outStream.writeInt(test3);
            if (count == 0) {
                myLogger.info((Object)"");
            }
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    private static void writeFASTQ(long[] writeTag, int minCount) {
        int count = 0;
        int tagLength = -1;
        String tagSequence = "";
        for (int f = 0; f < rw.length; ++f) {
            if (AbstractTags.compareTags(ctags[f], writeTag) != 0) continue;
            count += ctagCnt[f];
            tagLength = ctagLength[f];
            for (int j = 0; j < tagLengthInLong; ++j) {
                MergeMultipleTagCountPlugin.ctags[f][j] = 0L;
            }
        }
        if (count >= minCount) {
            ++outCnt;
        } else {
            return;
        }
        try {
            outStream.writeBytes("@length=" + tagLength + "count=" + count + "\n");
            tagSequence = BaseEncoder.getSequenceFromLong(writeTag);
            tagSequence = tagSequence.substring(0, tagLength);
            outStream.writeBytes(tagSequence + "\n+\n");
            for (int i = 0; i < tagLength; ++i) {
                outStream.writeBytes("f");
            }
            outStream.writeBytes("\n");
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    private static void prependHeader(String fileName, int tagCount, int tagLengthInLong) {
        myLogger.info((Object)("Adding header to " + fileName + "."));
        File inputFile = new File(fileName + ".fq");
        File outputFile = new File(fileName);
        long[] testLong = new long[2];
        int tagsWritten = 0;
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile), 4000000));
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 65536));
            output.writeInt(tagCount);
            output.writeInt(tagLengthInLong);
            for (int i = 0; i < tagCount; ++i) {
                for (int j = 0; j < tagLengthInLong; ++j) {
                    output.writeLong(input.readLong());
                }
                output.writeByte(input.readByte());
                output.writeInt(input.readInt());
                if (++tagsWritten % 1000000 != 0) continue;
                myLogger.info((Object)("Wrote " + tagsWritten + " records."));
            }
            input.close();
            output.close();
            if (!inputFile.delete()) {
                myLogger.info((Object)("WARNING: Failure to delete file:\n\t" + inputFile.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            myLogger.info((Object)("Caught exception while prepending read count to read count file: " + e));
            e.printStackTrace();
        }
    }

    private static long[] updateCurrentTags() {
        long[] minTag = new long[tagLengthInLong];
        minTag[0] = Long.MAX_VALUE;
        for (int f = 0; f < rw.length; ++f) {
            if (ctags[f][0] == 0L) {
                MergeMultipleTagCountPlugin.readNextTag(f);
            }
            if (AbstractTags.compareTags(ctags[f], minTag) >= 0) continue;
            minTag = (long[])ctags[f].clone();
        }
        return minTag;
    }

    private static void readNextTag(int f) {
        if (rw[f] == null) {
            return;
        }
        try {
            for (int j = 0; j < tagLengthInLong; ++j) {
                MergeMultipleTagCountPlugin.ctags[f][j] = rw[f].readLong();
            }
            MergeMultipleTagCountPlugin.ctagLength[f] = rw[f].readByte();
            MergeMultipleTagCountPlugin.ctagCnt[f] = rw[f].readInt();
            ++tagsRead;
        }
        catch (IOException eof) {
            try {
                myLogger.info((Object)("Finished reading file " + f + "."));
                rw[f].close();
                MergeMultipleTagCountPlugin.rw[f] = null;
                for (int i = 0; i < tagLengthInLong; ++i) {
                    MergeMultipleTagCountPlugin.ctags[f][i] = Long.MAX_VALUE;
                }
                --rwOpen;
            }
            catch (IOException eof2) {
                myLogger.info((Object)("Catch closing" + eof2));
                MergeMultipleTagCountPlugin.rw[f] = null;
            }
        }
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    static {
        tagLengthInLong = 2;
        tagsRead = 0;
        outCnt = 0;
        rwOpen = 0;
        myArgsEngine = null;
        inputDirectory = null;
        inputFileNames = null;
        outputFileName = null;
        minCount = 0;
        myLogger = Logger.getLogger(MergeMultipleTagCountPlugin.class);
    }
}

