/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedWriter;
import java.io.File;
import net.maizegenetics.util.Utils;

class CustomSNPLog {
    private final BufferedWriter myWriter;
    private final String HEADER = "Chr\tTagLocusStartPos\tTagLocusStrand\tSNPPosition\tAlleles\tnTagsAtLocus\tnReads\tnTaxa\tnTaxaCovered\tnInbreds\tnInbredsCovered\tnInbreds1Read\tnInbreds1ReadMaj\tnInbreds1ReadMin\tnInbredsGT1Read\tnInbredsGT1ReadHomoMaj\tnInbredsGT1ReadHomoMin\tnInbredHets\tinbredCoverage\tinbredHetScore\tnOutbreds\tnOutbredsCovered\tnOutbreds1Read\tnOutbreds1ReadMaj\tnOutbreds1ReadMin\tnOutbredsGT1Read\tnOutbredsGT1ReadHomoMaj\tnOutbredsGT1ReadHomoMin\tnOutbredHets\tpassed?\n";

    public CustomSNPLog(String locusLogFileName) {
        if (locusLogFileName == null || locusLogFileName.length() == 0) {
            this.myWriter = null;
        } else {
            String locusLogFileDir = locusLogFileName.substring(0, locusLogFileName.lastIndexOf(File.separator) + 1);
            String snpLogFileName = locusLogFileDir + "CustomSNPLog.txt";
            boolean exists = false;
            File file = new File(snpLogFileName);
            if (file.exists()) {
                exists = true;
            }
            this.myWriter = Utils.getBufferedWriter(snpLogFileName, false);
            if (!exists) {
                try {
                    this.myWriter.append("Chr\tTagLocusStartPos\tTagLocusStrand\tSNPPosition\tAlleles\tnTagsAtLocus\tnReads\tnTaxa\tnTaxaCovered\tnInbreds\tnInbredsCovered\tnInbreds1Read\tnInbreds1ReadMaj\tnInbreds1ReadMin\tnInbredsGT1Read\tnInbredsGT1ReadHomoMaj\tnInbredsGT1ReadHomoMin\tnInbredHets\tinbredCoverage\tinbredHetScore\tnOutbreds\tnOutbredsCovered\tnOutbreds1Read\tnOutbreds1ReadMaj\tnOutbreds1ReadMin\tnOutbredsGT1Read\tnOutbredsGT1ReadHomoMaj\tnOutbredsGT1ReadHomoMin\tnOutbredHets\tpassed?\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writeEntry(String entry) {
        try {
            this.myWriter.append(entry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.myWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

