/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.filter.FilterTaxaPropertiesDialog;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class FilterTaxaPropertiesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(FilterTaxaPropertiesPlugin.class);
    private double myMinNotMissing = 0.1;
    private double myMinHeterozygous = 0.0;
    private double myMaxHeterozygous = 1.0;

    public FilterTaxaPropertiesPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() != 1) {
                String gpMessage = "Invalid selection.  Please Select One Genotype Alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Datum current = alignInList.get(0);
            Datum result = this.processDatum(current, this.isInteractive());
            if (result != null) {
                DataSet output = new DataSet(result, (Plugin)this);
                this.fireDataSetReturned(new PluginEvent(output, FilterTaxaPropertiesPlugin.class));
                DataSet dataSet = output;
                return dataSet;
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum processDatum(Datum inDatum, boolean isInteractive) {
        GenotypeTable aa = (GenotypeTable)inDatum.getData();
        if (isInteractive) {
            FilterTaxaPropertiesDialog theDialog = new FilterTaxaPropertiesDialog();
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCancel()) {
                return null;
            }
            this.myMinNotMissing = theDialog.getMinNotMissingProportion();
            this.myMinHeterozygous = theDialog.getMinHeterozygousProportion();
            this.myMaxHeterozygous = theDialog.getMaxHeterozygousProportion();
            theDialog.dispose();
        }
        GenotypeTable result = this.getFilteredAlignment(aa);
        StringBuilder builder = new StringBuilder();
        builder.append("Filter Alignment by Taxa Properties...\n");
        builder.append("   Min. Proportion of Sites Present: ");
        builder.append(this.myMinNotMissing);
        builder.append("\n");
        builder.append("   Heterozygous Proportion: ");
        builder.append(this.myMinHeterozygous);
        builder.append(" - ");
        builder.append(this.myMaxHeterozygous);
        builder.append("\n");
        String theComment = builder.toString();
        if (result == aa) {
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "The Alignment is Unchanged.");
            } else {
                myLogger.warn((Object)("The Alignment is Unchanged: " + inDatum.getName()));
            }
        }
        if (result.numberOfTaxa() != 0) {
            String theName = inDatum.getName() + "_" + result.numberOfTaxa() + "Taxa";
            myLogger.info((Object)("Resulting Number Sequences: " + result.numberOfTaxa()));
            return new Datum(theName, result, theComment);
        }
        if (this.isInteractive()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "No remaining Taxa given filter parameters.");
        } else {
            myLogger.warn((Object)"No remaining Taxa given filter parameters.");
        }
        return null;
    }

    private GenotypeTable getFilteredAlignment(GenotypeTable alignment) {
        int numSites = alignment.numberOfSites();
        int numTaxa = alignment.numberOfTaxa();
        TaxaList ids = alignment.taxa();
        TaxaListBuilder keepTaxaList = new TaxaListBuilder();
        for (int t = 0; t < numTaxa; ++t) {
            int totalSitesNotMissing;
            int numHeterozygous;
            double percentHets;
            int totalNotMissing;
            double percentNotMissing;
            this.progress((int)((double)t / (double)numTaxa * 100.0), null);
            if (this.myMinNotMissing != 0.0 && (percentNotMissing = (double)(totalNotMissing = alignment.totalNonMissingForTaxon(t)) / (double)numSites) < this.myMinNotMissing || (this.myMinHeterozygous != 0.0 || this.myMaxHeterozygous != 1.0) && ((percentHets = (double)(numHeterozygous = alignment.heterozygousCountForTaxon(t)) / (double)(totalSitesNotMissing = alignment.totalNonMissingForTaxon(t))) < this.myMinHeterozygous || percentHets > this.myMaxHeterozygous)) continue;
            keepTaxaList.add((Taxon)ids.get(t));
        }
        return FilterGenotypeTable.getInstance(alignment, keepTaxaList.build(), false);
    }

    public double getMinNotMissing() {
        return this.myMinNotMissing;
    }

    public void setMinNotMissing(int minNotMissing) {
        if ((double)minNotMissing < 0.0 || (double)minNotMissing > 1.0) {
            throw new IllegalArgumentException("FilterTaxaPropertiesPlugin: setMinNotMissing: Value must be between 0.0 and 1.0: " + minNotMissing);
        }
        this.myMinNotMissing = minNotMissing;
    }

    public double getMinHeterozygous() {
        return this.myMinHeterozygous;
    }

    public void setMinHeterozygous(double minHeterozygous) {
        if (minHeterozygous < 0.0 || minHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterTaxaPropertiesPlugin: setMinHeterozygous: Value must be between 0.0 and 1.0: " + minHeterozygous);
        }
        this.myMinHeterozygous = minHeterozygous;
    }

    public double getMaxHeterozygous() {
        return this.myMaxHeterozygous;
    }

    public void setMaxHeterozygous(double maxHeterozygous) {
        if (maxHeterozygous < 0.0 || maxHeterozygous > 1.0) {
            throw new IllegalArgumentException("FilterTaxaPropertiesPlugin: setMaxHeterozygous: Value must be between 0.0 and 1.0: " + maxHeterozygous);
        }
        this.myMaxHeterozygous = maxHeterozygous;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = FilterTaxaPropertiesPlugin.class.getResource("/net/maizegenetics/analysis/images/Filter_horizontal.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Filter Alignment Based Taxa Properties";
    }
}

