/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.data.SynonymizerDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.IdentifierSynonymizer;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.trait.Phenotype;
import org.apache.log4j.Logger;

public class SynonymizerPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(SynonymizerPlugin.class);

    public SynonymizerPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            Serializable idGroupDatum;
            ArrayList<Datum> data = new ArrayList<Datum>();
            int n = input.getSize();
            for (int i = 0; i < n; ++i) {
                TaxaList idGroup;
                Datum current = input.getData(i);
                Object currentData = current.getData();
                if (currentData instanceof GenotypeTable) {
                    idGroup = ((GenotypeTable)currentData).taxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    data.add((Datum)idGroupDatum);
                    continue;
                }
                if (currentData instanceof Phenotype) {
                    idGroup = ((Phenotype)currentData).getTaxa();
                    idGroupDatum = new Datum(current.getName(), idGroup, current.getComment());
                    data.add((Datum)idGroupDatum);
                    continue;
                }
                data.add(current);
            }
            DataSet newInput = new DataSet(data, (Plugin)this);
            int alignCnt = newInput.getDataOfType(TaxaList.class).size();
            int synCnt = newInput.getDataOfType(IdentifierSynonymizer.class).size();
            if (synCnt == 0 && alignCnt > 1) {
                Datum td = this.createSynonymizer(newInput);
                DataSet output = new DataSet(td, (Plugin)this);
                this.fireDataSetReturned(new PluginEvent(output, SynonymizerPlugin.class));
                idGroupDatum = output;
                return idGroupDatum;
            }
            if (synCnt == 1 && alignCnt > 0) {
                this.applySynonymsToIdGroups(newInput);
            } else if (synCnt == 1 && alignCnt == 0) {
                if (this.isInteractive()) {
                    Datum inputDatum = newInput.getDataOfType(IdentifierSynonymizer.class).get(0);
                    IdentifierSynonymizer is = (IdentifierSynonymizer)inputDatum.getData();
                    SynonymizerDialog theSD = new SynonymizerDialog(is, this.getParentFrame());
                    theSD.setLocationRelativeTo(this.getParentFrame());
                    theSD.setVisible(true);
                }
            } else {
                String msg = "To create a synonym list:\n Please first select the reference taxa names and then the synonym taxa names (use Ctrl key)\nTo apply a synonym list to a dataset:\n Select a synonym list and then the taxa names to be changed (use Ctrl key)";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), msg);
                } else {
                    myLogger.error((Object)msg);
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private Datum createSynonymizer(DataSet input) {
        Datum td = null;
        StringBuilder synonymSets = new StringBuilder();
        for (int i = 1; i < input.getSize(); ++i) {
            synonymSets.append(input.getData(i).getName());
            synonymSets.append("\n");
        }
        boolean performFunction = true;
        String msg = "You have selected to apply synonym list " + input.getData(0).getName() + " to the following dataset:\n" + synonymSets.toString();
        if (this.isInteractive()) {
            int response = JOptionPane.showOptionDialog(this.getParentFrame(), msg, "Verify Selection", 2, 3, null, null, null);
            if (response == 2) {
                performFunction = false;
            }
        } else {
            myLogger.info((Object)msg);
        }
        if (performFunction) {
            List<Datum> idList = input.getDataOfType(TaxaList.class);
            TaxaList[] aa = new TaxaList[idList.size() - 1];
            for (int i = 1; i < idList.size(); ++i) {
                aa[i - 1] = (TaxaList)idList.get(i).getData();
            }
            IdentifierSynonymizer ts = new IdentifierSynonymizer((TaxaList)idList.get(0).getData(), aa);
            StringWriter sw = new StringWriter();
            ts.report(new PrintWriter(sw));
            td = new Datum(input.getData(0).getName() + " Synonyms", ts, "Taxa synonyms\n" + sw.toString());
        }
        return td;
    }

    private void applySynonymsToIdGroups(DataSet input) {
        StringBuilder synonymSets = new StringBuilder();
        for (int i = 1; i < input.getSize(); ++i) {
            synonymSets.append(input.getData(i).getName());
            synonymSets.append("\n");
        }
        boolean performFunction = true;
        String msg = "You have selected " + input.getData(0).getName() + " as the reference name dataset.\n" + "The synonyms will be extracted from the following: \n" + synonymSets.toString();
        if (this.isInteractive()) {
            int response = JOptionPane.showOptionDialog(this.getParentFrame(), msg, "Verify Selection", 2, 3, null, null, null);
            if (response == 2) {
                performFunction = false;
            }
        } else {
            myLogger.info((Object)msg);
        }
        if (performFunction) {
            IdentifierSynonymizer is = (IdentifierSynonymizer)input.getDataOfType(IdentifierSynonymizer.class).get(0).getData();
            List<Datum> idList = input.getDataOfType(TaxaList.class);
            TaxaList[] aa = new TaxaList[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                aa[i] = (TaxaList)idList.get(i).getData();
            }
            is.changeAlignmentIdentifiers(aa);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SynonymizerPlugin.class.getResource("/net/maizegenetics/analysis/images/Synonymizer.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Synonymizer";
    }

    @Override
    public String getToolTipText() {
        return "Unify Taxa Names";
    }
}

