/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class MergeAlignmentsPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(MergeAlignmentsPlugin.class);

    public MergeAlignmentsPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        List<Datum> inputs = input.getDataOfType(GenotypeTable.class);
        if (inputs == null || inputs.size() < 2) {
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Must select at least two alignments.");
            } else {
                myLogger.warn((Object)"performFunction: Must select at least two alignments.");
            }
            return null;
        }
        try {
            GenotypeTable[] alignments = new GenotypeTable[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                alignments[i] = (GenotypeTable)inputs.get(i).getData();
            }
            GenotypeTable alignment = MergeAlignmentsPlugin.getInstance(alignments);
            DataSet result = new DataSet(new Datum("Merged Alignment", alignment, null), (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(result, MergeAlignmentsPlugin.class));
            DataSet dataSet = result;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SeparatePlugin.class.getResource("/net/maizegenetics/analysis/images/Merge.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Merge Alignments";
    }

    @Override
    public String getToolTipText() {
        return "Merge Alignments";
    }

    public static GenotypeTable getInstance(GenotypeTable[] alignments) {
        throw new UnsupportedOperationException("Logic for merging can be done much better now in TASSEL 5");
    }
}

