/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.maizegenetics.util.TableReport;
import org.jfree.data.xy.DefaultTableXYDataset;

public class TableReportQQDataset
extends DefaultTableXYDataset {
    double[][] theData;
    String[] seriesNames;
    String xName;
    String myTrait;
    int numberYAxes = 1;
    Object[] myColumnNames;
    double[] myPValues;
    double[] myLogPValues;
    double[] myExpectedPValues;
    double[] myLogExpectedPValues;
    int[] myPositions;
    String[] myMarkers;
    HashMap myLookupTable;
    int myPValueColumnIndex = -1;
    int myPositionColumnIndex = -1;
    int myTraitColumnIndex = -1;
    int myMarkerColumnIndex = -1;
    int myNumRows;
    int myStartIndex;
    int myEndIndex;
    int myCountToDisplay;
    double myDistance = 0.01;

    public TableReportQQDataset(TableReport table) {
        this.setTableReport(table);
    }

    public TableReportQQDataset(TableReport table, int startIndex, int endIndex, int countToDisplay) {
        this.myStartIndex = startIndex;
        this.myEndIndex = endIndex;
        this.myNumRows = this.myEndIndex - startIndex;
        this.myCountToDisplay = countToDisplay;
        this.setTableReport(table);
    }

    public int getItemCount(int parm1) {
        return this.theData.length;
    }

    public Number getX(int series, int item) {
        Double x = new Double(this.theData[item][0]);
        return x;
    }

    public int getSeriesCount() {
        return this.numberYAxes;
    }

    public Number getY(int series, int item) {
        Double y = new Double(this.theData[item][1 + series]);
        return y;
    }

    public String getSeriesName(int series) {
        return this.seriesNames[series];
    }

    public String getSeriesKey(int series) {
        return this.seriesNames[series];
    }

    public String getXName() {
        return this.xName;
    }

    private void setPValueColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("p") && !this.myColumnNames[i].equals("marker_p")) continue;
            this.myPValueColumnIndex = i;
            return;
        }
        throw new IllegalArgumentException("No P-values in selected data");
    }

    private void setPositionColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Locus_pos") && !this.myColumnNames[i].equals("Site")) continue;
            this.myPositionColumnIndex = i;
            return;
        }
    }

    private void setTraitColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Trait")) continue;
            this.myTraitColumnIndex = i;
            return;
        }
    }

    private void setMarkerColumnIndex() {
        for (int i = 0; i < this.myColumnNames.length; ++i) {
            if (!this.myColumnNames[i].equals("Marker")) continue;
            this.myMarkerColumnIndex = i;
            return;
        }
    }

    private void setTrait(TableReport table) {
        this.myTrait = (String)table.getValueAt(this.myStartIndex, this.myTraitColumnIndex);
    }

    private void setPValues(TableReport myTableReport) {
        Object temp = myTableReport.getValueAt(this.myStartIndex, this.myPValueColumnIndex);
        if (temp instanceof Double) {
            for (int i = 0; i < this.myPValues.length; ++i) {
                this.myPValues[i] = (Double)myTableReport.getValueAt(this.myStartIndex + i, this.myPValueColumnIndex);
                if (this.myPValues[i] == 0.0) {
                    this.myPValues[i] = Double.MIN_VALUE;
                }
                this.myLookupTable.put(-Math.log10(this.myPValues[i]), i);
            }
        } else if (temp instanceof String) {
            for (int i = 0; i < this.myPValues.length; ++i) {
                this.myPValues[i] = Double.parseDouble((String)myTableReport.getValueAt(this.myStartIndex + i, this.myPValueColumnIndex));
                if (this.myPValues[i] == 0.0) {
                    this.myPValues[i] = Double.MIN_VALUE;
                }
                this.myLookupTable.put(-Math.log10(this.myPValues[i]), i);
            }
        } else {
            throw new IllegalStateException("TableReportQQDataset: setPValues: Unknown data type of P values: " + temp.getClass().getName());
        }
    }

    private void setPositions(TableReport myTableReport) {
        for (int i = 0; i < this.myPositions.length; ++i) {
            this.myPositions[i] = Integer.valueOf(myTableReport.getValueAt(this.myStartIndex + i, this.myPositionColumnIndex).toString());
        }
    }

    private void setMarkers(TableReport myTableReport) {
        for (int i = 0; i < this.myMarkers.length; ++i) {
            this.myMarkers[i] = (String)myTableReport.getValueAt(this.myStartIndex + i, this.myMarkerColumnIndex);
        }
    }

    public int[] getPositions() {
        return this.myPositions;
    }

    public Map getLookupTable() {
        return this.myLookupTable;
    }

    public String[] getMarkers() {
        return this.myMarkers;
    }

    private void sortPValues() {
        Arrays.sort(this.myPValues);
    }

    private void setLogPValues() {
        for (int i = 0; i < this.myLogPValues.length; ++i) {
            this.myLogPValues[i] = -Math.log10(this.myPValues[i]);
        }
    }

    private void setExpectedPValues() {
        double increment = 1.0 / (double)this.myNumRows;
        for (int i = 0; i < this.myExpectedPValues.length; ++i) {
            this.myExpectedPValues[i] = increment * (double)(i + 1);
        }
    }

    private void setLogExpectedPValues() {
        for (int i = 0; i < this.myLogExpectedPValues.length; ++i) {
            this.myLogExpectedPValues[i] = -Math.log10(this.myExpectedPValues[i]);
        }
    }

    public void setTableReport(TableReport theTable) {
        this.myColumnNames = theTable.getTableColumnNames();
        this.setPValueColumnIndex();
        this.setPositionColumnIndex();
        this.setMarkerColumnIndex();
        this.myPValues = new double[this.myNumRows];
        this.myLogPValues = new double[this.myNumRows];
        this.myExpectedPValues = new double[this.myNumRows];
        this.myLogExpectedPValues = new double[this.myNumRows];
        this.myPositions = new int[this.myNumRows];
        this.myMarkers = new String[this.myNumRows];
        this.myLookupTable = new HashMap(this.myNumRows);
        this.setPValues(theTable);
        this.setPositions(theTable);
        this.setMarkers(theTable);
        this.sortPValues();
        this.setLogPValues();
        this.setExpectedPValues();
        this.setLogExpectedPValues();
        this.setTraitColumnIndex();
        this.setTrait(theTable);
        this.theData = new double[this.myNumRows][2];
        double previousXValue = this.myLogExpectedPValues[0];
        for (int i = 0; i < this.myNumRows; ++i) {
            try {
                this.theData[i][0] = this.myLogExpectedPValues[i];
                if (i < this.myCountToDisplay) {
                    if (this.myLogPValues[i] != 0.0) {
                        this.theData[i][1] = this.myLogPValues[i];
                        continue;
                    }
                    this.theData[i][1] = Double.NaN;
                    continue;
                }
                double value = this.myLogExpectedPValues[i];
                if (previousXValue - value > this.myDistance) {
                    this.theData[i][1] = this.myLogPValues[i];
                    previousXValue = this.myLogExpectedPValues[i];
                    continue;
                }
                this.theData[i][1] = Double.NaN;
                continue;
            }
            catch (NumberFormatException ex) {
                System.out.println("throw new NumberFormatException();");
            }
        }
        this.theData[0][0] = this.myLogExpectedPValues[0];
        this.theData[this.myNumRows - 1][0] = this.myLogExpectedPValues[this.myNumRows - 1];
        this.seriesNames = new String[1];
        this.xName = "Expected -Log(P-Value)";
        this.seriesNames[0] = this.myTrait;
    }
}

