/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.PlotOptionsQQDialog;
import net.maizegenetics.analysis.chart.QQDisplayPluginDialog;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.TableReport;

public class QQDisplayPlugin
extends AbstractDisplayPlugin {
    public QQDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> tableInList = input.getDataOfType(TableReport.class);
            if (tableInList.size() != 1) {
                String message = "Invalid selection.  Please select one table result.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            TableReport myTableReport = (TableReport)tableInList.get(0).getData();
            if (this.isInteractive()) {
                try {
                    PlotOptionsQQDialog myOptions = new PlotOptionsQQDialog(this.getParentFrame(), this.getTraits(myTableReport), this.splitTable(myTableReport));
                    myOptions.setLocationRelativeTo(this.getParentFrame());
                    myOptions.setVisible(true);
                    if (!myOptions.isCanceled()) {
                        QQDisplayPluginDialog myDialog = new QQDisplayPluginDialog(this.getParentFrame(), this, myTableReport, myOptions.getSliderValue(), this.splitTable(myTableReport), myOptions.getTraitIndices());
                        myDialog.setLocationRelativeTo(this.getParentFrame());
                        myDialog.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create QQ plot " + ex);
                }
                catch (Error er) {
                    er.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create QQ plot " + er);
                }
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private ArrayList<Integer> splitTable(TableReport table) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int numRows = table.getRowCount();
        String previousTrait = "";
        for (int i = 0; i < numRows; ++i) {
            if (previousTrait.equals((String)table.getValueAt(i, 0))) continue;
            if (!((String)table.getValueAt(i, 1)).equals("None")) {
                indexes.add(new Integer(i));
                previousTrait = (String)table.getValueAt(i, 0);
                if (i <= 1) continue;
                indexes.add(new Integer(i));
                continue;
            }
            if (i == 0) continue;
            indexes.add(new Integer(i));
            indexes.add(new Integer(i + 1));
            previousTrait = (String)table.getValueAt(i + 1, 0);
        }
        indexes.add(new Integer(numRows));
        return indexes;
    }

    private String[] getTraits(TableReport table) {
        ArrayList<String> traitArray = new ArrayList<String>();
        int numRows = table.getRowCount();
        String previousTrait = "";
        for (int i = 0; i < numRows; ++i) {
            if (previousTrait.equals((String)table.getValueAt(i, 0))) continue;
            previousTrait = (String)table.getValueAt(i, 0);
            traitArray.add(previousTrait);
        }
        String[] traits = new String[traitArray.size()];
        for (int i = 0; i < traitArray.size(); ++i) {
            traits[i] = (String)traitArray.get(i);
        }
        return traits;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = QQDisplayPlugin.class.getResource("/net/maizegenetics/analysis/images/QQPlot.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "QQ Plot";
    }

    @Override
    public String getToolTipText() {
        return "Display QQ Plot";
    }
}

