/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.association;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.maizegenetics.analysis.association.MLMPlugin;

class MLMOptionDialog
extends JDialog
implements ActionListener {
    JRadioButton btnOptimum;
    JRadioButton btnCustom;
    JRadioButton btnNoCompression;
    JRadioButton btnEachMarker;
    JRadioButton btnP3D;
    ButtonGroup bgCompress;
    ButtonGroup bgVariance;
    JTextField txtCustom;
    boolean runClicked = false;
    boolean useP3D = true;
    MLMPlugin.CompressionType compressionType = MLMPlugin.CompressionType.Optimum;
    JPanel distancePanel;

    MLMOptionDialog(Frame parentFrame) {
        super(parentFrame, true);
        final Frame pframe = parentFrame;
        this.setTitle("MLM Options");
        this.setSize(new Dimension(350, 300));
        this.setLocationRelativeTo(pframe);
        Container theContentPane = this.getContentPane();
        theContentPane.setLayout(new BorderLayout());
        JPanel compressionPanel = new JPanel(new GridBagLayout());
        compressionPanel.setBorder(BorderFactory.createTitledBorder("Compression Level"));
        this.btnOptimum = new JRadioButton("Optimum Level", true);
        this.btnOptimum.setActionCommand("Optimum");
        this.btnOptimum.addActionListener(this);
        this.btnCustom = new JRadioButton("Custom Level:", false);
        this.btnCustom.setActionCommand("Custom");
        this.btnCustom.addActionListener(this);
        this.btnNoCompression = new JRadioButton("No Compression", false);
        this.btnNoCompression.setActionCommand("None");
        this.btnNoCompression.addActionListener(this);
        this.btnEachMarker = new JRadioButton("Re-estimate after each marker", false);
        this.btnEachMarker.setActionCommand("Eachmarker");
        this.btnEachMarker.addActionListener(this);
        this.btnP3D = new JRadioButton("P3D (estimate once)", true);
        this.btnP3D.setActionCommand("P3D");
        this.btnP3D.addActionListener(this);
        this.bgCompress = new ButtonGroup();
        this.bgCompress.add(this.btnOptimum);
        this.bgCompress.add(this.btnCustom);
        this.bgCompress.add(this.btnNoCompression);
        this.bgVariance = new ButtonGroup();
        this.bgVariance.add(this.btnEachMarker);
        this.bgVariance.add(this.btnP3D);
        this.txtCustom = new JTextField(5);
        Insets inset1 = new Insets(5, 15, 5, 5);
        Insets inset2 = new Insets(5, 5, 5, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = inset1;
        compressionPanel.add((Component)this.btnOptimum, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        compressionPanel.add((Component)this.btnCustom, gbc);
        ++gbc.gridx;
        gbc.insets = inset2;
        compressionPanel.add((Component)this.txtCustom, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets = inset1;
        compressionPanel.add((Component)this.btnNoCompression, gbc);
        theContentPane.add((Component)compressionPanel, "North");
        JPanel variancePanel = new JPanel(new GridBagLayout());
        variancePanel.setBorder(BorderFactory.createTitledBorder("Variance Component Estimation"));
        gbc.gridy = 0;
        variancePanel.add((Component)this.btnP3D, gbc);
        ++gbc.gridy;
        variancePanel.add((Component)this.btnEachMarker, gbc);
        theContentPane.add((Component)variancePanel, "Center");
        JButton btnHelpme = new JButton("Help Me Choose");
        String msg = "For faster analysis, impute marker values before running MLM and use P3D.\nWith imputed marker values (no missing data), P3D will be very fast but compression will actually increase execution time somewhat.\nHowever, because compression will improve the overall model fit, it should still be used.\nIf there is missing marker data, compression with P3D will probably be faster than P3D alone.\nWith small to moderate sized data sets any of the methods should give reasonable performance. \nWith large data sets consider imputing marker data then using EMMA with both compression and P3D";
        btnHelpme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(pframe, "For faster analysis, impute marker values before running MLM and use P3D.\nWith imputed marker values (no missing data), P3D will be very fast but compression will actually increase execution time somewhat.\nHowever, because compression will improve the overall model fit, it should still be used.\nIf there is missing marker data, compression with P3D will probably be faster than P3D alone.\nWith small to moderate sized data sets any of the methods should give reasonable performance. \nWith large data sets consider imputing marker data then using EMMA with both compression and P3D", "EMMA methods", 1);
            }
        });
        JButton btnRun = new JButton("Run");
        JButton btnCancel = new JButton("Cancel");
        btnRun.setActionCommand("run");
        btnRun.addActionListener(this);
        btnCancel.setActionCommand("cancel");
        btnCancel.addActionListener(this);
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createGlue());
        buttonBox.add(btnRun);
        buttonBox.add(Box.createHorizontalStrut(50));
        buttonBox.add(btnCancel);
        buttonBox.add(Box.createHorizontalStrut(50));
        buttonBox.add(btnHelpme);
        buttonBox.add(Box.createGlue());
        theContentPane.add((Component)buttonBox, "South");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public boolean useP3D() {
        return this.useP3D;
    }

    public MLMPlugin.CompressionType getCompressionType() {
        return this.compressionType;
    }

    double getCompressionLevel() {
        double comp;
        try {
            comp = Double.parseDouble(this.txtCustom.getText());
        }
        catch (Exception e) {
            comp = Double.NaN;
        }
        return comp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("run")) {
            this.runClicked = true;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        } else if (e.getActionCommand().equals("Optimum")) {
            this.compressionType = MLMPlugin.CompressionType.Optimum;
        } else if (e.getActionCommand().equals("Custom")) {
            this.compressionType = MLMPlugin.CompressionType.Custom;
        } else if (e.getActionCommand().equals("None")) {
            this.compressionType = MLMPlugin.CompressionType.None;
        } else if (e.getActionCommand().equals("Eachmarker")) {
            this.useP3D = false;
        } else if (e.getActionCommand().equals("P3D")) {
            this.useP3D = true;
        }
    }
}

