/*
 * Decompiled with CFR 0.152.
 */
package ramuCode;

import java.util.ArrayList;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;

public class CassavaUtilisRamu {
    public void filterSite(String inputGenotype, String outputGenotype, double minMAF, double coverageForTaxan, double maxHetForTaxon, double coverageForSite, double maxHetForSite) {
        GenotypeTable gt = ImportUtils.readGuessFormat(inputGenotype);
        int numSites = gt.numberOfSites();
        ArrayList<Integer> siteKeepList = new ArrayList<Integer>();
        for (int i = 0; i < numSites; ++i) {
            if (!(gt.minorAlleleFrequency(i) > minMAF)) continue;
            siteKeepList.add(i);
        }
        int[] siteKeepArray = new int[siteKeepList.size()];
        for (int i = 0; i < siteKeepList.size(); ++i) {
            siteKeepArray[i] = (Integer)siteKeepList.get(i);
        }
        FilterGenotypeTable fgtSites = FilterGenotypeTable.getInstance(gt, siteKeepArray);
        ArrayList<Integer> taxaIndexList = new ArrayList<Integer>();
        for (int m = 0; m < fgtSites.numberOfTaxa(); ++m) {
            if (!((double)fgtSites.totalGametesNonMissingForTaxon(m) / (double)fgtSites.numberOfSites() > coverageForTaxan)) continue;
            int het = 0;
            for (int n = 0; n < fgtSites.numberOfSites(); ++n) {
                if (!fgtSites.isHeterozygous(m, n)) continue;
                ++het;
            }
            if (!((double)het / (double)fgtSites.numberOfSites() < maxHetForTaxon)) continue;
            taxaIndexList.add(m);
        }
        TaxaListBuilder tlb = new TaxaListBuilder();
        int[] taxaIndexArray = new int[taxaIndexList.size()];
        for (int i = 0; i < taxaIndexArray.length; ++i) {
            tlb.add((Taxon)fgtSites.taxa().get(i));
        }
        TaxaList tl = tlb.build();
        GenotypeTable fgtTaxon = FilterGenotypeTable.getInstance(gt, tl);
        ArrayList<Integer> siteKeepList1 = new ArrayList<Integer>();
        for (int i = 0; i < fgtTaxon.numberOfSites(); ++i) {
            int siteHet = 0;
            if (!((double)fgtTaxon.totalGametesNonMissingForSite(i) / (double)fgtTaxon.numberOfTaxa() > coverageForSite)) continue;
            for (int j = 0; j < fgtTaxon.numberOfTaxa(); ++j) {
                if (!fgtTaxon.isHeterozygous(j, i)) continue;
                ++siteHet;
            }
            if (!((double)siteHet / (double)fgtTaxon.numberOfTaxa() < maxHetForSite)) continue;
            siteKeepList1.add(i);
        }
        int[] siteKeepArray1 = new int[siteKeepList1.size()];
        for (int i = 0; i < siteKeepList1.size(); ++i) {
            siteKeepArray1[i] = (Integer)siteKeepList1.get(i);
        }
        FilterGenotypeTable fgtFinal = FilterGenotypeTable.getInstance(fgtTaxon, siteKeepArray1);
        ExportUtils.writeGenotypeHDF5(fgtFinal, outputGenotype);
    }
}

