/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.maizegenetics.util.AbstractTableReport;
import net.maizegenetics.util.TableReport;

public class SimpleTableReport
extends AbstractTableReport
implements Serializable,
TableReport {
    Object[][] theData;
    Object[] theColumnNames;
    Object[] theRowNames = null;
    String theName;

    public SimpleTableReport(String theName, Object[] columnNames, Object[][] theData) {
        this.theData = theData;
        this.theColumnNames = columnNames;
        this.theName = theName;
    }

    public SimpleTableReport(TableReport tr) {
        this.theData = tr.getTableData();
        this.theColumnNames = tr.getTableColumnNames();
        this.theName = tr.getTableTitle();
    }

    public static SimpleTableReport getInstance(List<SimpleTableReport> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        int colNum = list.get(0).getTableColumnNames().length;
        int rowTotal = 0;
        for (TableReport tableReport : list) {
            if (colNum != tableReport.getTableColumnNames().length) {
                return null;
            }
            rowTotal += tableReport.getTableData().length;
        }
        Object[][] objectArray = new Object[rowTotal][colNum];
        int currRow = 0;
        Iterator<SimpleTableReport> itr = list.iterator();
        while (itr.hasNext()) {
            Object[][] f = itr.next().getTableData();
            for (int i = 0; i < f.length; ++i) {
                for (int j = 0; j < colNum; ++j) {
                    objectArray[currRow][j] = f[i][j];
                }
                ++currRow;
            }
        }
        return new SimpleTableReport(list.get(0).getTableTitle(), list.get(0).getTableColumnNames(), objectArray);
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.theColumnNames;
    }

    @Override
    public Object[][] getTableData() {
        return this.theData;
    }

    @Override
    public Object[] getRow(int row) {
        return this.theData[row];
    }

    @Override
    public String getTableTitle() {
        return this.theName;
    }

    @Override
    public int getRowCount() {
        return this.theData.length;
    }

    @Override
    public int getElementCount() {
        return this.getRowCount() * this.getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.theColumnNames.length;
    }

    public void setRowNames(Object[] rowNames) {
        this.theRowNames = rowNames;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.theData[row][col];
    }
}

