/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public class FormattedOutput
implements Serializable {
    private static FormattedOutput singleton = null;
    private NumberFormat nf = NumberFormat.getInstance(Locale.UK);

    public static synchronized FormattedOutput getInstance() {
        if (singleton == null) {
            singleton = new FormattedOutput();
        }
        return singleton;
    }

    public int displayDecimal(PrintWriter out, double number, int width) {
        String s = this.getDecimalString(number, width);
        out.print(s);
        return s.length();
    }

    public synchronized String getDecimalString(double number, int width) {
        this.nf.setMinimumFractionDigits(width);
        this.nf.setMaximumFractionDigits(width);
        return this.nf.format(number);
    }

    private static final double round(double number, int sf) {
        double decimals = Math.floor(Math.log(number) / Math.log(10.0));
        double power = Math.pow(10.0, decimals - (double)sf + 1.0);
        number /= power;
        number = Math.round(number);
        return number *= power;
    }

    public String getSFString(double[] numbers, int sf, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < numbers.length; ++i) {
            sb.append(this.getSFString(numbers[i], sf));
            if (i == numbers.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public String getSFString(double number, int sf) {
        int decimals = (int)Math.ceil(Math.log(number) / Math.log(10.0));
        double power = Math.pow(10.0, sf - decimals);
        double result = (double)Math.round(number * power) / power;
        if (Double.isInfinite(result) || Double.isNaN(result)) {
            return String.valueOf(number);
        }
        return String.valueOf(result);
    }

    public void displayLabel(PrintWriter out, String label, int width) {
        int len = label.length();
        if (len == width) {
            out.print(label);
        } else if (len < width) {
            out.print(label);
            this.multiplePrint(out, ' ', width - len);
        } else {
            for (int i = 0; i < width; ++i) {
                out.print(label.charAt(i));
            }
        }
    }

    public void displayInteger(PrintWriter out, int num, int maxNum) {
        int lenMaxNum;
        int lenNum = Integer.toString(num).length();
        if (lenNum < (lenMaxNum = Integer.toString(maxNum).length())) {
            this.multiplePrint(out, ' ', lenMaxNum - lenNum);
        }
        out.print(num);
    }

    public void displayIntegerWhite(PrintWriter out, int maxNum) {
        int lenMaxNum = Integer.toString(maxNum).length();
        this.multiplePrint(out, ' ', lenMaxNum);
    }

    public void multiplePrint(PrintWriter out, char c, int num) {
        for (int i = 0; i < num; ++i) {
            out.print(c);
        }
    }

    public static String space(int size, char c) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(c);
        }
        return new String(sb);
    }

    private FormattedOutput() {
        this.nf.setGroupingUsed(false);
    }
}

