/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.ProgressListener;

public class BitUtil {
    public static final byte[] ntzTable = new byte[]{8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public static int pop(long x) {
        x -= x >>> 1 & 0x5555555555555555L;
        x = (x & 0x3333333333333333L) + (x >>> 2 & 0x3333333333333333L);
        x = x + (x >>> 4) & 0xF0F0F0F0F0F0F0FL;
        x += x >>> 8;
        x += x >>> 16;
        x += x >>> 32;
        return (int)x & 0x7F;
    }

    public static long pop_array_to_index(long[] A, int index) {
        int numWords = BitUtil.bits2words(index + 1);
        System.out.println("numWords: " + numWords);
        long result = BitUtil.pop_array(A, 0, numWords - 1);
        int shift = index & 0x3F;
        shift = 63 - shift;
        long temp = A[numWords - 1] << shift;
        return result += (long)BitUtil.pop(temp);
    }

    public static long pop_array(long[] A, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int i;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        for (i = wordOffset; i <= n - 8; i += 8) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2];
            c = A[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4];
            c = A[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6];
            c = A[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
        }
        if (i <= n - 4) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2];
            c = A[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i];
            long c = A[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_intersect(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int i;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        for (i = wordOffset; i <= n - 8; i += 8) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & B[i + 2];
            c = A[i + 3] & B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] & B[i + 4];
            c = A[i + 5] & B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] & B[i + 6];
            c = A[i + 7] & B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
        }
        if (i <= n - 4) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & B[i + 2];
            c = A[i + 3] & B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] & B[i];
            long c = A[i + 1] & B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] & B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_union(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int i;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        for (i = wordOffset; i <= n - 8; i += 8) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] | B[i + 2];
            c = A[i + 3] | B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] | B[i + 4];
            c = A[i + 5] | B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] | B[i + 6];
            c = A[i + 7] | B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
        }
        if (i <= n - 4) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] | B[i + 2];
            c = A[i + 3] | B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] | B[i];
            long c = A[i + 1] | B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] | B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_andnot(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int i;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        for (i = wordOffset; i <= n - 8; i += 8) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & (B[i + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 3] & (B[i + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] & (B[i + 4] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 5] & (B[i + 5] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] & (B[i + 6] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 7] & (B[i + 7] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
        }
        if (i <= n - 4) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] & (B[i + 2] ^ 0xFFFFFFFFFFFFFFFFL);
            c = A[i + 3] & (B[i + 3] ^ 0xFFFFFFFFFFFFFFFFL);
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL);
            long c = A[i + 1] & (B[i + 1] ^ 0xFFFFFFFFFFFFFFFFL);
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] & (B[i] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static long pop_xor(long[] A, long[] B, int wordOffset, int numWords) {
        long foursA;
        long twosB;
        long twosA;
        int i;
        int n = wordOffset + numWords;
        long tot = 0L;
        long tot8 = 0L;
        long ones = 0L;
        long twos = 0L;
        long fours = 0L;
        for (i = wordOffset; i <= n - 8; i += 8) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] ^ B[i + 2];
            c = A[i + 3] ^ B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u2 = twos ^ twosA;
            foursA = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            b = A[i + 4] ^ B[i + 4];
            c = A[i + 5] ^ B[i + 5];
            u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 6] ^ B[i + 6];
            c = A[i + 7] ^ B[i + 7];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            u2 = twos ^ twosA;
            long foursB = twos & twosA | u2 & twosB;
            twos = u2 ^ twosB;
            u2 = fours ^ foursA;
            long eights = fours & foursA | u2 & foursB;
            fours = u2 ^ foursB;
            tot8 += (long)BitUtil.pop(eights);
        }
        if (i <= n - 4) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            twosA = ones & b | u & c;
            ones = u ^ c;
            b = A[i + 2] ^ B[i + 2];
            c = A[i + 3] ^ B[i + 3];
            u = ones ^ b;
            twosB = ones & b | u & c;
            ones = u ^ c;
            long u3 = twos ^ twosA;
            foursA = twos & twosA | u3 & twosB;
            twos = u3 ^ twosB;
            long eights = fours & foursA;
            fours ^= foursA;
            tot8 += (long)BitUtil.pop(eights);
            i += 4;
        }
        if (i <= n - 2) {
            long b = A[i] ^ B[i];
            long c = A[i + 1] ^ B[i + 1];
            long u = ones ^ b;
            long twosA2 = ones & b | u & c;
            ones = u ^ c;
            long foursA2 = twos & twosA2;
            twos ^= twosA2;
            long eights = fours & foursA2;
            fours ^= foursA2;
            tot8 += (long)BitUtil.pop(eights);
            i += 2;
        }
        if (i < n) {
            tot += (long)BitUtil.pop(A[i] ^ B[i]);
        }
        return tot += (long)((BitUtil.pop(fours) << 2) + (BitUtil.pop(twos) << 1) + BitUtil.pop(ones)) + (tot8 << 3);
    }

    public static int ntz(long val) {
        int lower = (int)val;
        int lowByte = lower & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte];
        }
        if (lower != 0) {
            lowByte = lower >>> 8 & 0xFF;
            if (lowByte != 0) {
                return ntzTable[lowByte] + 8;
            }
            lowByte = lower >>> 16 & 0xFF;
            if (lowByte != 0) {
                return ntzTable[lowByte] + 16;
            }
            return ntzTable[lower >>> 24] + 24;
        }
        int upper = (int)(val >> 32);
        lowByte = upper & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 32;
        }
        lowByte = upper >>> 8 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 40;
        }
        lowByte = upper >>> 16 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 48;
        }
        return ntzTable[upper >>> 24] + 56;
    }

    public static int ntz(int val) {
        int lowByte = val & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte];
        }
        lowByte = val >>> 8 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 8;
        }
        lowByte = val >>> 16 & 0xFF;
        if (lowByte != 0) {
            return ntzTable[lowByte] + 16;
        }
        return ntzTable[val >>> 24] + 24;
    }

    public static int ntz2(long x) {
        int n = 0;
        int y = (int)x;
        if (y == 0) {
            n += 32;
            y = (int)(x >>> 32);
        }
        if ((y & 0xFFFF) == 0) {
            n += 16;
            y >>>= 16;
        }
        if ((y & 0xFF) == 0) {
            n += 8;
            y >>>= 8;
        }
        return ntzTable[y & 0xFF] + n;
    }

    public static int ntz3(long x) {
        int n = 1;
        int y = (int)x;
        if (y == 0) {
            n += 32;
            y = (int)(x >>> 32);
        }
        if ((y & 0xFFFF) == 0) {
            n += 16;
            y >>>= 16;
        }
        if ((y & 0xFF) == 0) {
            n += 8;
            y >>>= 8;
        }
        if ((y & 0xF) == 0) {
            n += 4;
            y >>>= 4;
        }
        if ((y & 3) == 0) {
            n += 2;
            y >>>= 2;
        }
        return n - (y & 1);
    }

    public static boolean isPowerOfTwo(int v) {
        return (v & v - 1) == 0;
    }

    public static boolean isPowerOfTwo(long v) {
        return (v & v - 1L) == 0L;
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    public static BitSet[][] transpose(BitSet[][] matrix, int numDataRows, int numRows, int numColumns, ProgressListener listener) {
        if (matrix.length != numDataRows) {
            throw new IllegalArgumentException("BitUtil: transpose: number of data rows: " + numDataRows + " should equal number rows in matrix: " + matrix.length);
        }
        if (matrix[0].length != numRows) {
            throw new IllegalArgumentException("BitUtil: transpose: number of rows: " + numRows + " should equal number rows in matrix: " + matrix[0].length);
        }
        if (matrix[0][0].getNumWords() != BitUtil.bits2words(numColumns)) {
            throw new IllegalArgumentException("BitUtil: transpose: number of words in matrix: " + matrix[0][0].getNumWords() + " should equal number words required by number columns: " + BitUtil.bits2words(numColumns));
        }
        int numResultRows = numColumns;
        int numTransposeRowWords = BitUtil.bits2words(numRows);
        int numTransposeColumnWords = BitUtil.bits2words(numColumns);
        BitSet[][] result = new BitSet[numDataRows][numResultRows];
        for (int d = 0; d < numDataRows; ++d) {
            ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            for (int c = 0; c < numTransposeColumnWords; ++c) {
                int numColumnsToProcess = 64;
                if (c == numTransposeColumnWords - 1) {
                    numColumnsToProcess = numColumns - (numTransposeColumnWords - 1) * 64;
                }
                pool.execute(new Process64Columns(matrix, numTransposeRowWords, d, numColumnsToProcess, numRows, c, c * 64, result, listener));
            }
            try {
                pool.shutdown();
                if (pool.awaitTermination(600L, TimeUnit.SECONDS)) continue;
                throw new IllegalStateException("BitUtil: transpose: processing threads timed out.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("BitUtil: transpose: processing threads problem.");
            }
        }
        return result;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public static long[] transpose(long[] orig) {
        long m = -4294967296L;
        int j = 32;
        while (j != 0) {
            int k = 0;
            while (k < 64) {
                long t = (orig[k] ^ orig[k + j] << j) & m;
                orig[k] = orig[k] ^ t;
                orig[k + j] = orig[k + j] ^ t >>> j;
                k = k + j + 1 & ~j;
            }
            m ^= m >>> (j >>= 1);
        }
        return orig;
    }

    public static void printBitLong(long A) {
        System.out.println(BitUtil.toPadString(A));
    }

    public static String toPadString(long A) {
        String str = Long.toBinaryString(A);
        StringBuilder builder = new StringBuilder(64);
        int n = 64 - str.length();
        for (int i = 0; i < n; ++i) {
            builder.append("0");
        }
        builder.append(str);
        return builder.toString();
    }

    public static String toPadStringLowSiteToHighSite(long A) {
        return new StringBuffer(BitUtil.toPadString(A)).reverse().toString();
    }

    public static void printBitMatrix(long[] A) {
        for (int i = 0; i < A.length; ++i) {
            System.out.println(BitUtil.toPadString(A[i]));
        }
    }

    private static class Process64Columns
    implements Runnable {
        private final BitSet[][] myMatrix;
        private final int myNumTransposeRowWords;
        private final int myDataRow;
        private final int myNumColumnsToProcess;
        private final int myStartingResultRow;
        private final int myTransposeColumnWord;
        private final int myNumRows;
        private final BitSet[][] myResult;
        private final ProgressListener myListener;

        public Process64Columns(BitSet[][] matrix, int numTransposeRowWords, int dataRow, int numColumnsToProcess, int numRows, int transposeColumnWord, int startingResultRow, BitSet[][] result, ProgressListener listener) {
            this.myMatrix = matrix;
            this.myNumTransposeRowWords = numTransposeRowWords;
            this.myDataRow = dataRow;
            this.myNumColumnsToProcess = numColumnsToProcess;
            this.myStartingResultRow = startingResultRow;
            this.myTransposeColumnWord = transposeColumnWord;
            this.myNumRows = numRows;
            this.myResult = result;
            this.myListener = listener;
        }

        @Override
        public void run() {
            long[][] transposeMatrix = new long[this.myNumTransposeRowWords][64];
            int index = 0;
            for (int r = 0; r < this.myNumTransposeRowWords; ++r) {
                int numRowsToProcess = 64;
                if (r == this.myNumTransposeRowWords - 1) {
                    numRowsToProcess = this.myNumRows - (this.myNumTransposeRowWords - 1) * 64;
                }
                for (int x = 0; x < numRowsToProcess; ++x) {
                    transposeMatrix[r][x] = this.myMatrix[this.myDataRow][index].getBits(this.myTransposeColumnWord);
                    ++index;
                }
                transposeMatrix[r] = BitUtil.transpose(transposeMatrix[r]);
            }
            int resultRow = this.myStartingResultRow;
            for (int x = 0; x < this.myNumColumnsToProcess; ++x) {
                long[] temp = new long[this.myNumTransposeRowWords];
                for (int r = 0; r < this.myNumTransposeRowWords; ++r) {
                    temp[r] = transposeMatrix[r][x];
                }
                this.myResult[this.myDataRow][resultRow++] = new OpenBitSet(temp, this.myNumTransposeRowWords);
            }
            if (this.myListener != null) {
                int totalDataRows = this.myMatrix.length;
                int totalColumnWords = this.myMatrix[this.myDataRow][0].getNumWords();
                int numUnits = totalDataRows * totalColumnWords;
                int currentUnit = this.myDataRow * totalColumnWords + this.myTransposeColumnWord + 1;
                int progress = (int)((double)currentUnit / (double)numUnits * 100.0);
                this.myListener.progress(progress, this);
            }
        }
    }
}

