/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.trait;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Trait
implements Comparable<Trait>,
Serializable {
    protected String name;
    protected boolean isDiscrete;
    protected String type;
    protected HashMap<String, Object> propertyMap;
    public static final String TYPE_DATA = "data";
    public static final String TYPE_COVARIATE = "covariate";
    public static final String TYPE_FACTOR = "factor";
    public static final String TYPE_MARKER = "marker";
    public static final String TYPE_EXCLUDE = "exclude";
    public static final String PROP_LEVEL_LABELS = "level_labels";
    public static final String PROP_FACTORS = "factors";
    public static final String PROP_CHROMOSOME = "chromosome";
    public static final String PROP_POSITION = "position";
    public static final String PROP_LOCUS = "locus";
    public static final String PROP_LOCUS_POSITION = "locusposition";
    public static final String FACTOR_ENV = "env";

    public Trait(String name, boolean isDiscrete, String type, Map<String, Object> properties) {
        this.name = name;
        this.isDiscrete = isDiscrete;
        this.type = type;
        if (properties != null) {
            this.propertyMap = new HashMap<String, Object>(properties);
        }
    }

    public Trait(String name, boolean isDiscrete, String type) {
        this(name, isDiscrete, type, null);
    }

    public static Trait getInstance(Trait trait) {
        Trait newTrait = new Trait(trait.name, trait.isDiscrete, trait.type);
        if (trait.propertyMap != null) {
            newTrait.propertyMap = new HashMap<String, Object>(trait.propertyMap);
        }
        return newTrait;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDiscrete() {
        return this.isDiscrete;
    }

    public void setLevelLabels(String[] levelLabels) {
        this.setProperty(PROP_LEVEL_LABELS, levelLabels);
    }

    public String[] getLevelLabels() {
        if (this.propertyMap == null) {
            return null;
        }
        return (String[])this.propertyMap.get(PROP_LEVEL_LABELS);
    }

    public String getLevelLabel(int level) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.getLevelLabels()[level];
    }

    public int getNumberOfLevels() {
        if (this.propertyMap == null) {
            return 0;
        }
        return this.getLevelLabels().length;
    }

    public int getNumberOfProperties() {
        if (this.propertyMap == null) {
            return 0;
        }
        return this.propertyMap.size();
    }

    public Set<Map.Entry<String, Object>> getProperties() {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.entrySet();
    }

    public Object getProperty(String propertyName) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(propertyName);
    }

    public Set<String> getPropertyNames() {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.keySet();
    }

    public void setProperty(String propertyName, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(propertyName, value);
    }

    public void addFactor(String name, String value) {
        ArrayList<String> factors = this.getFactorNames();
        if (factors == null) {
            factors = new ArrayList();
            this.setProperty(PROP_FACTORS, factors);
        }
        factors.add(name);
        this.setProperty(name, value);
    }

    public int getNumberOfFactors() {
        ArrayList<String> names = this.getFactorNames();
        if (names == null) {
            return 0;
        }
        return names.size();
    }

    public ArrayList<String> getFactorNames() {
        try {
            return (ArrayList)this.propertyMap.get(PROP_FACTORS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFactorValue(String factorName) {
        return (String)this.getProperty(factorName);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Trait)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Trait trait) {
        return this.toString().compareTo(trait.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.getNumberOfFactors() > 0) {
            ArrayList<String> factorNames = this.getFactorNames();
            for (String st : factorNames) {
                sb.append(":").append(this.getFactorValue(st));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean hasLevels() {
        if (this.propertyMap == null) {
            return false;
        }
        return this.propertyMap.get(PROP_LEVEL_LABELS) != null;
    }
}

