/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFast;

public class SweepFastNestedModel {
    double markerSS;
    double markerdf;
    double errorSS;
    double errordf;
    double taxaSS;
    double taxadf;
    double modelcfmSS;
    double modelcfmdf;
    double[] beta;
    DoubleMatrix G;

    public SweepFastNestedModel(ArrayList<ModelEffect> modelEffects, double[] data) {
        int numberOfEffects = modelEffects.size();
        DoubleMatrix[][] xtx = new DoubleMatrix[numberOfEffects][numberOfEffects];
        DoubleMatrix[] xty = new DoubleMatrix[numberOfEffects];
        int[] dimX = new int[numberOfEffects];
        for (int i = 0; i < numberOfEffects; ++i) {
            xtx[i][i] = modelEffects.get(i).getXtX();
            dimX[i] = xtx[i][i].numberOfColumns();
            xty[i] = modelEffects.get(i).getXty(data);
            for (int j = i + 1; j < numberOfEffects; ++j) {
                xtx[i][j] = ModelEffectUtils.getXtY(modelEffects.get(i), modelEffects.get(j));
            }
        }
        double yty = 0.0;
        int nobs = data.length;
        for (int i = 0; i < nobs; ++i) {
            yty += data[i] * data[i];
        }
        SweepFast sf = new SweepFast(xtx, xty, yty);
        sf.revg2sweep(0);
        double residualAfterMean = sf.getResidualSS();
        sf.setDminFromA();
        double dfother = 0.0;
        int col = 1;
        for (int i = 1; i < numberOfEffects - 2; ++i) {
            for (int j = 0; j < dimX[i]; ++j) {
                if (!sf.revg2sweep(col++)) continue;
                dfother += 1.0;
            }
        }
        double residualAfterOther = sf.getResidualSS();
        this.markerdf = 0.0;
        for (int i = 0; i < dimX[numberOfEffects - 2]; ++i) {
            if (!sf.revg2sweep(col++)) continue;
            this.markerdf += 1.0;
        }
        double residualAfterMarker = sf.getResidualSS();
        this.taxadf = 0.0;
        for (int i = 0; i < dimX[numberOfEffects - 1]; ++i) {
            if (!sf.revg2sweep(col++)) continue;
            this.taxadf += 1.0;
        }
        this.markerSS = residualAfterOther - residualAfterMarker;
        this.taxaSS = residualAfterMarker - sf.getResidualSS();
        this.modelcfmSS = residualAfterMean - residualAfterMarker;
        this.modelcfmdf = dfother + this.markerdf;
        this.errordf = (double)(data.length - 1) - this.modelcfmdf;
        this.errorSS = residualAfterMarker;
        this.beta = sf.getBeta();
        this.G = sf.getXTXpart();
    }

    public double[] getMarkerSSdf() {
        return new double[]{this.markerSS, this.markerdf};
    }

    public double[] getErrorSSdf() {
        return new double[]{this.errorSS, this.errordf};
    }

    public double[] getTaxaInMarkerSSdf() {
        return new double[]{this.taxaSS, this.taxadf};
    }

    public double[] getModelcfmSSdf() {
        return new double[]{this.modelcfmSS, this.modelcfmdf};
    }

    public double[] getBeta() {
        return this.beta;
    }

    public DoubleMatrix getInverseOfXtX() {
        return this.G;
    }
}

