/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;

public class PartitionedLinearModel {
    SweepFastLinearModel lm = null;
    ArrayList<ModelEffect> baseModel;
    DoubleMatrix G1;
    DoubleMatrix[][] x2tx1matrices;
    DoubleMatrix X1Ty;
    double modelss;
    double errorss;
    double modeldf;
    double errordf;
    double[] y;

    public PartitionedLinearModel(ArrayList<ModelEffect> baseModel, SweepFastLinearModel lm) {
        this.lm = lm;
        this.y = lm.y;
        this.baseModel = baseModel;
        this.G1 = lm.getInverseOfXtX();
        this.x2tx1matrices = new DoubleMatrix[1][baseModel.size()];
        int nx1 = baseModel.size();
        DoubleMatrix[][] x1tymatrices = new DoubleMatrix[nx1][1];
        for (int i = 0; i < nx1; ++i) {
            x1tymatrices[i][0] = baseModel.get(i).getXty(this.y);
        }
        this.X1Ty = DoubleMatrixFactory.DEFAULT.compose(x1tymatrices);
    }

    public SweepFastLinearModel getLinearModel() {
        return this.lm;
    }

    public void testNewModelEffect(ModelEffect me) {
        int nx1 = this.baseModel.size();
        for (int i = 0; i < nx1; ++i) {
            this.x2tx1matrices[0][i] = ModelEffectUtils.getXtY(me, this.baseModel.get(i));
        }
        DoubleMatrix X2TX1 = DoubleMatrixFactory.DEFAULT.compose(this.x2tx1matrices);
        DoubleMatrix X2TX2 = me.getXtX();
        DoubleMatrix A = X2TX1.mult(this.G1);
        DoubleMatrix X2TM1X2 = X2TX2.minus(A.tcrossproduct(X2TX1));
        double[] ssdf = this.lm.getResidualSSdf();
        DoubleMatrix X2Ty = me.getXty(this.y);
        DoubleMatrix X2TM1y = X2Ty.minus(A.mult(this.X1Ty));
        int[] rank = new int[]{0};
        DoubleMatrix B = X2TM1X2.generalizedInverseWithRank(rank);
        this.modelss = X2TM1y.crossproduct(B).mult(X2TM1y).get(0, 0);
        this.errorss = ssdf[0] - this.modelss;
        this.modeldf = rank[0];
        this.errordf = ssdf[1] - this.modeldf;
    }

    public double testNewModelEffect(double[] covariate) {
        int nx1 = this.baseModel.size();
        for (int i = 0; i < nx1; ++i) {
            this.x2tx1matrices[0][i] = this.baseModel.get(i).getXty(covariate).transpose();
        }
        DoubleMatrix X2TX1 = DoubleMatrixFactory.DEFAULT.compose(this.x2tx1matrices);
        DoubleMatrix A = X2TX1.mult(this.G1);
        double ax1ty = A.mult(this.X1Ty).get(0, 0);
        double ax1tx2 = A.tcrossproduct(X2TX1).get(0, 0);
        double x2tx2 = 0.0;
        double x2ty = 0.0;
        int count = 0;
        for (double d : covariate) {
            x2tx2 += d * d;
            x2ty += d * this.y[count++];
        }
        double x2tm1x2 = x2tx2 - ax1tx2;
        double x2tm1y = x2ty - ax1ty;
        if (x2tm1x2 < 1.0E-12) {
            return 0.0;
        }
        return x2tm1y * x2tm1y / x2tm1x2;
    }

    public void setModelSS(double modelss) {
        this.modelss = modelss;
        double[] ssdf = this.lm.getResidualSSdf();
        this.errorss = ssdf[0] - modelss;
        this.modeldf = 1.0;
        this.errordf = ssdf[1] - this.modeldf;
    }

    public double getModelSS() {
        return this.modelss;
    }

    public double getModeldf() {
        return this.modeldf;
    }

    public double getErrorSS() {
        return this.errorss;
    }

    public double getErrordf() {
        return this.errordf;
    }

    public double getF() {
        return this.modelss / this.errorss / this.modeldf * this.errordf;
    }

    public double getp() {
        double p = 1.0;
        if (this.modeldf == 0.0) {
            return 1.0;
        }
        try {
            p = LinearModelUtils.Ftest(this.getF(), this.modeldf, this.errordf);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return p;
    }

    public double[] getFp() {
        double F = this.modelss / this.errorss / this.modeldf * this.errordf;
        double p = Double.NaN;
        if (this.modeldf > 0.0) {
            try {
                p = LinearModelUtils.Ftest(this.getF(), this.modeldf, this.errordf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new double[]{F, p};
    }
}

