/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.ArrayList;
import java.util.Arrays;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.LinearModelUtils;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffectUtils;
import net.maizegenetics.stats.linearmodels.PartitionedLinearModel;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import net.maizegenetics.util.SimpleTableReport;

public class LinearModelForStepwiseRegression {
    ArrayList<ModelEffect> modelEffects;
    int numberOfRequiredEffects = 1;
    double[] data;
    double enterLimit = 0.001;
    double exitLimit = 0.001;
    DoubleMatrix[][] xtxmatrices;
    DoubleMatrix[] xtymatrices;
    SweepFastLinearModel lm;
    PartitionedLinearModel plm;

    public LinearModelForStepwiseRegression(ArrayList<ModelEffect> requiredEffects, double[] data) {
        this.modelEffects = requiredEffects;
        this.numberOfRequiredEffects = this.modelEffects.size();
        this.data = data;
        this.xtxmatrices = new DoubleMatrix[this.numberOfRequiredEffects][this.numberOfRequiredEffects];
        this.xtymatrices = new DoubleMatrix[this.numberOfRequiredEffects];
        for (int i = 0; i < this.numberOfRequiredEffects; ++i) {
            this.xtymatrices[i] = requiredEffects.get(i).getXty(data);
            this.xtxmatrices[i][i] = requiredEffects.get(i).getXtX();
            for (int j = i + 1; j < this.numberOfRequiredEffects; ++j) {
                this.xtxmatrices[i][j] = ModelEffectUtils.getXtY(requiredEffects.get(i), requiredEffects.get(j));
            }
        }
        this.lm = new SweepFastLinearModel(requiredEffects, data);
        double ss = this.lm.getResiduals().crossproduct().get(0, 0);
        double[] ssdf = this.lm.getResidualSSdf();
        this.plm = new PartitionedLinearModel(this.modelEffects, this.lm);
    }

    public void addEffect(ModelEffect me) {
        int i;
        this.modelEffects.add(me);
        int newdim = this.xtxmatrices.length + 1;
        DoubleMatrix[][] oldxtx = this.xtxmatrices;
        DoubleMatrix[] oldxty = this.xtymatrices;
        this.xtxmatrices = new DoubleMatrix[newdim][newdim];
        this.xtymatrices = new DoubleMatrix[newdim];
        for (i = 0; i < newdim - 1; ++i) {
            this.xtymatrices[i] = oldxty[i];
            for (int j = i; j < newdim - 1; ++j) {
                this.xtxmatrices[i][j] = oldxtx[i][j];
            }
        }
        this.xtxmatrices[newdim - 1][newdim - 1] = me.getXtX();
        this.xtymatrices[newdim - 1] = me.getXty(this.data);
        for (i = 0; i < newdim - 1; ++i) {
            this.xtxmatrices[i][newdim - 1] = ModelEffectUtils.getXtY(this.modelEffects.get(i), me);
        }
        this.lm = new SweepFastLinearModel(this.modelEffects, this.xtxmatrices, this.xtymatrices, this.data);
        double ss = this.lm.getResiduals().crossproduct().get(0, 0);
        double[] ssdf = this.lm.getResidualSSdf();
        this.plm = new PartitionedLinearModel(this.modelEffects, this.lm);
    }

    public double[] testNewEffect(ModelEffect me) {
        this.plm.testNewModelEffect(me);
        return this.plm.getFp();
    }

    public double testNewEffect(double[] covariate) {
        return this.plm.testNewModelEffect(covariate);
    }

    public double[] getFpFromModelSS(double modelss) {
        this.plm.setModelSS(modelss);
        return this.plm.getFp();
    }

    public ModelEffect backwardStep() {
        int numberOfModelEffects = this.modelEffects.size();
        if (numberOfModelEffects - this.numberOfRequiredEffects > 1) {
            double maxp = -1.0;
            double[] errorSSdf = this.lm.getResidualSSdf();
            double errorms = errorSSdf[0] / errorSSdf[1];
            int maxEffectnumber = -1;
            for (int i = this.numberOfRequiredEffects; i < numberOfModelEffects; ++i) {
                double[] ssdf = this.lm.getMarginalSSdf(i);
                double F = ssdf[0] / ssdf[1] / errorms;
                double p = -1.0;
                try {
                    p = LinearModelUtils.Ftest(F, ssdf[1], errorSSdf[1]);
                }
                catch (Exception e) {
                    System.err.println("Error calculating p value at effect = " + i);
                }
                if (!(p > maxp)) continue;
                maxp = p;
                maxEffectnumber = i;
            }
            if (maxp > this.exitLimit) {
                return this.removeTerm(maxEffectnumber);
            }
        }
        return null;
    }

    public ModelEffect removeTerm(int termNumber) {
        int olddim = this.xtxmatrices.length;
        int newdim = olddim - 1;
        DoubleMatrix[][] oldxtx = this.xtxmatrices;
        DoubleMatrix[] oldxty = this.xtymatrices;
        this.xtxmatrices = new DoubleMatrix[newdim][newdim];
        this.xtymatrices = new DoubleMatrix[newdim];
        for (int i = 0; i < newdim; ++i) {
            int ii = i;
            if (i >= termNumber) {
                ++ii;
            }
            this.xtymatrices[i] = oldxty[ii];
            for (int j = i; j < newdim; ++j) {
                int jj = j;
                if (j >= termNumber) {
                    ++jj;
                }
                this.xtxmatrices[i][j] = oldxtx[ii][jj];
            }
        }
        ModelEffect removedEffect = this.modelEffects.remove(termNumber);
        this.lm = new SweepFastLinearModel(this.modelEffects, this.xtxmatrices, this.xtymatrices, this.data);
        this.plm = new PartitionedLinearModel(this.modelEffects, this.lm);
        return removedEffect;
    }

    public DoubleMatrix getyhat() {
        double[] beta = this.lm.getBeta();
        int numberOfEffects = this.modelEffects.size();
        int start = 0;
        DoubleMatrix yhat = DoubleMatrixFactory.DEFAULT.make(this.data.length, 1, 0.0);
        for (int i = 0; i < numberOfEffects; ++i) {
            ModelEffect me = this.modelEffects.get(i);
            int nLevels = me.getNumberOfLevels();
            yhat.plusEquals(me.getyhat(Arrays.copyOfRange(beta, start, start + nLevels)));
            start += nLevels;
        }
        return yhat;
    }

    public void changeData(double[] newdata) {
        this.data = newdata;
        int numberOfEffects = this.modelEffects.size();
        for (int i = 0; i < numberOfEffects; ++i) {
            ModelEffect me = this.modelEffects.get(i);
            this.xtymatrices[i] = me.getXty(newdata);
        }
        this.lm = new SweepFastLinearModel(this.modelEffects, this.xtxmatrices, this.xtymatrices, this.data);
        this.plm = new PartitionedLinearModel(this.modelEffects, this.lm);
    }

    public SimpleTableReport outputResults(String title, String traitname) {
        Object[] result;
        Object[] heads = new String[]{"Trait", "Term", "SS", "df", "MS", "F", "p", "Rsq"};
        int numberOfEffects = this.modelEffects.size();
        Object[][] results = new Object[numberOfEffects + 1][];
        double errordf = this.lm.getResidualSSdf()[1];
        double errorss = this.lm.getResidualSSdf()[0];
        double modelss = this.lm.getModelcfmSSdf()[0];
        double modeldf = this.lm.getModelcfmSSdf()[1];
        double totalss = this.lm.getFullModelSSdf()[0] + errorss;
        for (int i = 1; i < numberOfEffects; ++i) {
            int col = 0;
            result = new Object[heads.length];
            double[] ssdf = this.lm.getMarginalSSdf(i);
            result[col++] = traitname;
            result[col++] = this.modelEffects.get(i).getID();
            result[col++] = ssdf[0];
            result[col++] = ssdf[1];
            result[col++] = ssdf[0] / ssdf[1];
            double F = ssdf[0] / ssdf[1] / errorss * errordf;
            result[col++] = F;
            try {
                result[col++] = LinearModelUtils.Ftest(F, ssdf[1], errordf);
            }
            catch (Exception e) {
                result[col++] = Double.NaN;
            }
            result[col++] = ssdf[0] / totalss;
            results[i - 1] = result;
        }
        result = new Object[heads.length];
        int col = 0;
        result[col++] = traitname;
        result[col++] = "Model";
        result[col++] = modelss;
        result[col++] = modeldf;
        result[col++] = modelss / modeldf;
        double F = modelss / modeldf / errorss * errordf;
        result[col++] = F;
        try {
            result[col] = LinearModelUtils.Ftest(F, modeldf, errordf);
        }
        catch (Exception e) {
            result[col] = Double.NaN;
        }
        int n = ++col;
        ++col;
        result[n] = modelss / totalss;
        results[numberOfEffects - 1] = result;
        result = new Object[heads.length];
        col = 0;
        result[col++] = traitname;
        result[col++] = "Error";
        result[col++] = errorss;
        result[col++] = errordf;
        result[col++] = errorss / errordf;
        result[col++] = " ";
        result[col++] = " ";
        result[col++] = " ";
        results[numberOfEffects] = result;
        return new SimpleTableReport(title, heads, results);
    }

    public SweepFastLinearModel getLinearModel() {
        return this.lm;
    }

    public ArrayList<ModelEffect> getModelEffects() {
        return this.modelEffects;
    }

    public double getEnterLimit() {
        return this.enterLimit;
    }

    public void setEnterLimit(double enterLimit) {
        this.enterLimit = enterLimit;
    }

    public double getExitLimit() {
        return this.exitLimit;
    }

    public void setExitLimit(double exitLimit) {
        this.exitLimit = exitLimit;
    }
}

