/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.ImmutableBiMap;
import net.maizegenetics.phenotype.PhenotypeAttribute;

public class CategoricalAttribute
implements PhenotypeAttribute {
    private String name;
    private int[] values;
    private ImmutableBiMap<String, Integer> labelBimap;
    private boolean[] missing;

    public int getIntegerValue(int obs) {
        return this.values[obs];
    }

    public int[] getIntegerValues() {
        return this.values;
    }

    String getAttrLabel(int index) {
        return (String)this.labelBimap.inverse().get((Object)index);
    }

    int getIndexForAttrLabel(String label) {
        return (Integer)this.labelBimap.get((Object)label);
    }

    String[] getValuesAsLabels() {
        int n = this.values.length;
        String[] labels = new String[n];
        ImmutableBiMap reverseMap = this.labelBimap.inverse();
        for (int i = 0; i < n; ++i) {
            labels[i] = (String)reverseMap.get((Object)i);
        }
        return labels;
    }

    @Override
    public Object getValue(int obs) {
        return this.labelBimap.inverse().get((Object)this.values[obs]);
    }

    @Override
    public Object getValues() {
        return this.values;
    }

    @Override
    public boolean isMissing(int obs) {
        return this.missing[obs];
    }

    @Override
    public boolean[] getMissing() {
        return this.missing;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.values.length;
    }
}

