/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.io.EOFException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class PrintTextArea {
    Frame theFrame;

    public PrintTextArea(Frame frame) {
        this.theFrame = frame;
    }

    public void printThis(String s) {
        PrintJob pjob = this.theFrame.getToolkit().getPrintJob(this.theFrame, "Cool Stuff", null);
        if (pjob != null) {
            Graphics pg = pjob.getGraphics();
            if (pg != null) {
                this.printLongString(pjob, pg, s);
                pg.dispose();
            }
            pjob.end();
        }
    }

    void printLongString(PrintJob pjob, Graphics pg, String s) {
        int pageNum = 1;
        int linesForThisPage = 0;
        int linesForThisJob = 0;
        int topMargin = 20;
        int leftMargin = 20;
        if (!(pg instanceof PrintGraphics)) {
            throw new IllegalArgumentException("Graphics context not PrintGraphics");
        }
        StringReader sr = new StringReader(s);
        LineNumberReader lnr = new LineNumberReader(sr);
        int pageHeight = pjob.getPageDimension().height - topMargin * 2;
        Font helv = new Font("Helvetica", 0, 10);
        pg.setFont(helv);
        FontMetrics fm = pg.getFontMetrics(helv);
        int fontHeight = fm.getHeight();
        int fontDescent = fm.getDescent();
        int curHeight = topMargin;
        try {
            String nextLine;
            do {
                if ((nextLine = lnr.readLine()) == null) continue;
                if (curHeight + fontHeight > pageHeight) {
                    System.out.println("" + linesForThisPage + " lines printed for page " + pageNum);
                    ++pageNum;
                    linesForThisPage = 0;
                    pg.dispose();
                    pg = pjob.getGraphics();
                    if (pg != null) {
                        pg.setFont(helv);
                    }
                    curHeight = topMargin;
                }
                curHeight += fontHeight;
                if (pg != null) {
                    pg.drawString(nextLine, leftMargin, curHeight - fontDescent);
                    ++linesForThisPage;
                    ++linesForThisJob;
                    continue;
                }
                System.out.println("pg null");
            } while (nextLine != null);
        }
        catch (EOFException eof) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("" + linesForThisPage + " lines printed for page " + pageNum);
        System.out.println("pages printed: " + pageNum);
        System.out.println("total lines printed: " + linesForThisJob);
    }
}

