/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MultiTextRowHeader
extends JPanel
implements TableCellRenderer {
    int textRows = 1;
    char delimiter = (char)46;
    JLabel[] theLabels;
    JLabel theLabel;
    VolatileImage offscreenImage;
    AffineTransform at;
    FontMetrics fm;
    Rectangle2D r2d;

    public MultiTextRowHeader(int textRows, char delimiter) {
        this.textRows = textRows;
        this.delimiter = delimiter;
        this.setLayout(new GridLayout(textRows, 1));
        if (textRows > 1) {
            this.theLabels = new JLabel[textRows];
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        String theText = value.toString();
        if (this.getComponentCount() == 0) {
            this.init(theText);
        }
        this.setToolTipText((String)value);
        return this;
    }

    private void init(String theText) {
        this.removeAll();
        int begin = 0;
        int end = 1000;
        if (this.textRows == 1) {
            this.theLabel = new JLabel(this.makeIcon(theText));
            this.add(this.theLabel);
        } else {
            for (int i = 0; i < this.textRows; ++i) {
                if (end > 0) {
                    end = theText.indexOf(this.delimiter, begin);
                    String theRemainder = end > 0 ? theText.substring(begin, end) : theText.substring(begin);
                    this.theLabels[i] = new JLabel(theRemainder);
                    begin = end + 1;
                } else {
                    this.theLabels[i] = new JLabel("");
                }
                this.add(this.theLabels[i]);
            }
        }
    }

    public ImageIcon makeIcon(String text) {
        int textLen = Math.min(text.length(), 20);
        text = text.substring(0, textLen);
        if (this.offscreenImage == null) {
            BufferedImage testImage = new BufferedImage(60, 200, 1);
            Graphics2D g2d = (Graphics2D)testImage.getGraphics();
            this.fm = g2d.getFontMetrics(new Font("Monospaced", 0, 12));
            Rectangle2D r2d = this.fm.getStringBounds("XXXXXXXXXXXXXXXXXXXXXXXX".substring(0, textLen + 1), g2d);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
            this.offscreenImage = gc.createCompatibleVolatileImage((int)(r2d.getHeight() * 1.2), (int)(r2d.getWidth() * 1.2));
            this.at = new AffineTransform();
            this.at.setToRotation(-1.5707963267948966);
        }
        Graphics2D g2d = (Graphics2D)this.offscreenImage.getGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.offscreenImage.getWidth(), this.offscreenImage.getHeight());
        g2d.setColor(Color.BLACK);
        g2d.setTransform(this.at);
        g2d.drawString(text, -((int)((double)this.offscreenImage.getHeight() * 0.9)), (int)((double)this.offscreenImage.getWidth() * 0.9));
        ImageIcon small = new ImageIcon(this.offscreenImage);
        return small;
    }
}

