/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.Tassel5HDF5Constants;

class HDF5ByteGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final int SHIFT_AMOUNT = 16;
    private final String[] genotypePaths;
    private static final int HDF5_GENOTYPE_BLOCK_SIZE = 65536;
    public static final int SITE_BLOCK_MASK = -65536;
    private final IHDF5Reader myHDF5Reader;
    private final LoadingCache<Long, byte[]> myGenoCache;
    private final CacheLoader<Long, byte[]> myGenoLoader = new CacheLoader<Long, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] load(Long key) {
            byte[] data;
            long offset = HDF5ByteGenotypeCallTable.getSiteStartFromKey(key) << 16;
            IHDF5Reader iHDF5Reader = HDF5ByteGenotypeCallTable.this.myHDF5Reader;
            synchronized (iHDF5Reader) {
                data = HDF5ByteGenotypeCallTable.this.myHDF5Reader.readAsByteArrayBlockWithOffset(HDF5ByteGenotypeCallTable.this.getTaxaGenoPath(HDF5ByteGenotypeCallTable.getTaxonFromKey(key)), 65536, offset);
            }
            return data;
        }
    };
    private LoadingCache<Integer, SiteBlockAttr> mySiteAnnoCache;
    private CacheLoader<Integer, SiteBlockAttr> siteAnnotLoader = new CacheLoader<Integer, SiteBlockAttr>(){
        int lastCachedStartSite = Integer.MIN_VALUE;
        int[][] af;
        byte[][] afOrder;
        float[] maf;
        float[] paf;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SiteBlockAttr load(Integer key) {
            int startSite = HDF5ByteGenotypeCallTable.getStartSite(key);
            int length = Math.min(65536, HDF5ByteGenotypeCallTable.this.numberOfSites() - startSite);
            System.out.println("Reading from HDF5 site anno:" + startSite);
            System.out.println("");
            IHDF5Reader iHDF5Reader = HDF5ByteGenotypeCallTable.this.myHDF5Reader;
            synchronized (iHDF5Reader) {
                this.af = HDF5ByteGenotypeCallTable.this.myHDF5Reader.readIntMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleCnt", 6, length, 0L, (long)startSite);
                this.afOrder = HDF5ByteGenotypeCallTable.this.myHDF5Reader.readByteMatrixBlockWithOffset("Genotypes/_Descriptors/AlleleFreqOrder", 6, length, 0L, (long)startSite);
                this.maf = HDF5ByteGenotypeCallTable.this.myHDF5Reader.readFloatArrayBlockWithOffset("Genotypes/_Descriptors/MAF", length, (long)startSite);
                this.paf = HDF5ByteGenotypeCallTable.this.myHDF5Reader.readFloatArrayBlockWithOffset("Genotypes/_Descriptors/SiteCoverage", length, (long)startSite);
                this.lastCachedStartSite = startSite;
            }
            SiteBlockAttr sa = new SiteBlockAttr(startSite, this.afOrder, this.af, this.maf, this.paf);
            return sa;
        }
    };

    private static long getCacheKey(int taxon, int site) {
        return ((long)taxon << 33) + (long)(site / 65536);
    }

    private static int getTaxonFromKey(long key) {
        return (int)(key >>> 33);
    }

    private static int getSiteStartFromKey(long key) {
        return (int)(key << 33 >>> 33);
    }

    private static int getStartSite(int site) {
        return site & 0xFFFF0000;
    }

    private String getTaxaGenoPath(int taxon) {
        return this.genotypePaths[taxon];
    }

    private HDF5ByteGenotypeCallTable(IHDF5Reader reader, int numTaxa, int numSites, boolean phased, String[][] alleleEncodings) {
        super(numTaxa, numSites, phased, alleleEncodings);
        this.genotypePaths = new String[numTaxa];
        TaxaList tL = new TaxaListBuilder().buildFromHDF5Genotypes(reader);
        for (int i = 0; i < numTaxa; ++i) {
            this.genotypePaths[i] = Tassel5HDF5Constants.getGenotypesCallsPath(tL.taxaName(i));
        }
        this.myHDF5Reader = reader;
        this.myGenoCache = CacheBuilder.newBuilder().maximumSize((long)(3 * this.numberOfTaxa() / 2)).build(this.myGenoLoader);
        this.mySiteAnnoCache = CacheBuilder.newBuilder().maximumSize(150L).build(this.siteAnnotLoader);
    }

    static HDF5ByteGenotypeCallTable getInstance(IHDF5Reader reader) {
        int numTaxa = reader.getIntAttribute("Genotypes/", "numTaxa");
        int numSites = reader.getIntAttribute("Positions/", "numSites");
        String[][] alleleEncodings = NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES;
        return new HDF5ByteGenotypeCallTable(reader, numTaxa, numSites, false, alleleEncodings);
    }

    @Override
    public byte genotype(int taxon, int site) {
        long key = HDF5ByteGenotypeCallTable.getCacheKey(taxon, site);
        try {
            byte[] data = (byte[])this.myGenoCache.get((Object)key);
            return data[site % 65536];
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new IllegalStateException("HDF5ByteGenotype: getBase: Error getting base from cache.");
        }
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(this.genotype(taxon, site));
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return NucleotideAlignmentConstants.getNucleotideIUPAC(value);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        try {
            SiteBlockAttr sa = (SiteBlockAttr)this.mySiteAnnoCache.get((Object)HDF5ByteGenotypeCallTable.getStartSite(site));
            return sa.getAllelesSortedByFrequency(site);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Error in getMinorAlleleFrequency from cache");
        }
    }

    @Override
    public double minorAlleleFrequency(int site) {
        try {
            SiteBlockAttr sa = (SiteBlockAttr)this.mySiteAnnoCache.get((Object)HDF5ByteGenotypeCallTable.getStartSite(site));
            return sa.getMAF(site);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Error in getMinorAlleleFrequency from cache");
        }
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class SiteBlockAttr {
        private final int startSite;
        private final byte[][] myAlleleFreqOrder;
        private final int[][] myAlleleCnt;
        private final float[] maf;
        private final float[] siteCov;

        public SiteBlockAttr(int startSite, byte[][] myAlleleFreqOrder, int[][] myAlleleCnt, float[] maf, float[] siteCov) {
            this.startSite = startSite;
            this.myAlleleFreqOrder = myAlleleFreqOrder;
            this.myAlleleCnt = myAlleleCnt;
            this.maf = maf;
            this.siteCov = siteCov;
        }

        public int[][] getAllelesSortedByFrequency(int site) {
            int offset = site - this.startSite;
            int alleleCnt = 0;
            while (this.myAlleleFreqOrder[alleleCnt][offset] != 15) {
                ++alleleCnt;
            }
            int[][] result = new int[2][alleleCnt];
            for (int i = 0; i < alleleCnt; ++i) {
                result[0][i] = this.myAlleleFreqOrder[i][offset];
                result[1][i] = this.myAlleleCnt[result[0][i]][offset];
            }
            return result;
        }

        public float getMAF(int site) {
            return this.maf[site - this.startSite];
        }

        public float getSiteCoverage(int site) {
            return this.siteCov[site - this.startSite];
        }
    }
}

