/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.regex.Pattern;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.ByteGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.FilterGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.HDF5ByteGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.NucleotideGenotypeCallTable;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

public class GenotypeCallTableBuilder {
    private SuperByteMatrix myGenotype;
    private boolean myIsPhased = false;
    private String[][] myAlleleEncodings = NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES;

    private GenotypeCallTableBuilder(SuperByteMatrix genotype) {
        this.myGenotype = genotype;
    }

    public static GenotypeCallTableBuilder getInstance(int numTaxa, int numSites) {
        return GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(numTaxa, numSites);
    }

    public static GenotypeCallTableBuilder getInstanceTranspose(int numTaxa, int numSites) {
        SuperByteMatrix matrix = SuperByteMatrixBuilder.getInstanceTranspose(numTaxa, numSites);
        matrix.setAll((byte)-1);
        return new GenotypeCallTableBuilder(matrix);
    }

    public static GenotypeCallTableBuilder getUnphasedNucleotideGenotypeBuilder(int numTaxa, int numSites) {
        SuperByteMatrix matrix = SuperByteMatrixBuilder.getInstance(numTaxa, numSites);
        matrix.setAll((byte)-1);
        return new GenotypeCallTableBuilder(matrix);
    }

    public static GenotypeCallTable getFilteredInstance(GenotypeCallTable genotype, int numTaxa, int[] taxaRedirect, int numSites, int rangeStart, int rangeEnd) {
        return new FilterGenotypeCallTable(genotype, numTaxa, taxaRedirect, numSites, rangeStart, rangeEnd);
    }

    public static GenotypeCallTable getFilteredInstance(GenotypeCallTable genotype, int numTaxa, int[] taxaRedirect, int numSites, int[] siteRedirect) {
        return new FilterGenotypeCallTable(genotype, numTaxa, taxaRedirect, numSites, siteRedirect);
    }

    public static GenotypeCallTableBuilder getInstanceCopy(GenotypeCallTable genotype) {
        if (genotype instanceof ByteGenotypeCallTable) {
            SuperByteMatrix matrix = SuperByteMatrixBuilder.getInstanceCopy(((ByteGenotypeCallTable)genotype).myGenotype);
            return new GenotypeCallTableBuilder(matrix).isPhased(genotype.isPhased()).alleleEncodings(genotype.alleleDefinitions());
        }
        int numTaxa = genotype.numberOfTaxa();
        int numSites = genotype.numberOfSites();
        GenotypeCallTableBuilder builder = GenotypeCallTableBuilder.getInstance(numTaxa, numSites).isPhased(genotype.isPhased()).alleleEncodings(genotype.alleleDefinitions());
        for (int t = 0; t < numTaxa; ++t) {
            for (int s = 0; s < numSites; ++s) {
                builder.setBase(t, s, genotype.genotype(t, s));
            }
        }
        return builder;
    }

    public GenotypeCallTableBuilder setBase(int taxon, int site, byte value) {
        this.myGenotype.set(taxon, site, value);
        return this;
    }

    public GenotypeCallTableBuilder setBaseRangeForTaxon(int taxon, int startSite, byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.myGenotype.set(taxon, i + startSite, value[i]);
        }
        return this;
    }

    public GenotypeCallTableBuilder setBases(String[] data) {
        int numTaxa = data.length;
        int numSites = data[0].length();
        for (int site = 0; site < numSites; ++site) {
            for (int taxon = 0; taxon < numTaxa; ++taxon) {
                this.setBase(taxon, site, NucleotideAlignmentConstants.getNucleotideDiploidByte(data[taxon].charAt(site)));
            }
        }
        return this;
    }

    public GenotypeCallTableBuilder setBases(String[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("BitAlignment: getInstance: data can not be empty.");
        }
        int numTaxa = data.length;
        int numSites = data[0].length;
        for (int site = 0; site < numSites; ++site) {
            if (data[0][0].contains(":")) {
                Pattern colon = Pattern.compile(":");
                for (int taxon = 0; taxon < numTaxa; ++taxon) {
                    if (data[taxon][site].equalsIgnoreCase("N:N")) {
                        this.setBase(taxon, site, (byte)-1);
                        continue;
                    }
                    if (data[taxon][site].equals("?") || data[taxon][site].equals("?:?")) {
                        this.setBase(taxon, site, (byte)-1);
                        continue;
                    }
                    String[] siteval = colon.split(data[taxon][site]);
                    byte first = NucleotideAlignmentConstants.getNucleotideAlleleByte(siteval[0]);
                    byte second = NucleotideAlignmentConstants.getNucleotideAlleleByte(siteval[1]);
                    this.setBase(taxon, site, (byte)(first << 4 | second));
                }
                continue;
            }
            for (int taxon = 0; taxon < numTaxa; ++taxon) {
                if (data[taxon][site].equalsIgnoreCase("N")) {
                    this.setBase(taxon, site, (byte)-1);
                    continue;
                }
                if (data[taxon][site].equals("?")) {
                    this.setBase(taxon, site, (byte)-1);
                    continue;
                }
                this.setBase(taxon, site, NucleotideAlignmentConstants.getNucleotideAlleleByte(data[taxon][site]));
            }
        }
        return this;
    }

    public GenotypeCallTableBuilder isPhased(boolean isPhased) {
        this.myIsPhased = isPhased;
        return this;
    }

    public GenotypeCallTableBuilder alleleEncodings(String[][] alleleEncodings) {
        this.myAlleleEncodings = alleleEncodings;
        return this;
    }

    public int getTaxaCount() {
        return this.myGenotype.getNumRows();
    }

    public int getSiteCount() {
        return this.myGenotype.getNumColumns();
    }

    public void reorderTaxa(int[] newIndices) {
        this.myGenotype.reorderRows(newIndices);
    }

    public void reorderPositions(int[] newIndices) {
        this.myGenotype.reorderColumns(newIndices);
    }

    public GenotypeCallTable build() {
        SuperByteMatrix temp = this.myGenotype;
        this.myGenotype = null;
        if (NucleotideAlignmentConstants.isNucleotideEncodings(this.myAlleleEncodings)) {
            return new NucleotideGenotypeCallTable(temp, this.myIsPhased);
        }
        return new ByteGenotypeCallTable(temp, this.myIsPhased, this.myAlleleEncodings);
    }

    public static GenotypeCallTable buildHDF5(String filename) {
        return HDF5ByteGenotypeCallTable.getInstance(HDF5Factory.openForReading((String)filename));
    }

    public static GenotypeCallTable buildHDF5(IHDF5Reader reader) {
        return HDF5ByteGenotypeCallTable.getInstance(reader);
    }
}

