/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;

class FilterGenotypeCallTable
extends AbstractGenotypeCallTable {
    private final GenotypeCallTable myBaseGenotype;
    private final boolean myIsTaxaFilter;
    private final boolean myIsSiteFilter;
    private final boolean myIsSiteFilterByRange;
    private final int[] myTaxaRedirect;
    private final int[] mySiteRedirect;
    private final int myRangeStart;
    private final int myRangeEnd;

    FilterGenotypeCallTable(GenotypeCallTable genotype, int numTaxa, int[] taxaRedirect, int numSites, int rangeStart, int rangeEnd) {
        super(numTaxa, numSites, genotype.isPhased(), null, genotype.maxNumAlleles());
        this.myBaseGenotype = genotype;
        this.myTaxaRedirect = taxaRedirect;
        this.myIsTaxaFilter = taxaRedirect != null;
        this.myIsSiteFilter = false;
        this.mySiteRedirect = null;
        this.myRangeStart = rangeStart;
        this.myRangeEnd = rangeEnd;
        this.myIsSiteFilterByRange = rangeStart != -1 && rangeEnd != -1;
    }

    FilterGenotypeCallTable(GenotypeCallTable genotype, int numTaxa, int[] taxaRedirect, int numSites, int[] siteRedirect) {
        super(numTaxa, numSites, genotype.isPhased(), null, genotype.maxNumAlleles());
        this.myBaseGenotype = genotype;
        this.myTaxaRedirect = taxaRedirect;
        this.myIsTaxaFilter = taxaRedirect != null;
        this.myRangeStart = -1;
        this.myRangeEnd = -1;
        this.myIsSiteFilterByRange = false;
        this.mySiteRedirect = siteRedirect;
        this.myIsSiteFilter = siteRedirect != null;
    }

    @Override
    public byte genotype(int taxon, int site) {
        int taxaIndex = this.translateTaxon(taxon);
        if (taxaIndex == -1) {
            return 15;
        }
        return this.myBaseGenotype.genotype(taxaIndex, this.translateSite(site));
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        int taxaIndex = this.translateTaxon(taxon);
        if (taxaIndex == -1) {
            return "N";
        }
        return this.myBaseGenotype.genotypeAsString(taxaIndex, this.translateSite(site));
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[][] alleleDefinitions() {
        String[][] encodings = this.myBaseGenotype.alleleDefinitions();
        if (encodings.length == 1) {
            return encodings;
        }
        if (this.myIsSiteFilterByRange || this.myIsSiteFilter) {
            int numSites = this.numberOfSites();
            String[][] result = new String[numSites][];
            for (int i = 0; i < numSites; ++i) {
                result[i] = this.alleleDefinitions(i);
            }
            return result;
        }
        return encodings;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        return this.myBaseGenotype.alleleDefinitions(this.translateSite(site));
    }

    @Override
    public int maxNumAlleles() {
        return this.myBaseGenotype.maxNumAlleles();
    }

    public int translateSite(int site) {
        if (this.myIsSiteFilterByRange) {
            return site + this.myRangeStart;
        }
        if (this.myIsSiteFilter) {
            return this.mySiteRedirect[site];
        }
        return site;
    }

    public int translateTaxon(int taxon) {
        if (this.myIsTaxaFilter) {
            return this.myTaxaRedirect[taxon];
        }
        return taxon;
    }
}

