/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import net.maizegenetics.dna.snp.genotypecall.AbstractGenotypeCallTable;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;
import org.apache.log4j.Logger;

class ByteGenotypeCallTable
extends AbstractGenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(ByteGenotypeCallTable.class);
    SuperByteMatrix myGenotype;
    private SuperByteMatrix mySiteInnerLoop;
    private SuperByteMatrix myTaxonInnerLoop;

    ByteGenotypeCallTable(byte[][] genotype, boolean phased, String[][] alleleEncodings) {
        super(genotype.length, genotype[0].length, phased, alleleEncodings);
        this.myGenotype = this.mySiteInnerLoop = SuperByteMatrixBuilder.getInstance(this.myTaxaCount, this.mySiteCount);
        for (int t = 0; t < this.myTaxaCount; ++t) {
            for (int s = 0; s < this.mySiteCount; ++s) {
                this.myGenotype.set(t, s, genotype[t][s]);
            }
        }
    }

    ByteGenotypeCallTable(SuperByteMatrix genotype, boolean phased, String[][] alleleEncodings) {
        super(genotype.getNumRows(), genotype.getNumColumns(), phased, alleleEncodings);
        if (genotype.isColumnInnerLoop()) {
            this.mySiteInnerLoop = genotype;
        } else {
            this.myTaxonInnerLoop = genotype;
        }
        this.myGenotype = genotype;
    }

    @Override
    public byte genotype(int taxon, int site) {
        return this.myGenotype.get(taxon, site);
    }

    @Override
    public byte[] genotypeForAllSites(int taxon) {
        return this.myGenotype.getAllColumns(taxon);
    }

    @Override
    public byte[] genotypeForSiteRange(int taxon, int start, int end) {
        return this.myGenotype.getColumnRange(taxon, start, end);
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        return this.myGenotype.getAllRows(site);
    }

    @Override
    public void transposeData(boolean siteInnerLoop) {
        if (siteInnerLoop) {
            if (this.mySiteInnerLoop == null) {
                this.mySiteInnerLoop = SuperByteMatrixBuilder.getInstanceTranspose(this.myTaxonInnerLoop);
            }
            this.myGenotype = this.mySiteInnerLoop;
        } else {
            if (this.myTaxonInnerLoop == null) {
                this.myTaxonInnerLoop = SuperByteMatrixBuilder.getInstanceTranspose(this.mySiteInnerLoop);
            }
            this.myGenotype = this.myTaxonInnerLoop;
        }
    }
}

