/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.depth;

import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.dna.snp.depth.HDF5AlleleDepth;
import net.maizegenetics.dna.snp.depth.MemoryAlleleDepth;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

public class AlleleDepthBuilder {
    private static final HDF5IntStorageFeatures HDF5_FEATURES = HDF5IntStorageFeatures.createDeflation((int)2);
    private List<SuperByteMatrix> myDepths = null;
    private final boolean myIsHDF5;
    private IHDF5Writer myHDF5Writer = null;
    private final int myMaxNumAlleles;
    private final int myNumSites;
    private int myNumTaxa = 0;

    private AlleleDepthBuilder(IHDF5Writer writer, int numSites, int maxNumAlleles) {
        this.myIsHDF5 = true;
        this.myHDF5Writer = writer;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
    }

    private AlleleDepthBuilder(int numSites, int maxNumAlleles) {
        this.myIsHDF5 = false;
        this.myHDF5Writer = null;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
        this.myDepths = new ArrayList<SuperByteMatrix>();
    }

    private AlleleDepthBuilder(int numTaxa, int numSites, int maxNumAlleles) {
        this.myIsHDF5 = false;
        this.myHDF5Writer = null;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
        this.myNumTaxa = numTaxa;
        this.myDepths = new ArrayList<SuperByteMatrix>();
        for (int i = 0; i < this.myNumTaxa; ++i) {
            this.myDepths.add(SuperByteMatrixBuilder.getInstance(this.myNumSites, this.myMaxNumAlleles));
        }
    }

    public static AlleleDepthBuilder getInstance(int numTaxa, int numSites, int maxNumAlleles) {
        return new AlleleDepthBuilder(numTaxa, numSites, maxNumAlleles);
    }

    public static AlleleDepthBuilder getNucleotideInstance(int numTaxa, int numSites) {
        return new AlleleDepthBuilder(numTaxa, numSites, 6);
    }

    public static AlleleDepthBuilder getHDF5NucleotideInstance(IHDF5Writer writer, int numSites) {
        return new AlleleDepthBuilder(writer, numSites, 6);
    }

    public static AlleleDepth getExistingHDF5Instance(IHDF5Reader reader) {
        if (!HDF5Utils.doesGenotypeDepthExist(reader)) {
            return null;
        }
        return new HDF5AlleleDepth(reader);
    }

    public AlleleDepthBuilder setDepth(int taxon, int site, byte allele, int depth) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("AlleleDepthBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        this.myDepths.get(taxon).set(site, allele, AlleleDepthUtil.depthIntToByte(depth));
        return this;
    }

    public AlleleDepthBuilder setDepth(int taxon, int[][] depths) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("AlleleDepthBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        int numAlleles = depths.length;
        if (numAlleles != this.myMaxNumAlleles) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepth: value number of alleles: " + numAlleles + " should have: " + this.myMaxNumAlleles);
        }
        int numSites = depths[0].length;
        if (numSites != this.myNumSites) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepth: value number of sites: " + numSites + " should have: " + this.myNumSites);
        }
        for (int a = 0; a < this.myMaxNumAlleles; ++a) {
            for (int s = 0; s < this.myNumSites; ++s) {
                this.setDepth(taxon, s, (byte)a, depths[s][a]);
            }
        }
        return this;
    }

    public AlleleDepthBuilder setDepthRangeForTaxon(int taxon, int siteOffset, byte[][] depths) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("AlleleDepthBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        int numAlleles = depths.length;
        if (numAlleles != this.myMaxNumAlleles) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepth: value number of alleles: " + numAlleles + " should have: " + this.myMaxNumAlleles);
        }
        for (int a = 0; a < this.myMaxNumAlleles; ++a) {
            for (int s = 0; s < depths[0].length; ++s) {
                this.setDepth(taxon, s + siteOffset, (byte)a, depths[a][s]);
            }
        }
        return this;
    }

    public AlleleDepthBuilder setDepth(int taxon, int site, byte allele, byte depth) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("AlleleDepthBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        this.myDepths.get(taxon).set(site, allele, depth);
        return this;
    }

    public AlleleDepthBuilder setDepth(int taxon, byte[][] depths) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("AlleleDepthBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        int numAlleles = depths.length;
        if (numAlleles != this.myMaxNumAlleles) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepth: value number of alleles: " + numAlleles + " should have: " + this.myMaxNumAlleles);
        }
        int numSites = depths[0].length;
        if (numSites != this.myNumSites) {
            throw new IllegalArgumentException("AlleleDepthBuilder: setDepth: value number of sites: " + numSites + " should have: " + this.myNumSites);
        }
        for (int a = 0; a < this.myMaxNumAlleles; ++a) {
            for (int s = 0; s < this.myNumSites; ++s) {
                this.setDepth(taxon, s, (byte)a, depths[a][s]);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlleleDepthBuilder addTaxon(Taxon taxon, byte[][] depths) {
        if (this.myIsHDF5) {
            if (depths == null || depths.length != 6) {
                throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Set A, C, G, T, -, + at once");
            }
            if (depths[0].length != this.myNumSites) {
                throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Number of sites: " + depths[0].length + " should be: " + this.myNumSites);
            }
            IHDF5Writer iHDF5Writer = this.myHDF5Writer;
            synchronized (iHDF5Writer) {
                HDF5Utils.writeHDF5GenotypesDepth(this.myHDF5Writer, taxon.getName(), depths);
            }
            ++this.myNumTaxa;
        } else {
            this.myDepths.add(SuperByteMatrixBuilder.getInstance(this.myNumSites, this.myMaxNumAlleles));
            this.setDepth(this.myNumTaxa, depths);
            ++this.myNumTaxa;
        }
        return this;
    }

    public AlleleDepthBuilder addTaxon(Taxon taxon, int[][] depths) {
        if (this.myIsHDF5) {
            int numAlleles = depths.length;
            if (depths == null || numAlleles != 6) {
                throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Set A, C, G, T, -, + at once");
            }
            if (depths[0].length != this.myNumSites) {
                throw new IllegalStateException("AlleleDepthBuilder: addTaxon: Number of sites: " + depths[0].length + " should be: " + this.myNumSites);
            }
            byte[][] result = new byte[numAlleles][this.myNumSites];
            for (int a = 0; a < numAlleles; ++a) {
                for (int s = 0; s < this.myNumSites; ++s) {
                    result[a][s] = AlleleDepthUtil.depthIntToByte(depths[a][s]);
                }
            }
            return this.addTaxon(taxon, result);
        }
        this.myDepths.add(SuperByteMatrixBuilder.getInstance(this.myNumSites, this.myMaxNumAlleles));
        this.setDepth(this.myNumTaxa, depths);
        ++this.myNumTaxa;
        return this;
    }

    public AlleleDepth build() {
        if (this.myIsHDF5) {
            IHDF5Writer reader = this.myHDF5Writer;
            this.myHDF5Writer = null;
            return new HDF5AlleleDepth((IHDF5Reader)reader);
        }
        SuperByteMatrix[] temp = new SuperByteMatrix[this.myDepths.size()];
        temp = this.myDepths.toArray(temp);
        this.myDepths = null;
        return new MemoryAlleleDepth(temp, this.myNumTaxa, this.myNumSites);
    }
}

