/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayDialog;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumComponent;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;

public class LinkageDiseqDisplayPlugin
extends AbstractDisplayPlugin {
    private int upperCorner = 0;
    private int lowerCorner = 2;
    private boolean blockSchematic = true;
    private boolean chromosomalView = false;
    private boolean includeLabels = true;

    public LinkageDiseqDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> LDInList = input.getDataOfType(LinkageDisequilibrium.class);
            if (LDInList.size() != 1) {
                String message = "Invalid selection.  Please select one LD result.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            LinkageDisequilibrium theLD = (LinkageDisequilibrium)LDInList.get(0).getData();
            if (this.isInteractive()) {
                try {
                    LinkageDiseqDisplayDialog myDialog = new LinkageDiseqDisplayDialog(this, theLD);
                    myDialog.setLocationRelativeTo(this.getParentFrame());
                    myDialog.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create LD plot " + ex);
                }
                catch (Error er) {
                    er.printStackTrace();
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Unable to create LD plot " + er);
                }
            } else if (this.getSaveFile() != null) {
                LinkageDisequilibriumComponent ldc = new LinkageDisequilibriumComponent(theLD, this.blockSchematic, this.chromosomalView, theLD.getSiteCount(), (int)Math.ceil((double)theLD.getSiteCount() / 2.0), (int)Math.ceil((double)theLD.getSiteCount() / 2.0));
                ldc.setUpperCorner(this.upperCorner);
                ldc.setLowerCorner(this.lowerCorner);
                ldc.setSize(this.getImageWidth(), this.getImageHeight());
                ldc.setShowLabels(this.includeLabels);
                this.saveDataToFile(ldc, this.getSaveFile());
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public int getUpperCorner() {
        return this.upperCorner;
    }

    public void setUpperCorner(int upperCorner) {
        this.upperCorner = upperCorner;
    }

    public int getLowerCorner() {
        return this.lowerCorner;
    }

    public void setLowerCorner(int lowerCorner) {
        this.lowerCorner = lowerCorner;
    }

    public boolean isBlockSchematic() {
        return this.blockSchematic;
    }

    public void setBlockSchematic(boolean blockSchematic) {
        this.blockSchematic = blockSchematic;
    }

    public void setShowLabels(boolean includeLabels) {
        this.includeLabels = includeLabels;
    }

    public boolean isChromosomalView() {
        return this.chromosomalView;
    }

    public void setChromosomalView(boolean chromosomalView) {
        this.chromosomalView = chromosomalView;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = LinkageDiseqDisplayPlugin.class.getResource("/net/maizegenetics/analysis/images/LDPlot.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "LD Plot";
    }

    @Override
    public String getToolTipText() {
        return "Display Linkage Disequilibrium";
    }
}

