/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class AGPMap {
    static final String namMarkers = "/Volumes/Macintosh HD 2/data/namgbs/NAM_Map_20090730.txt";
    static final String namMarkersV2 = "/Volumes/Macintosh HD 2/data/namgbs/markers061208agpv2.txt";
    int[] chrend = new int[10];
    int[] markerPosition;
    int[] markerChromosome;
    double[] markercm;
    String[] marker;
    File mapfile;

    public AGPMap() {
        this(new File(namMarkersV2), true);
    }

    public AGPMap(File mapfile) {
        this.mapfile = mapfile;
        this.loadMap();
    }

    public AGPMap(File mapfile, boolean useAgpV2) {
        this.mapfile = mapfile;
        if (useAgpV2) {
            this.loadMapAgpv2();
        } else {
            this.loadMap();
        }
    }

    private void loadMap() {
        try {
            int nRows = 0;
            BufferedReader br = new BufferedReader(new FileReader(this.mapfile));
            br.readLine();
            while (br.readLine() != null) {
                ++nRows;
            }
            br.close();
            this.markerPosition = new int[nRows];
            this.markercm = new double[nRows];
            this.marker = new String[nRows];
            this.markerChromosome = new int[nRows];
            br = new BufferedReader(new FileReader(this.mapfile));
            br.readLine();
            for (int i = 0; i < nRows; ++i) {
                String[] parsedLine = br.readLine().split("\t");
                int chr = Integer.parseInt(parsedLine[0]);
                this.chrend[chr - 1] = i;
                this.marker[i] = parsedLine[2];
                this.markercm[i] = Double.parseDouble(parsedLine[3]);
                this.markerPosition[i] = Integer.parseInt(parsedLine[4]);
                this.markerChromosome[i] = chr;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void loadMapAgpv2() {
        try {
            int nRows = 0;
            BufferedReader br = new BufferedReader(new FileReader(this.mapfile));
            br.readLine();
            while (br.readLine() != null) {
                ++nRows;
            }
            br.close();
            this.markerPosition = new int[nRows];
            this.markercm = new double[nRows];
            this.marker = new String[nRows];
            this.markerChromosome = new int[nRows];
            br = new BufferedReader(new FileReader(this.mapfile));
            br.readLine();
            for (int i = 0; i < nRows; ++i) {
                String[] parsedLine = br.readLine().split("\t");
                int chr = Integer.parseInt(parsedLine[1]);
                this.chrend[chr - 1] = i;
                this.marker[i] = parsedLine[0];
                this.markercm[i] = Double.parseDouble(parsedLine[2]);
                this.markerPosition[i] = Integer.parseInt(parsedLine[5]);
                this.markerChromosome[i] = chr;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Object[][] getInterval(int chromosome, int position) {
        int end = this.chrend[chromosome - 1];
        int start = chromosome == 1 ? 0 : this.chrend[chromosome - 2] + 1;
        if (position < this.markerPosition[start]) {
            return new Object[][]{{null, null}, {this.marker[start], this.markerPosition[start]}};
        }
        if (position > this.markerPosition[end]) {
            return new Object[][]{{this.marker[end], this.markerPosition[end]}, {null, null}};
        }
        if (position == this.markerPosition[start]) {
            return new Object[][]{{this.marker[start], this.markerPosition[start]}, {this.marker[start], this.markerPosition[start]}};
        }
        if (position == this.markerPosition[end]) {
            return new Object[][]{{this.marker[end], this.markerPosition[end]}, {this.marker[end], this.markerPosition[end]}};
        }
        int left = start;
        int right = end;
        while (right - left > 1) {
            int mid = left + (right - left) / 2;
            if (position == this.markerPosition[mid]) {
                return new Object[][]{{this.marker[mid], this.markerPosition[mid]}, {this.marker[mid], this.markerPosition[mid]}};
            }
            if (position < this.markerPosition[mid]) {
                right = mid;
                continue;
            }
            left = mid;
        }
        return new Object[][]{{this.marker[left], this.markerPosition[left]}, {this.marker[right], this.markerPosition[right]}};
    }

    public int[] getFlankingMarkerIndices(int chromosome, double geneticPosition) {
        int to;
        int ndx;
        int from = 0;
        if (chromosome > 1) {
            from = this.chrend[chromosome - 2] + 1;
        }
        if ((ndx = Arrays.binarySearch(this.markercm, from, to = this.chrend[chromosome - 1] + 1, geneticPosition)) < 0) {
            ndx = -(ndx + 1);
            return new int[]{ndx - 1, ndx};
        }
        return new int[]{ndx, ndx};
    }

    public double getCmFromPosition(int chromosome, int position) {
        int end = this.chrend[chromosome - 1];
        int start = chromosome == 1 ? 0 : this.chrend[chromosome - 2] + 1;
        if (position < this.markerPosition[start]) {
            double g2pRatio = (this.markercm[start + 10] - this.markercm[start]) / (double)(this.markerPosition[start + 10] - this.markerPosition[start]);
            return this.markercm[start] - (double)(this.markerPosition[start] - position) * g2pRatio;
        }
        if (position > this.markerPosition[end]) {
            double g2pRatio = (this.markercm[end] - this.markercm[end - 10]) / (double)(this.markerPosition[end] - this.markerPosition[end - 10]);
            return this.markercm[end] + (double)(position - this.markerPosition[end]) * g2pRatio;
        }
        if (position == this.markerPosition[start]) {
            return this.markercm[start];
        }
        if (position == this.markerPosition[end]) {
            return this.markercm[end];
        }
        int left = start;
        int right = end;
        while (right - left > 1) {
            int mid = left + (right - left) / 2;
            if (position == this.markerPosition[mid]) {
                return this.markercm[mid];
            }
            if (position < this.markerPosition[mid]) {
                right = mid;
                continue;
            }
            left = mid;
        }
        double g2pRatio = (this.markercm[right] - this.markercm[left]) / (double)(this.markerPosition[right] - this.markerPosition[left]);
        return this.markercm[left] + (double)(position - this.markerPosition[left]) * g2pRatio;
    }

    public int getPositionFromCm(int chromosome, double cM) {
        int end = this.chrend[chromosome - 1];
        int start = chromosome == 1 ? 0 : this.chrend[chromosome - 2] + 1;
        if (cM < this.markercm[start]) {
            double p2gRatio = (double)(this.markerPosition[start + 10] - this.markerPosition[start]) / (this.markercm[start + 10] - this.markercm[start]);
            return this.markerPosition[start] - (int)Math.round((this.markercm[start] - cM) * p2gRatio);
        }
        if (cM > this.markercm[end]) {
            double p2gRatio = (double)(this.markerPosition[end] - this.markerPosition[end - 10]) / (this.markercm[end] - this.markercm[end - 10]);
            return this.markerPosition[end] + (int)Math.round((cM - this.markercm[end]) * p2gRatio);
        }
        if (cM == this.markercm[start]) {
            return this.markerPosition[start];
        }
        if (cM == this.markercm[end]) {
            return this.markerPosition[end];
        }
        int left = start;
        int right = end;
        while (right - left > 1) {
            int mid = left + (right - left) / 2;
            if (cM == this.markercm[mid]) {
                return this.markerPosition[mid];
            }
            if (cM < this.markercm[mid]) {
                right = mid;
                continue;
            }
            left = mid;
        }
        double p2gRatio = (double)(this.markerPosition[right] - this.markerPosition[left]) / (this.markercm[right] - this.markercm[left]);
        return this.markerPosition[left] + (int)Math.round((cM - this.markercm[left]) * p2gRatio);
    }

    public double getFirstGeneticPosition(int chromosome) {
        if (chromosome == 1) {
            return this.markercm[0];
        }
        return this.markercm[this.chrend[chromosome - 2] + 1];
    }

    public double getLastGeneticPosition(int chromosome) {
        return this.markercm[this.chrend[chromosome - 1]];
    }

    public int getPhysPos(int markerIndex) {
        return this.markerPosition[markerIndex];
    }

    public double getGeneticPos(int markerIndex) {
        return this.markercm[markerIndex];
    }

    public static int getMarkerPosition(Object[] marker) {
        if (marker[1] == null) {
            return -1;
        }
        return (Integer)marker[1];
    }

    public static String getMarkerName(Object[] marker) {
        return (String)marker[0];
    }

    public static int getMarkerNumber(Object[] marker) {
        if (marker[0] == null) {
            return -1;
        }
        return Integer.parseInt(((String)marker[0]).substring(1));
    }
}

