/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TagCountToFastqPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(TagCountToFastqPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String inFileName;
    private DataInputStream inStream;
    private String outputFileName = null;
    private DataOutputStream outStream;
    private int nTags;
    private int tagLengthInLong;
    private long[] tag = new long[2];
    private int tagCount;
    private byte tagLength;
    private int tagsRead = 0;
    private int minCount = 0;

    public TagCountToFastqPlugin() {
        super(null, false);
    }

    public TagCountToFastqPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        myLogger.info((Object)"\n\n\nThe options for the TagCountToFastqPlugin are:\n-i Input binary tag count (*.cnt) file\n-o Output fastq file to use as input for BWA or bowtie2\n-c Minimum count of reads for a tag to be output (default: 1)\n\n\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input_file", true);
            this.myArgsEngine.add("-o", "--output_file", true);
            this.myArgsEngine.add("-c", "--min_count", true);
        }
        this.myArgsEngine.parse(args);
        if (this.myArgsEngine.getBoolean("-i")) {
            this.inFileName = this.myArgsEngine.getString("-i");
            File inFile = new File(this.inFileName);
            if (!inFile.isFile()) {
                this.printUsage();
                throw new IllegalArgumentException("Problem opening the input file: " + this.myArgsEngine.getString("-i"));
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an input file.\n");
        }
        Object var2_2 = null;
        if (!this.myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output file.");
        }
        this.outputFileName = this.myArgsEngine.getString("-o");
        this.minCount = this.myArgsEngine.getBoolean("-c") ? Integer.parseInt(this.myArgsEngine.getString("-c")) : 1;
    }

    @Override
    public DataSet performFunction(DataSet input) {
        try {
            this.inStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.inFileName), 655360));
            this.nTags = this.inStream.readInt();
            this.tagLengthInLong = this.inStream.readInt();
            myLogger.info((Object)("Opened the input file: " + this.inFileName + "  nTags=" + this.nTags));
            this.outStream = Utils.getDataOutputStream(this.outputFileName, 655360);
            int tagsWritten = 0;
            while (this.inStream.available() != 0) {
                this.readNextTag();
                if (this.tagCount >= this.minCount) {
                    this.writeFASTQ();
                    ++tagsWritten;
                }
                if (this.tagsRead % 500000 != 1) continue;
                System.out.printf("tagsRead=%d tagsWritten=%d %n", this.tagsRead, tagsWritten);
                myLogger.info((Object)BaseEncoder.getSequenceFromLong(this.tag));
            }
            this.outStream.flush();
            this.outStream.close();
            System.out.println("Finished converting binary tag count file to fastq.\nTotal number of tags read: " + this.tagsRead + "\nTotal number of tags written: " + tagsWritten + " (above minCount of " + this.minCount + ")" + "\nOuput fastq file: " + this.outputFileName + "\n\n");
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        return null;
    }

    private void readNextTag() {
        try {
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tag[j] = this.inStream.readLong();
            }
            this.tagLength = this.inStream.readByte();
            this.tagCount = this.inStream.readInt();
            ++this.tagsRead;
        }
        catch (IOException eof) {
            try {
                myLogger.info((Object)"Finished reading input file.");
                this.inStream.close();
                this.inStream = null;
            }
            catch (IOException eof2) {
                myLogger.info((Object)("Catch closing" + eof2));
                this.inStream = null;
            }
        }
    }

    private void writeFASTQ() {
        try {
            this.outStream.writeBytes("@length=" + this.tagLength + "count=" + this.tagCount + "\n");
            String tagSequence = BaseEncoder.getSequenceFromLong(this.tag);
            tagSequence = tagSequence.substring(0, this.tagLength);
            this.outStream.writeBytes(tagSequence + "\n+\n");
            for (int i = 0; i < this.tagLength; ++i) {
                this.outStream.writeBytes("f");
            }
            this.outStream.writeBytes("\n");
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }
}

